/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.ImporterBase;
import jp.advancesoft.chase.common.ConstParameters;
import org.apache.log4j.Logger;

class XYZImporter
extends ImporterBase {
    private static Logger logger = Logger.getLogger(XYZImporter.class.getName());
    private DecimalFormat formater = ConstParameters.formater;

    protected XYZImporter(File file, AtomCoords coords) {
        super(file, coords);
        this.list.clear();
    }

    public boolean importAtomCoords() {
        try {
            FileReader reader = new FileReader(this.file);
            BufferedReader br = new BufferedReader(reader);
            String str = new String();
            logger.info("parsing xyz file... " + this.file.getAbsolutePath());
            int NumAt = Integer.parseInt(br.readLine().trim());
            str = br.readLine().trim();
            for (int i = 0; i < NumAt; ++i) {
                str = br.readLine().trim();
                logger.debug("line " + i + ": " + str);
                String[] c = str.split("\\s+");
                String[] co = new String[3];
                String element = new String();
                if (c.length < 4) {
                    logger.warn("invalid data found at line " + i);
                    return false;
                }
                element = c[0];
                for (int j = 1; j < 4; ++j) {
                    try {
                        Double.parseDouble(c[j]);
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn("non-numerical data for coordinates found at line" + i);
                        return false;
                    }
                    co[j - 1] = c[j];
                }
                Atom atom = new Atom(element, co);
                this.list.addAtom(atom);
            }
        }
        catch (Exception exc) {
            logger.warn("invalid xyz file");
            return false;
        }
        return true;
    }

    public boolean importCell() {
        return true;
    }
}

