/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    private static byte[] defaultMessage = new byte[]{-112, -1, 0};

    public ShortMessage() {
        this(defaultMessage);
    }

    protected ShortMessage(byte[] data) {
        super(data);
    }

    public void setMessage(int status) throws InvalidMidiDataException {
        int dataLength = this.getDataLength(status);
        if (dataLength != 0) {
            throw new InvalidMidiDataException("Status byte; " + status + " requires " + dataLength + " data bytes");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(status);
            this.data = bos.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMessage(int status, int data1, int data2) throws InvalidMidiDataException {
        int dataLength = this.getDataLength(status);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(status);
            if (dataLength >= 1) {
                dos.writeByte(data1);
            }
            if (dataLength >= 2) {
                dos.writeByte(data2);
            }
            this.data = bos.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void setMessage(int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        int status = command & 0xF0 | channel & 0xF;
        int dataLength = this.getDataLength(status);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(status);
            if (dataLength >= 1) {
                dos.writeByte(data1);
            }
            if (dataLength >= 2) {
                dos.writeByte(data2);
            }
            this.data = bos.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getChannel() {
        int status = this.getStatus();
        return status & 0xF;
    }

    public int getCommand() {
        int status = this.getStatus();
        return status & 0xF0;
    }

    public int getData1() {
        int data1 = 0;
        try {
            int status = this.getStatus();
            int dataLength = this.getDataLength(status);
            if (dataLength < 1) {
                // empty if block
            }
            ByteArrayInputStream bas = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream das = new DataInputStream(bas);
            das.skip(1L);
            data1 = das.readUnsignedByte();
        }
        catch (InvalidMidiDataException iedm) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data1;
    }

    public int getData2() {
        int data2 = 0;
        try {
            int status = this.getStatus();
            int dataLength = this.getDataLength(status);
            if (dataLength < 2) {
                // empty if block
            }
            ByteArrayInputStream bas = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream das = new DataInputStream(bas);
            das.skip(2L);
            data2 = das.readUnsignedByte();
        }
        catch (InvalidMidiDataException iedm) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data2;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        ShortMessage event = new ShortMessage(newData);
        return event;
    }

    protected final int getDataLength(int status) throws InvalidMidiDataException {
        switch (status) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return 0;
            }
            case 241: 
            case 243: {
                return 1;
            }
            case 242: {
                return 2;
            }
        }
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + status);
    }
}

