/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.lang.reflect.Method;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Configuration;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.ExtendedConfigurationWrapper;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    protected AbstractBoot() {
    }

    protected Configuration createDefaultHierarchicalConfiguration(String staticConfig, String userConfig, boolean addSysProps) {
        HierarchicalConfiguration globalConfig = new HierarchicalConfiguration();
        if (staticConfig != null) {
            PropertyFileConfiguration rootProperty = new PropertyFileConfiguration();
            rootProperty.load(staticConfig);
            globalConfig.insertConfiguration(rootProperty);
            globalConfig.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (userConfig != null) {
            PropertyFileConfiguration baseProperty = new PropertyFileConfiguration();
            baseProperty.load(userConfig);
            globalConfig.insertConfiguration(baseProperty);
        }
        SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
        globalConfig.insertConfiguration(systemConfig);
        return globalConfig;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
            this.start();
        }
        return this.globalConfig;
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    protected abstract BootableProjectInfo getProjectInfo();

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    protected AbstractBoot loadBooter(String classname) {
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(classname);
            Method m = c.getMethod("getInstance", null);
            return (AbstractBoot)m.invoke(null, null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + classname);
            return null;
        }
    }

    protected abstract Configuration loadConfiguration();

    protected abstract void performBoot();

    public final void start() {
        AbstractBoot abstractBoot = this;
        synchronized (abstractBoot) {
            block13: {
                block12: {
                    if (this.isBootInProgress()) break block12;
                    if (!this.isBootDone()) break block13;
                }
                Object var2_2 = null;
                return;
            }
            this.bootInProgress = true;
        }
        BootableProjectInfo info = this.getProjectInfo();
        if (info != null) {
            Log.info(String.valueOf(info.getName()) + " " + info.getVersion());
            BootableProjectInfo[] childs = info.getDependencies();
            int i = 0;
            while (i < childs.length) {
                AbstractBoot boot = this.loadBooter(childs[i].getBootClass());
                if (boot != null) {
                    boot.start();
                }
                ++i;
            }
        }
        this.performBoot();
        AbstractBoot abstractBoot2 = this;
        synchronized (abstractBoot2) {
            this.bootInProgress = false;
            this.bootDone = true;
        }
    }
}

