/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.AtomInfoTable;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.ResidueInfoTable;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.ArrowPreferencePanel;
import AbinitMp.Viewer.AtomPreferenceWindow;
import AbinitMp.Viewer.DisplayPreference;
import AbinitMp.Viewer.FilePreferenceWindow;
import AbinitMp.Viewer.IsoPreferenceWindow;
import AbinitMp.Viewer.ResiduePreferenceWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class PreferenceWindow
extends BaseWindow {
    private JTextField scaleText;
    private MyComboBox radiusComboBox;
    private JTextField lineResolutionText;
    private JTextField caLineResolutionText;
    private JTextField ballResolutionText;
    private JTextField stickResolutionText;
    private JTextField CPKResolutionText;
    private JTextField tubeResolutionText;
    private JTextField ballRadiusText;
    private JTextField bondRadiusText;
    private JTextField stickRadiusText;
    private JTextField tubeRadiusText;
    private MyComboBox speedComboBox;
    private MyComboBox projectionComboBox;
    private int[] speed = new int[]{5000, 10000, 20000, 30000, 50000};
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private JColorChooser colorChooser;
    private AtomPreferenceWindow atomPreferenceWindow;
    private ResiduePreferenceWindow residuePreferenceWindow;
    private FilePreferenceWindow fragmentPreferenceWindow;
    private FilePreferenceWindow chainPreferenceWindow;
    private FilePreferenceWindow filePreferenceWindow;
    private FilePreferenceWindow dnaPreferenceWindow;
    private IsoPreferenceWindow isoPreferenceWindow;
    private ArrowPreferencePanel arrowPreferencePanel;
    private AbinitMpViewer viewer;

    public PreferenceWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("PreferenceWindow.Title"));
        this.viewer = abinitMpViewer;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("PreferenceWindow.fileMenuTitle", "PreferenceWindow.fileMenu", (Action)new fileListener()));
        this.openFileChooser = new JFileChooser(".");
        this.openFileChooser.setPreferredSize(new Dimension(500, 500));
        this.saveFileChooser = new JFileChooser(".");
        this.saveFileChooser.setPreferredSize(new Dimension(500, 500));
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel2 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel3 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel4 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel5 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel6 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel7 = new GridBagLayoutPanel();
        JTabbedPane jTabbedPane = new JTabbedPane(1, 1);
        this.speedComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("PreferenceWindow.speed.options"));
        gridBagLayoutPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.speed")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.speedComboBox, 5, 0, 5, 1, 1.0, 0.0);
        MyPanel myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.rotation"), myPanel);
        this.projectionComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("PreferenceWindow.policy.options"));
        gridBagLayoutPanel2.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.policy")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(this.projectionComboBox, 5, 0, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel2, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.projection"), myPanel);
        this.scaleText = new JTextField(5);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.connectAtom.scale")), 0, 0, 5, 1, 1.0, 0.0);
        this.radiusComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("PreferenceWindow.radius.options"));
        MyPanel myPanel2 = new MyPanel(new FlowLayout(1));
        myPanel2.add(this.scaleText);
        myPanel2.add(this.radiusComboBox);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, 0, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel3, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.connectAtom"), myPanel);
        this.lineResolutionText = new JTextField(5);
        this.caLineResolutionText = new JTextField(5);
        this.ballResolutionText = new JTextField(5);
        this.stickResolutionText = new JTextField(5);
        this.CPKResolutionText = new JTextField(5);
        this.tubeResolutionText = new JTextField(5);
        int n = 0;
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.lineResolution")), 0, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.lineResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(1-5)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.caLineResolution")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.caLineResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(1-5)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.ballResolution")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.ballResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(4-64)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.stickResolution")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.stickResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(4-64)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.cpkResolution")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.CPKResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(4-64)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.tubeResolution")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.tubeResolutionText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel("(4-64)"), 10, n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel4, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.resolution"), myPanel);
        this.ballRadiusText = new JTextField(5);
        this.bondRadiusText = new JTextField(5);
        this.stickRadiusText = new JTextField(5);
        this.tubeRadiusText = new JTextField(5);
        n = 0;
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.ballRadius")), 0, n, 10, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(this.ballRadiusText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel("(0.1-0.5)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.bondRadius")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(this.bondRadiusText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel("(0.1-0.5)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.stickRadius")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(this.stickRadiusText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel("(0.1-0.5)"), 10, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.tubeRadius")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(this.tubeRadiusText, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel("(0.1-2)"), 10, n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel5, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.radius"), myPanel);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton3 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton4 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton5 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton6 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton7 = new MyButton(MyResourceBundle.getResourceString("set"));
        MyButton myButton8 = new MyButton(MyResourceBundle.getResourceString("set"));
        buttonListener buttonListener2 = new buttonListener();
        myButton.addActionListener(buttonListener2);
        myButton2.addActionListener(buttonListener2);
        myButton3.addActionListener(buttonListener2);
        myButton4.addActionListener(buttonListener2);
        myButton5.addActionListener(buttonListener2);
        myButton6.addActionListener(buttonListener2);
        myButton7.addActionListener(buttonListener2);
        myButton8.addActionListener(buttonListener2);
        myButton.setActionCommand("b");
        myButton2.setActionCommand("a");
        myButton3.setActionCommand("r");
        myButton4.setActionCommand("f");
        myButton5.setActionCommand("c");
        myButton6.setActionCommand("l");
        myButton7.setActionCommand("d");
        myButton8.setActionCommand("i");
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("PreferenceWindow.background")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton, 5, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("atom")), 0, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton2, 5, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("residue")), 0, 2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton3, 5, 2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("fragment")), 0, 3, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton4, 5, 3, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("chain")), 0, 4, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton5, 5, 4, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("file")), 0, 5, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton6, 5, 5, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("dna")), 0, 6, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton7, 5, 6, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(new JLabel(MyResourceBundle.getResourceString("isosurface")), 0, 7, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myButton8, 5, 7, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(new BorderLayout());
        myPanel.add((Component)gridBagLayoutPanel6, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.color"), myPanel);
        myPanel = new MyPanel(new BorderLayout());
        this.arrowPreferencePanel = new ArrowPreferencePanel(abinitMpViewer);
        myPanel.add((Component)this.arrowPreferencePanel, "North");
        jTabbedPane.add(MyResourceBundle.getResourceString("PreferenceWindow.arrow"), myPanel);
        MyPanel myPanel3 = new MyPanel(new FlowLayout(1));
        MyButton myButton9 = new MyButton(MyResourceBundle.getResourceString("apply"));
        myPanel3.add(myButton9);
        myButton9.addActionListener(new applyListener());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)jTabbedPane, "Center");
        this.mainPanel.add((Component)myPanel3, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        Dimension dimension2 = this.getSize();
        this.setLocation(dimension.width - dimension2.width, 0);
        this.setPreference();
    }

    public void setPreference() {
        this.scaleText.setText(Float.toString(DisplayPreference.CONNECT_ATOM_SCALE));
        this.radiusComboBox.setSelectedIndex(DisplayPreference.CONNECT_ATOM_RADIUS);
        this.lineResolutionText.setText(Integer.toString(DisplayPreference.LINE_RESOLUTION));
        this.caLineResolutionText.setText(Integer.toString(DisplayPreference.CA_LINE_RESOLUTION));
        this.ballResolutionText.setText(Integer.toString(DisplayPreference.BALL_RESOLUTION));
        this.stickResolutionText.setText(Integer.toString(DisplayPreference.STICK_RESOLUTION));
        this.CPKResolutionText.setText(Integer.toString(DisplayPreference.CPK_RESOLUTION));
        this.tubeResolutionText.setText(Integer.toString(DisplayPreference.CA_TUBE_RESOLUTION));
        this.ballRadiusText.setText(Float.toString(DisplayPreference.BALL_RADIUS));
        this.bondRadiusText.setText(Float.toString(DisplayPreference.BALL_AND_STICK_RADIUS));
        this.stickRadiusText.setText(Float.toString(DisplayPreference.STICK_RADIUS));
        this.tubeRadiusText.setText(Float.toString(DisplayPreference.CA_TUBE_RADIUS));
        int n = 0;
        for (n = 0; n < 4 && DisplayPreference.ROTATION_SPEED != this.speed[n]; ++n) {
        }
        this.speedComboBox.setSelectedIndex(n);
        this.projectionComboBox.setSelectedIndex(DisplayPreference.PROJECTION);
        this.viewer.setBackgroundColor(DisplayPreference.backgroundColor);
        this.viewer.setProjection(DisplayPreference.PROJECTION);
        if (this.atomPreferenceWindow != null) {
            this.atomPreferenceWindow.setPreference();
        }
        if (this.residuePreferenceWindow != null) {
            this.residuePreferenceWindow.setPreference();
        }
        if (this.fragmentPreferenceWindow != null) {
            this.fragmentPreferenceWindow.setPreference(DisplayPreference.fragmentColor);
        }
        if (this.chainPreferenceWindow != null) {
            this.chainPreferenceWindow.setPreference(DisplayPreference.chainColor);
        }
        if (this.filePreferenceWindow != null) {
            this.filePreferenceWindow.setPreference(DisplayPreference.fileColor);
        }
        if (this.dnaPreferenceWindow != null) {
            this.dnaPreferenceWindow.setPreferenceDNA();
        }
        if (this.isoPreferenceWindow != null) {
            this.isoPreferenceWindow.setPreference();
        }
        this.arrowPreferencePanel.setPreference();
    }

    class applyListener
    extends AbstractAction {
        applyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = DisplayPreference.CONNECT_ATOM_SCALE;
            DisplayPreference.CONNECT_ATOM_SCALE = Float.parseFloat(PreferenceWindow.this.scaleText.getText());
            int n = DisplayPreference.CONNECT_ATOM_RADIUS;
            DisplayPreference.CONNECT_ATOM_RADIUS = PreferenceWindow.this.radiusComboBox.getSelectedIndex();
            if (f != DisplayPreference.CONNECT_ATOM_SCALE || n != DisplayPreference.CONNECT_ATOM_RADIUS) {
                PreferenceWindow.this.viewer.clearConnectTable();
            }
            DisplayPreference.PROJECTION = PreferenceWindow.this.projectionComboBox.getSelectedIndex();
            int n2 = Integer.parseInt(PreferenceWindow.this.lineResolutionText.getText());
            if (n2 < 0) {
                DisplayPreference.isNormalLine = true;
                if (n2 == -10) {
                    DisplayPreference.isPoligonLine = true;
                }
                n2 = -n2;
                PreferenceWindow.this.viewer.displayIsosurfaceNode();
            } else if (DisplayPreference.isNormalLine) {
                DisplayPreference.isNormalLine = false;
                DisplayPreference.isPoligonLine = false;
                PreferenceWindow.this.viewer.displayIsosurfaceNode();
            }
            DisplayPreference.LINE_RESOLUTION = n2;
            DisplayPreference.CA_LINE_RESOLUTION = Integer.parseInt(PreferenceWindow.this.caLineResolutionText.getText());
            DisplayPreference.BALL_RESOLUTION = Integer.parseInt(PreferenceWindow.this.ballResolutionText.getText());
            DisplayPreference.STICK_RESOLUTION = Integer.parseInt(PreferenceWindow.this.stickResolutionText.getText());
            DisplayPreference.CPK_RESOLUTION = Integer.parseInt(PreferenceWindow.this.CPKResolutionText.getText());
            DisplayPreference.CA_TUBE_RESOLUTION = Integer.parseInt(PreferenceWindow.this.tubeResolutionText.getText());
            DisplayPreference.BALL_RADIUS = Float.parseFloat(PreferenceWindow.this.ballRadiusText.getText());
            DisplayPreference.BALL_AND_STICK_RADIUS = Float.parseFloat(PreferenceWindow.this.bondRadiusText.getText());
            DisplayPreference.STICK_RADIUS = Float.parseFloat(PreferenceWindow.this.stickRadiusText.getText());
            DisplayPreference.CA_TUBE_RADIUS = Float.parseFloat(PreferenceWindow.this.tubeRadiusText.getText());
            int n3 = PreferenceWindow.this.speedComboBox.getSelectedIndex();
            DisplayPreference.ROTATION_SPEED = PreferenceWindow.this.speed[n3];
            PreferenceWindow.this.arrowPreferencePanel.getValue();
            PreferenceWindow.this.setWaitCursor();
            PreferenceWindow.this.viewer.setProjection(DisplayPreference.PROJECTION);
            PreferenceWindow.this.viewer.setRotationSpeed();
            PreferenceWindow.this.viewer.displayMoNode();
            PreferenceWindow.this.setDefaultCursor();
        }
    }

    class buttonListener
    extends AbstractAction {
        buttonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            String string = myButton.getActionCommand();
            char c = string.charAt(0);
            switch (c) {
                case 'b': {
                    Color color = DisplayPreference.backgroundColor;
                    color = JColorChooser.showDialog(myButton, "Color", color);
                    if (color == null) break;
                    DisplayPreference.backgroundColor = color;
                    PreferenceWindow.this.viewer.setBackgroundColor(color);
                    break;
                }
                case 'a': {
                    if (PreferenceWindow.this.atomPreferenceWindow == null) {
                        PreferenceWindow.this.atomPreferenceWindow = new AtomPreferenceWindow(PreferenceWindow.this.viewer);
                    }
                    PreferenceWindow.this.atomPreferenceWindow.setVisible(true);
                    break;
                }
                case 'r': {
                    if (PreferenceWindow.this.residuePreferenceWindow == null) {
                        PreferenceWindow.this.residuePreferenceWindow = new ResiduePreferenceWindow(PreferenceWindow.this.viewer);
                    }
                    PreferenceWindow.this.residuePreferenceWindow.setVisible(true);
                    break;
                }
                case 'f': {
                    if (PreferenceWindow.this.fragmentPreferenceWindow == null) {
                        PreferenceWindow.this.fragmentPreferenceWindow = new FilePreferenceWindow(PreferenceWindow.this.viewer, 4);
                    }
                    PreferenceWindow.this.fragmentPreferenceWindow.setVisible(true);
                    break;
                }
                case 'c': {
                    if (PreferenceWindow.this.chainPreferenceWindow == null) {
                        PreferenceWindow.this.chainPreferenceWindow = new FilePreferenceWindow(PreferenceWindow.this.viewer, 1);
                    }
                    PreferenceWindow.this.chainPreferenceWindow.setVisible(true);
                    break;
                }
                case 'l': {
                    if (PreferenceWindow.this.filePreferenceWindow == null) {
                        PreferenceWindow.this.filePreferenceWindow = new FilePreferenceWindow(PreferenceWindow.this.viewer, 0);
                    }
                    PreferenceWindow.this.filePreferenceWindow.setVisible(true);
                    break;
                }
                case 'd': {
                    if (PreferenceWindow.this.dnaPreferenceWindow == null) {
                        PreferenceWindow.this.dnaPreferenceWindow = new FilePreferenceWindow(PreferenceWindow.this.viewer, 5);
                    }
                    PreferenceWindow.this.dnaPreferenceWindow.setVisible(true);
                    break;
                }
                case 'i': {
                    if (PreferenceWindow.this.isoPreferenceWindow == null) {
                        PreferenceWindow.this.isoPreferenceWindow = new IsoPreferenceWindow(PreferenceWindow.this.viewer);
                    }
                    PreferenceWindow.this.isoPreferenceWindow.setVisible(true);
                }
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("PreferenceWindow.fileMenu");
            char c = string.charAt(0);
            if (PreferenceWindow.this.getNemonic(stringArray[0]) == c) {
                String string2;
                if (PreferenceWindow.this.openFileChooser.showOpenDialog(null) == 0 && DisplayPreference.openFile(string2 = PreferenceWindow.this.openFileChooser.getSelectedFile().getPath())) {
                    PreferenceWindow.this.setWaitCursor();
                    PreferenceWindow.this.setPreference();
                    PreferenceWindow.this.viewer.clearConnectTable();
                    PreferenceWindow.this.viewer.setRotationSpeed();
                    PreferenceWindow.this.viewer.displayMoNode();
                    PreferenceWindow.this.viewer.setBackgroundColor(DisplayPreference.backgroundColor);
                    PreferenceWindow.this.setDefaultCursor();
                }
            } else if (PreferenceWindow.this.getNemonic(stringArray[1]) == c) {
                if (PreferenceWindow.this.saveFileChooser.showSaveDialog(null) == 0) {
                    String string3 = PreferenceWindow.this.saveFileChooser.getSelectedFile().getPath();
                    DisplayPreference.saveFile(string3);
                }
            } else if (PreferenceWindow.this.getNemonic(stringArray[2]) == c) {
                DisplayPreference.setDefaults();
                AtomInfoTable.setDefaults();
                ResidueInfoTable.setDefaults();
                PreferenceWindow.this.setPreference();
                PreferenceWindow.this.setWaitCursor();
                PreferenceWindow.this.viewer.clearConnectTable();
                PreferenceWindow.this.viewer.setRotationSpeed();
                PreferenceWindow.this.viewer.displayMoNode();
                PreferenceWindow.this.setDefaultCursor();
            } else if (PreferenceWindow.this.getNemonic(stringArray[3]) == c) {
                PreferenceWindow.this.setVisible(false);
            }
        }
    }
}

