/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyResourceBundle;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DifferenceFilePanel
extends GridBagLayoutPanel {
    private int num = 7;
    private JTextField[] fileText = new JTextField[this.num];
    private JTextField[] coefficientText = new JTextField[this.num];
    private JFileChooser openFileChooser;

    public DifferenceFilePanel() {
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("den", "Grid file(Density)");
        this.openFileChooser = new JFileChooser(".");
        FileFilter fileFilter = this.openFileChooser.getFileFilter();
        this.openFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.openFileChooser.setPreferredSize(new Dimension(500, 500));
        MyButton[] myButtonArray = new MyButton[this.num];
        for (int i = 0; i < this.num; ++i) {
            myButtonArray[i] = new MyButton(MyResourceBundle.getResourceString("file"));
            myButtonArray[i].addActionListener(new openListener(i));
            this.fileText[i] = new JTextField(20);
            this.coefficientText[i] = new JTextField("1", 5);
            this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("file") + (1 + i)), 0, i, 5, 1, 1.0, 0.0);
            this.layoutObject(this.coefficientText[i], 5, i, 5, 1, 1.0, 0.0);
            this.layoutObject(this.fileText[i], 10, i, 5, 1, 1.0, 0.0);
            this.layoutObject(myButtonArray[i], 15, i, 5, 1, 1.0, 0.0);
        }
    }

    public String[] getFilenames() {
        String[] stringArray = new String[this.num];
        for (int i = 0; i < this.num; ++i) {
            stringArray[i] = this.fileText[i].getText().trim();
        }
        return stringArray;
    }

    public float[] getCoefficients() {
        float[] fArray = new float[this.num];
        for (int i = 0; i < this.num; ++i) {
            String string = this.coefficientText[i].getText().trim();
            fArray[i] = string != null ? Float.parseFloat(string) : 1.0f;
        }
        return fArray;
    }

    class openListener
    extends AbstractAction {
        int no;

        public openListener(int n) {
            this.no = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DifferenceFilePanel.this.openFileChooser.showOpenDialog(null) == 0) {
                String string = DifferenceFilePanel.this.openFileChooser.getSelectedFile().getPath();
                DifferenceFilePanel.this.fileText[this.no].setText(string);
            }
        }
    }
}

