/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Structure;

import AbinitMp.Structure.SceneViewer;
import AbinitMp.Structure.SimplePickingCallback;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Vector3d;

public class SimplePicking
extends PickMouseBehavior {
    protected SimplePickingCallback callback = null;
    private WakeupOnAWTEvent wm = new WakeupOnAWTEvent(48L);
    public static PickCanvas pickCanvas;
    private SceneViewer sceneViewer;
    private TransformGroup tGroup;
    public static final double[] canvasRacio;
    public static final double[] baseRacio;

    public SimplePicking(BranchGroup branchGroup, Canvas3D canvas3D, Bounds bounds) {
        super(canvas3D, branchGroup, bounds);
        this.sceneViewer = (SceneViewer)canvas3D;
        pickCanvas = new PickCanvas(canvas3D, branchGroup);
        pickCanvas.setMode(1024);
        pickCanvas.setTolerance(4.0f);
        this.setMode(256);
        this.setSchedulingBounds(bounds);
    }

    public void setupCallback(SimplePickingCallback simplePickingCallback) {
        this.callback = simplePickingCallback;
    }

    public void updateScene(int n, int n2) {
        if (this.mevent.getClickCount() == 1) {
            int n3 = this.mevent.getModifiers();
            pickCanvas.setShapeLocation(this.mevent);
            PickResult pickResult = null;
            try {
                pickResult = pickCanvas.pickClosest();
            }
            catch (Exception exception) {
                System.out.println("SimplePicking error");
                exception.printStackTrace(System.out);
            }
            if (pickResult == null) {
                if (this.mevent.isControlDown()) {
                    if ((n3 & 0x10) != 0) {
                        this.callback.clearHightSelection();
                    } else if ((n3 & 4) != 0) {
                        this.callback.clear();
                    }
                }
                return;
            }
            Node node = pickResult.getNode(4);
            if (node == null || node != null && node.getUserData() == null) {
                node = pickResult.getNode(1);
            }
            if (node instanceof Text2D && (n3 & 4) != 0) {
                this.sceneViewer.setMouseRotateEnable(false);
                this.tGroup = (TransformGroup)node.getUserData();
            }
            if ((n3 & 0x10) != 0) {
                if (node != null) {
                    this.callback.picked(0, node, this.mevent.isControlDown(), this.mevent.isShiftDown());
                } else if (this.mevent.isControlDown()) {
                    this.callback.clearHightSelection();
                }
            } else if ((n3 & 4) != 0) {
                if (node == null) {
                    if (this.mevent.isControlDown()) {
                        this.callback.clear();
                    }
                } else {
                    this.callback.popupAttributeWindow(node, this.mevent.isControlDown(), this.mevent.isShiftDown());
                }
            }
        }
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wm);
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupCriterion instanceof WakeupOnAWTEvent)) continue;
            WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)wakeupCriterion;
            AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
            for (int i = 0; i < aWTEventArray.length; ++i) {
                if (!(aWTEventArray[i] instanceof MouseEvent)) continue;
                this.mevent = (MouseEvent)aWTEventArray[i];
                if (this.mevent.getID() == 501) {
                    this.updateScene(this.mevent.getX(), this.mevent.getY());
                }
                if (this.mevent.getID() == 506 && this.tGroup != null) {
                    Dimension dimension = pickCanvas.getCanvas().getSize();
                    float f = (float)this.mevent.getX() / ((float)dimension.width - 10.0f);
                    float f2 = (float)this.mevent.getY() / ((float)dimension.height - 10.0f) + (float)(dimension.height / 2 - this.mevent.getY()) * 3.0E-5f;
                    Vector3d vector3d = SimplePicking.calcText3Dposition(f, f2);
                    Transform3D transform3D = new Transform3D();
                    this.tGroup.getTransform(transform3D);
                    transform3D.setTranslation(vector3d);
                    this.tGroup.setTransform(transform3D);
                    this.sceneViewer.setNewTextPosition(f, f2, this.tGroup);
                }
                if (this.mevent.getID() != 502) continue;
                this.tGroup = null;
                this.sceneViewer.setMouseRotateEnable(true);
            }
        }
        this.wakeupOn((WakeupCondition)this.wm);
    }

    public static Vector3d calcText3Dposition(float f, float f2) {
        Dimension dimension = pickCanvas.getCanvas().getSize();
        double d = baseRacio[0];
        double d2 = (double)dimension.width / (double)dimension.height;
        for (int i = 0; i < canvasRacio.length - 1; ++i) {
            if (!(d2 >= canvasRacio[i])) continue;
            d = baseRacio[i] - (d2 - canvasRacio[i]) / (canvasRacio[i + 1] - canvasRacio[i]) * (baseRacio[i + 1] - baseRacio[i]);
            break;
        }
        if (d2 < canvasRacio[canvasRacio.length - 1]) {
            d = canvasRacio[canvasRacio.length - 1];
        }
        double d3 = -0.047 + (double)f * 0.094;
        double d4 = d - (double)f2 * d * 2.0;
        Vector3d vector3d = new Vector3d(d3, d4, 2.3);
        return vector3d;
    }

    static {
        canvasRacio = new double[]{1.825, 1.719, 1.591, 1.497, 1.436, 1.403, 1.333, 1.257, 1.232, 1.196, 1.107, 0.989, 0.898, 0.831, 0.751, 0.698};
        baseRacio = new double[]{0.025, 0.027, 0.029, 0.031, 0.032, 0.033, 0.035, 0.037, 0.0377, 0.039, 0.042, 0.047, 0.052, 0.057, 0.062, 0.067};
    }
}

