/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class GaussianInputFile {
    public String filename = null;
    public String options = new String();
    public String route = new String();
    public String title = new String();
    public String charge = new String();
    public String molecule = new String();

    public GaussianInputFile() {
    }

    public GaussianInputFile(String string) throws Exception {
        this.readFile(string);
    }

    public void readFile(String string) throws Exception {
        File file = new File(string);
        long l = file.length();
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream), (int)l);
        String string2 = bufferedReader.readLine();
        while (string2.charAt(0) == '%') {
            this.options = this.options.concat(string2.substring(1)) + "\n";
            string2 = bufferedReader.readLine();
        }
        if (string2.charAt(0) == '#') {
            this.route = string2.substring(1) + "\n";
            string2 = bufferedReader.readLine();
            while (string2.length() != 0) {
                this.route = this.route.concat(string2 + "\n");
                string2 = bufferedReader.readLine();
            }
        }
        string2 = bufferedReader.readLine();
        this.title = string2.substring(1) + "\n";
        string2 = bufferedReader.readLine();
        while (string2.length() != 0) {
            this.title = this.title.concat(string2 + "\n");
            string2 = bufferedReader.readLine();
        }
        this.charge = string2 = bufferedReader.readLine();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            this.molecule = this.molecule.concat(string2 + "\n");
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        fileInputStream.close();
        this.filename = string;
    }

    public void saveFile(String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintStream printStream = new PrintStream(fileOutputStream);
        this.debugPrint(printStream);
        printStream.close();
        fileOutputStream.close();
    }

    public void set(String string, String string2, String string3, String string4, String string5) {
        this.options = string;
        this.route = string2;
        this.title = string3;
        this.charge = string4;
        this.molecule = string5;
    }

    public String getOptions() {
        return this.options;
    }

    public String getRoute() {
        return this.route;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCharge() {
        return this.charge;
    }

    public String getMolecule() {
        return this.molecule;
    }

    public void debugPrint(PrintStream printStream) {
        if (this.options.length() != 0) {
            printStream.print("%" + this.options.trim().replaceAll("\n", "\n%") + "\n");
        }
        printStream.print("#" + new String(this.route).trim() + "\n\n");
        printStream.print(new String(this.title).trim() + "\n\n");
        printStream.print(this.charge.trim() + "\n");
        printStream.print(new String(this.molecule).trim() + "\n");
    }

    public static void main(String[] stringArray) {
        try {
            GaussianInputFile gaussianInputFile = new GaussianInputFile(stringArray[0]);
            gaussianInputFile.saveFile("test.gjf");
            gaussianInputFile.debugPrint(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("error " + exception.getMessage());
        }
    }
}

