/*
 * Decompiled with CFR 0.152.
 */
package jas.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;

public class PercentLayout
implements LayoutManager2 {
    private Hashtable hash = new Hashtable();

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Constraint)) {
            throw new IllegalArgumentException("Invalid constraint");
        }
        this.hash.put(component, object);
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException("Invalid constraint");
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Constraint constraint = (Constraint)this.hash.get(component);
            Dimension dimension = component.getPreferredSize();
            n = (int)((double)n + (double)(dimension.width * 100) / constraint.width);
            n2 = (int)((double)n2 + (double)(dimension.height * 100) / constraint.height);
        }
        int n3 = this.hash.size();
        return new Dimension(n / n3, n2 / n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Constraint constraint = (Constraint)this.hash.get(component);
            Dimension dimension = component.getMinimumSize();
            int n3 = (int)((double)(dimension.width * 100) / constraint.width);
            int n4 = (int)((double)(dimension.height * 100) / constraint.height);
            if (n3 > n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            int n3;
            Component component = (Component)enumeration.nextElement();
            Constraint constraint = (Constraint)this.hash.get(component);
            Dimension dimension = component.getMaximumSize();
            int n4 = dimension.width == Integer.MAX_VALUE ? dimension.width : (int)((double)(dimension.width * 100) / constraint.width);
            int n5 = n3 = dimension.height == Integer.MAX_VALUE ? dimension.height : (int)((double)(dimension.height * 100) / constraint.height);
            if (n4 < n) {
                n = n4;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Constraint constraint = (Constraint)this.hash.get(component);
            int n = (int)((double)dimension.width * constraint.x / 100.0);
            int n2 = (int)((double)dimension.height * constraint.y / 100.0);
            int n3 = (int)((double)dimension.width * constraint.width / 100.0);
            int n4 = (int)((double)dimension.height * constraint.height / 100.0);
            component.setBounds(n, n2, n3, n4);
        }
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public static class Constraint {
        double x;
        double y;
        double width;
        double height;

        public Constraint(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }
    }
}

