/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Debug {
    private static File theStdOutFile;
    private static File theStdErrFile;
    private static final PrintWriter theConsoleOutWriter;
    private static final PrintWriter theConsoleErrWriter;
    private static PrintWriter theFileOutWriter;
    private static PrintWriter theFileErrWriter;
    private static final String theStdOutFileName = "stdout.txt";
    private static final String theStdErrFileName = "stderr.txt";
    private static final boolean debugMode = true;
    private static boolean debugInitialized;
    private static boolean redirectToFile;
    private static boolean oldRedirectValue;

    public static void init() {
        if (debugInitialized) {
            return;
        }
        try {
            theStdOutFile = new File(theStdOutFileName);
            theStdErrFile = new File(theStdErrFileName);
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(theStdOutFile)));
            PrintStream printStream2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(theStdErrFile)));
            theFileOutWriter = new PrintWriter(printStream, true);
            theFileErrWriter = new PrintWriter(printStream2, true);
        }
        catch (IOException iOException) {
            System.out.println("IOException initializing Debug system!");
            iOException.printStackTrace();
        }
        debugInitialized = true;
    }

    public static void setFileOutput() {
        redirectToFile = true;
    }

    public static void setNormalOutput() {
        redirectToFile = false;
    }

    public static void pushFileOutput() {
        oldRedirectValue = redirectToFile;
        redirectToFile = true;
    }

    public static void pushNormalOutput() {
        oldRedirectValue = redirectToFile;
        redirectToFile = false;
    }

    public static void popOutput() {
        redirectToFile = oldRedirectValue;
    }

    public static void say(String string) {
        Debug.init();
        if (redirectToFile) {
            theFileOutWriter.println(string);
        } else {
            theConsoleOutWriter.println(string);
        }
    }

    public static void complain(String string) {
        Debug.init();
        if (redirectToFile) {
            theFileErrWriter.println(string);
        } else {
            theConsoleErrWriter.println(string);
        }
    }

    public static void debugSay(String string) {
        Debug.say(string);
    }

    public static void debugComplain(String string) {
        Debug.complain(string);
    }

    static {
        theConsoleOutWriter = new PrintWriter(System.out, true);
        theConsoleErrWriter = new PrintWriter(System.err, true);
        debugInitialized = false;
        redirectToFile = false;
        oldRedirectValue = false;
    }
}

