/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.cybergarage.x3d.share.ShareObject;
import org.cybergarage.x3d.share.ShareWorld;
import org.cybergarage.x3d.util.Debug;

public class ShareWorldClient
extends ShareWorld {
    private Socket mSocket = null;
    private ObjectInputStream objIn;
    private ObjectOutputStream objOut;

    public ShareWorldClient() {
        this.setSocket(null);
        this.setObjectInputStream(null);
        this.setObjectInputStream(null);
    }

    public ShareWorldClient(String hostName, int port) {
        this();
        Socket socket = this.createSocket(hostName, port);
        this.setSocket(socket);
    }

    public ShareWorldClient(String hostName) {
        this(hostName, ShareWorldClient.getDefaultSeverSocketPort());
    }

    private Socket createSocket(String hostName, int port) {
        Socket socket = null;
        try {
            socket = new Socket(hostName, port);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return socket;
    }

    public void setSocket(Socket socket, boolean closeSocket) {
        if (closeSocket && this.isConnected()) {
            this.closeSocket();
        }
        this.mSocket = socket;
    }

    public void setSocket(Socket socket) {
        this.setSocket(socket, true);
    }

    public Socket getSocket() {
        return this.mSocket;
    }

    public boolean isConnected() {
        return this.getSocket() != null;
    }

    public void closeSocket() {
        Socket socket = this.getSocket();
        if (socket == null) {
            return;
        }
        try {
            ObjectOutputStream objOut;
            socket.close();
            this.setSocket(null, false);
            ObjectInputStream objIn = this.getObjectInputStream();
            if (objIn != null) {
                objIn.close();
                this.setObjectInputStream(null);
            }
            if ((objOut = this.getObjectOutputStream()) != null) {
                objOut.close();
                this.setObjectOutputStream(null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setObjectInputStream(ObjectInputStream in) {
        this.objIn = in;
    }

    public void setObjectOutputStream(ObjectOutputStream out) {
        this.objOut = out;
    }

    public ObjectInputStream getObjectInputStream() throws IOException {
        if (!this.isConnected()) {
            return null;
        }
        if (this.objIn == null) {
            this.objIn = new ObjectInputStream(this.getSocket().getInputStream());
        }
        return this.objIn;
    }

    public ObjectOutputStream getObjectOutputStream() throws IOException {
        if (!this.isConnected()) {
            return null;
        }
        if (this.objOut == null) {
            this.objOut = new ObjectOutputStream(this.getSocket().getOutputStream());
        }
        return this.objOut;
    }

    public boolean postShreObject(ShareObject shareObject) {
        if (!this.isConnected()) {
            return false;
        }
        Debug.message("postShreObject");
        try {
            ObjectOutputStream out = this.getObjectOutputStream();
            out.reset();
            out.writeObject(shareObject);
            shareObject.writeData(out);
            out.flush();
        }
        catch (Exception ioe) {
            Debug.warning("ShareWorldClient.postShreObject");
            Debug.warning(ioe.getMessage());
            return false;
        }
        Debug.message("  done");
        return true;
    }

    public ShareObject readShareObject() {
        Debug.message("readShareObject");
        if (!this.isConnected()) {
            return null;
        }
        ShareObject shareObject = null;
        try {
            ObjectInputStream in = this.getObjectInputStream();
            Debug.message("  in = " + in);
            shareObject = (ShareObject)in.readObject();
            Debug.message("  shareObject = " + shareObject);
            shareObject.readData(in);
            Debug.message("  readData");
            shareObject.update(this.getSceneGraph());
            Debug.message("  update");
        }
        catch (IOException ioe) {
            Debug.warning("ShareWorldClient.readShareObject - == IOException");
            Debug.warning("  IOException");
            this.closeSocket();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.warning("ShareWorldClient.readShareObject");
            Debug.warning("  ClassNotFoundException");
            this.setSocket(null);
        }
        Debug.message("  done");
        return shareObject;
    }

    public void execute() {
        if (!this.isConnected()) {
            return;
        }
        ShareObject shareObject = this.readShareObject();
        if (shareObject == null) {
            return;
        }
        shareObject.update(this.getSceneGraph());
    }
}

