/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.ConeNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class ConeNodeObject
extends TriangleArray
implements NodeObject {
    public ConeNodeObject(ConeNode node) {
        super(ConeNodeObject.getVertexCount(node), 35);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(18);
        this.createCone(node);
    }

    private static int getNDivide() {
        return 20;
    }

    private static int getVertexCount(ConeNode cone) {
        int count = 0;
        if (cone.getSide()) {
            count += ConeNodeObject.getNDivide();
        }
        if (cone.getBottom()) {
            count += ConeNodeObject.getNDivide();
        }
        return count *= 3;
    }

    public boolean initialize(Node node) {
        return true;
    }

    private void createCone(ConeNode cone) {
        int offset = 0;
        if (cone.getSide()) {
            this.createSide(cone, ConeNodeObject.getNDivide(), offset);
            offset += ConeNodeObject.getNDivide() * 3;
        }
        if (cone.getBottom()) {
            this.createBottom(cone, ConeNodeObject.getNDivide(), offset);
        }
    }

    private void createSide(ConeNode cone, int nDivide, int offset) {
        Point3f[] verts = new Point3f[nDivide * 3];
        Vector3f[] norms = new Vector3f[nDivide * 3];
        Point2f[] texCoords = new Point2f[nDivide * 3];
        float height = cone.getHeight();
        float radius = cone.getBottomRadius();
        for (int n = 0; n < nDivide; ++n) {
            float endAngle = (float)Math.PI * 2 / (float)nDivide * (float)n;
            float startAngle = (float)Math.PI * 2 / (float)nDivide * (float)(n + 1);
            float midAngle = (startAngle + endAngle) / 2.0f;
            float sx = (float)Math.cos(startAngle);
            float sz = (float)Math.sin(startAngle);
            float ex = (float)Math.cos(endAngle);
            float ez = (float)Math.sin(endAngle);
            float mx = (float)Math.cos(midAngle);
            float mz = (float)Math.sin(midAngle);
            verts[n * 3 + 0] = new Point3f(0.0f, height / 2.0f, 0.0f);
            verts[n * 3 + 1] = new Point3f(sx * radius, -height / 2.0f, sz * radius);
            verts[n * 3 + 2] = new Point3f(ex * radius, -height / 2.0f, ez * radius);
            norms[n * 3 + 0] = new Vector3f(mx, 0.0f, mz);
            norms[n * 3 + 0].normalize();
            norms[n * 3 + 1] = new Vector3f(sx, 0.0f, sz);
            norms[n * 3 + 1].normalize();
            norms[n * 3 + 2] = new Vector3f(ex, 0.0f, ez);
            norms[n * 3 + 2].normalize();
            texCoords[n * 3 + 0] = new Point2f((float)(n + (n + 1)) / 2.0f / (float)nDivide, 1.0f);
            texCoords[n * 3 + 1] = new Point2f((float)(n + 1) / (float)nDivide, 0.0f);
            texCoords[n * 3 + 2] = new Point2f((float)n / (float)nDivide, 0.0f);
        }
        this.setCoordinates(offset, verts);
        this.setNormals(offset, norms);
        this.setTextureCoordinates(offset, texCoords);
    }

    private float cosValueToTexCoordX(float cosValue) {
        return (cosValue + 1.0f) / 2.0f;
    }

    private float sinValueToTexCoordY(float sinValue) {
        return 0.5f - sinValue / 2.0f;
    }

    private void createBottom(ConeNode cone, int nDivide, int offset) {
        Point3f[] verts = new Point3f[nDivide * 3];
        Vector3f[] norms = new Vector3f[nDivide * 3];
        Point2f[] texCoords = new Point2f[nDivide * 3];
        float height = cone.getHeight();
        float radius = cone.getBottomRadius();
        for (int n = 0; n < nDivide; ++n) {
            float startAngle = (float)Math.PI * 2 / (float)nDivide * (float)n;
            float endAngle = (float)Math.PI * 2 / (float)nDivide * (float)(n + 1);
            float sx = (float)Math.cos(startAngle);
            float sz = (float)Math.sin(startAngle);
            float ex = (float)Math.cos(endAngle);
            float ez = (float)Math.sin(endAngle);
            verts[n * 3 + 0] = new Point3f(0.0f, -height / 2.0f, 0.0f);
            verts[n * 3 + 1] = new Point3f(sx * radius, -height / 2.0f, sz * radius);
            verts[n * 3 + 2] = new Point3f(ex * radius, -height / 2.0f, ez * radius);
            norms[n * 3 + 0] = new Vector3f(0.0f, -1.0f, 0.0f);
            norms[n * 3 + 1] = new Vector3f(0.0f, -1.0f, 0.0f);
            norms[n * 3 + 2] = new Vector3f(0.0f, -1.0f, 0.0f);
            texCoords[n * 3 + 0] = new Point2f(0.5f, 0.5f);
            texCoords[n * 3 + 1] = new Point2f(this.cosValueToTexCoordX(sx), this.sinValueToTexCoordY(sz));
            texCoords[n * 3 + 2] = new Point2f(this.cosValueToTexCoordX(ex), this.sinValueToTexCoordY(ez));
        }
        this.setCoordinates(offset, verts);
        this.setNormals(offset, norms);
        this.setTextureCoordinates(offset, texCoords);
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

