/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.process;

import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.process.ProcessManager;
import ciss.phase_viewer.ssh.Execute;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;

public class ProcessViewer
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(ProcessViewer.class.getName());
    private final int REFRESH = 5000;
    private Timer timer;
    private JList list;
    private DefaultListModel listModel;
    private int x = 650;
    private int y = 450;
    private int locX = 200;
    private int locY = 150;
    private MyMessageBox mbox = new MyMessageBox();
    private JButton btnreload = new JButton("reload");
    private JButton btnclose = new JButton("close");
    private JButton btnkillTerm = new JButton("kill  -TERM");
    private JButton btnkillKill = new JButton("kill  -KILL");
    private ProcessManager processManager;
    private int pidIndex = 0;
    private Vector process;
    private JScrollPane scrPane;
    private Vector procvec;
    private boolean isRemote = false;
    private Execute execute;
    private String username;

    public ProcessViewer() {
        super("process viewer", true, true, true, true);
        this.init();
    }

    public ProcessViewer(Execute execute, String username) {
        super("process viewer", true, true, true, true);
        this.execute = execute;
        this.username = username;
        this.isRemote = true;
        this.init();
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = null;
        super.dispose();
    }

    private void init() {
        this.setSize(this.x, this.y);
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        this.listModel = new DefaultListModel();
        this.processManager = new ProcessManager(this.execute, this.username);
        this.process = this.processManager.getProcess();
        if (this.process != null) {
            this.timer = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ProcessViewer.this.redraw();
                }
            });
        }
        cont.add(this.createListModelAndList());
        cont.add(this.createButtonsPanel());
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent e) {
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                ProcessViewer.this.execute.disconnect();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            public void internalFrameIconified(InternalFrameEvent e) {
            }

            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
    }

    public void start() {
        logger.debug("process viewer start");
        this.timer.start();
    }

    private JPanel createProcessViewer() {
        JPanel p = new JPanel();
        return p;
    }

    private JPanel createButtonsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.btnreload);
        p.add(this.btnclose);
        p.add(this.btnkillTerm);
        p.add(this.btnkillKill);
        this.btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessViewer.this.dispose();
            }
        });
        this.btnreload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessViewer.this.redraw();
            }
        });
        this.btnkillTerm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessViewer.this.processManager.killProcess(ProcessViewer.this.getPID(ProcessViewer.this.list.getSelectedIndex()), "TERM");
                ProcessViewer.this.redraw();
            }
        });
        this.btnkillKill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessViewer.this.processManager.killProcess(ProcessViewer.this.getPID(ProcessViewer.this.list.getSelectedIndex()), "KILL");
                ProcessViewer.this.redraw();
            }
        });
        return p;
    }

    private void redraw() {
        if (this.process != null) {
            this.process.clear();
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.process = this.processManager.getProcess();
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.clear();
        if (this.process != null) {
            for (int i = 1; i < this.process.size(); ++i) {
                model.addElement(this.process.get(i));
            }
        } else {
            logger.error("process is null!");
        }
    }

    private int getPID(int selected) {
        String psstring = (String)this.listModel.get(selected);
        StringTokenizer st = new StringTokenizer(psstring);
        Vector<String> vector = new Vector<String>();
        int ret = 0;
        while (st.hasMoreTokens()) {
            vector.addElement(st.nextToken());
        }
        try {
            ret = Integer.parseInt((String)vector.get(this.pidIndex));
        }
        catch (NumberFormatException ne) {
            this.mbox.setText("failed to get PID");
            ret = -1;
        }
        return ret;
    }

    private JPanel createListModelAndList() {
        if (this.process != null) {
            for (int i = 1; i < this.process.size(); ++i) {
                this.listModel.addElement(this.process.get(i));
            }
        }
        this.list = new JList(this.listModel);
        this.list.setFont(new Font("Monospaced", 0, 12));
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        String title = "";
        try {
            title = (String)this.process.get(0);
        }
        catch (ArrayIndexOutOfBoundsException aio) {
            logger.error("invalid output");
            this.dispose();
        }
        catch (NullPointerException npe) {
            logger.error("invalid output");
            this.dispose();
        }
        StringTokenizer st = new StringTokenizer(title);
        int count = 0;
        while (st.hasMoreTokens() && !st.nextToken().trim().equalsIgnoreCase("PID")) {
            ++count;
        }
        this.pidIndex = count;
        this.scrPane = new JScrollPane(this.list);
        this.scrPane.setPreferredSize(new Dimension(this.x - 20, this.y - 90));
        JPanel p = new JPanel();
        TitledBorder border = new TitledBorder(title);
        border.setTitleFont(new Font("Monospaced", 0, 12));
        p.setBorder(border);
        p.add(this.scrPane);
        return p;
    }
}

