/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.main;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class PluginLoader
extends ClassLoader {
    private static Logger logger = Logger.getLogger(PluginLoader.class.getName());
    public static String plugindir = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "plugins";

    protected Class findClass(String name) {
        String className = name.replace('.', File.separatorChar);
        logger.debug("loading: " + className);
        byte[] classData = this.getClassDataFrom(plugindir + System.getProperty("file.separator") + className + ".class");
        return this.defineClass(name, classData, 0, classData.length);
    }

    protected URL findResource(String name) {
        String resourcePath = name.replace('/', File.separatorChar);
        resourcePath = plugindir + System.getProperty("file.separator") + resourcePath;
        URL url = null;
        try {
            url = new URL("file://localhost/" + resourcePath);
        }
        catch (MalformedURLException ex) {
            logger.error("failed to get resource: " + resourcePath);
        }
        return url;
    }

    public static Object instantiate(String path, Object[] args) {
        logger.debug("trying " + path);
        PluginLoader pl = new PluginLoader();
        Object obj = null;
        try {
            Class<?> cla = pl.loadClass(path);
            Constructor<?>[] constructor = cla.getDeclaredConstructors();
            obj = constructor[0].newInstance(args);
        }
        catch (Exception ex) {
            logger.error("failed to load class: " + path);
            ex.printStackTrace();
        }
        return obj;
    }

    public static URL getPluginResource(String name) {
        String resourcePath = name.replace('/', File.separatorChar);
        resourcePath = plugindir + System.getProperty("file.separator") + resourcePath;
        URL url = null;
        try {
            url = new URL("file://localhost/" + resourcePath);
        }
        catch (MalformedURLException ex) {
            logger.error("failed to get resource: " + resourcePath);
        }
        return url;
    }

    private byte[] getClassDataFrom(String className) {
        try {
            FileInputStream fi = new FileInputStream(className);
            byte[] result = new byte[fi.available()];
            fi.read(result);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

