/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterfaceBlock;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceData;
import ciss.phase_viewer.inputinterface.InputInterfaceDefaults;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import ciss.phase_viewer.inputinterface.UndoRedo;
import ciss.phase_viewer.inputinterface.UndoRedoListener;
import ciss.phase_viewer.inputinterface.Utils;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InputInterface
implements Serializable,
Input {
    public static String __ROOT__ = "rootBlock";
    private InputInterfaceBlock list = new InputInterfaceBlock();
    private static Logger logger = Logger.getLogger(InputInterface.class.getName());
    private int blockDepth;
    private PrintWriter writer;
    private String indent = "    ";
    private int restartAt = 1;
    private Stack restartAts;
    private String[] defaultName;
    private String[] defaultValue;
    private String fileName;
    private InputInterfaceTableSpec[] specs;
    private InputInterfaceTableSpecManager manager;
    private Vector changeListeners = new Vector();
    private Vector blockChangeListeners = new Vector();
    private UndoRedo undoRedo;
    private boolean updateUndoStack = true;
    private boolean stateChanged = false;
    private boolean writeNullValue = false;
    private boolean genLockFileOnSave = false;
    private String string;
    protected boolean block = false;
    private boolean writeDelimitedByColon = false;
    protected boolean iSavedIt = false;

    public InputInterface() {
        this.list.add(null);
        this.list.setName("root block");
        this.undoRedo = new UndoRedo(this);
    }

    public void setGenerateLockFileOnSave(boolean genLockFileOnSave) {
        this.genLockFileOnSave = genLockFileOnSave;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setUpdateUndoStack(boolean updateUndoStack) {
        this.updateUndoStack = updateUndoStack;
    }

    public void undo() {
        this.undoRedo.undo();
    }

    public void redo() {
        this.undoRedo.redo();
    }

    protected void clearUndoRedo() {
        this.undoRedo.clear();
    }

    public void addUndoRedoListener(UndoRedoListener listener) {
        this.undoRedo.addUndoRedoListener(listener);
    }

    private void blockChanged(String tag, InputInterfaceBlock block, InputInterfaceBlockChangeListener source) {
        InputInterfaceBlockChangeEvent event = new InputInterfaceBlockChangeEvent(tag, block, source, this);
        for (int i = 0; i < this.blockChangeListeners.size(); ++i) {
            InputInterfaceBlockChangeListener listener = (InputInterfaceBlockChangeListener)this.blockChangeListeners.elementAt(i);
            listener.inputInterfaceBlockChanged(event);
        }
    }

    private void entryChanged(String tag, InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        InputInterfaceEntryChangeEvent event = new InputInterfaceEntryChangeEvent(tag, entry, source, this);
        if (this.updateUndoStack) {
            this.undoRedo.addEntry(tag, entry);
            this.stateChanged = true;
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            logger.debug(" foobar " + i + " called from " + this.changeListeners.elementAt(i).getClass());
            listener.inputInterfaceEntryChanged(event);
        }
    }

    protected void initialize() {
        this.selectRoot();
        InputInterfaceBlock root = this.getCurrentBlock();
        root.init("root block");
        this.undoRedo.clear();
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            listener.inputInterfaceInitializing();
        }
    }

    protected void intialized() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            InputInterfaceEntryChangeListener listener = (InputInterfaceEntryChangeListener)this.changeListeners.elementAt(i);
            listener.inputInterfaceInitialized();
        }
    }

    public void addInputInterfaceEntryChangeListener(InputInterfaceEntryChangeListener listener) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            if (this.changeListeners.get(i) != listener) continue;
            return;
        }
        logger.debug("adding listener: " + listener.getClass());
        this.changeListeners.addElement(listener);
    }

    public void addInputInterfaceBlockChangeListener(InputInterfaceBlockChangeListener listener) {
        for (int i = 0; i < this.blockChangeListeners.size(); ++i) {
            if (this.blockChangeListeners.get(i) != listener) continue;
            return;
        }
        this.blockChangeListeners.addElement(listener);
    }

    public void removeInputInterfaceEntryChangeListener(InputInterfaceEntryChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void removeInputInterfaceBlockChangeListener(InputInterfaceBlockChangeListener listener) {
        this.blockChangeListeners.remove(listener);
    }

    public void selectAndCreateBlock(String blockName) {
        String[] array = blockName.split("\\.");
        if (array != null) {
            this.selectAndCreateBlock(array, array.length);
        }
    }

    public void selectAndCreateBlock(String[] blockNames, int depth) {
        int bdepth = depth;
        if (depth > blockNames.length) {
            bdepth = blockNames.length;
        }
        String blName = "";
        for (int i = 0; i < bdepth; ++i) {
            String ident = blockNames[i];
            blName = blName.trim().length() == 0 ? ident : blName + "." + ident;
            if (this.selectBlock(ident)) continue;
            logger.debug("creating block: " + blName);
            this.addBlock(new InputInterfaceBlock(ident, blName));
        }
    }

    public InputInterfaceTable getInputInterfaceTable(String blockName) {
        this.selectRoot();
        String[] fullName = blockName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length);
        return this.getTable();
    }

    public InputInterfacePrimitiveEntry getInputInterfacePrimitiveEntry(String entryName) {
        this.selectRoot();
        String[] fullName = entryName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length - 1);
        return this.getPrimitiveEntry(fullName[fullName.length - 1]);
    }

    private String getParentTag(String[] tag) {
        String ret = "";
        for (int i = 0; i < tag.length - 1; ++i) {
            ret = ret + tag[i];
        }
        return ret;
    }

    public InputInterfaceUnits getInputInterfaceUnits(String unitName) {
        this.selectRoot();
        String[] fullName = unitName.split("\\.");
        this.selectAndCreateBlock(fullName, fullName.length - 1);
        return this.getUnits();
    }

    public void addBlock(InputInterfaceBlock block, boolean select) {
        if (block.size() == 0) {
            block.addFirst(this.list);
        } else {
            block.set(0, this.list);
        }
        this.list.addLast(block);
        if (select) {
            this.selectBlock(block.getName(), null);
        }
    }

    public void addBlock(InputInterfaceBlock block) {
        if (block.size() == 0) {
            block.addFirst(this.list);
        } else {
            block.set(0, this.list);
        }
        this.list.addLast(block);
        this.selectBlock(block.getName(), null);
    }

    private void addEntry(InputInterfaceEntry entry) {
        this.list.addLast(entry);
        int type = entry.getEntryType();
        if (type == 1) {
            this.list.setHasTable(true);
        }
        if (type == 2) {
            this.list.setHasDefaults(true);
        }
        if (type == 3) {
            this.list.setHasUnits(true);
        }
    }

    public void replaceBlock(InputInterfaceBlock block, InputInterfaceBlockChangeListener caller) {
        boolean found = false;
        this.replaceBlock(block);
        this.blockChanged(block.getFullName(), block, caller);
    }

    public void replaceBlock(InputInterfaceBlock block) {
        boolean found = false;
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() || !data.getName().trim().equalsIgnoreCase(block.getName())) continue;
            logger.debug("replacing block: " + data);
            this.list.remove(i);
            this.list.add(i, block);
            if (block.size() != 0) {
                block.set(0, this.list);
            } else {
                block.add(this.list);
            }
            found = true;
            break;
        }
        if (!found) {
            this.addBlock(block, false);
        }
    }

    public void replaceEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source, boolean callListener) {
        int type = entry.getEntryType();
        String name = entry.getName();
        for (int i = 0; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data == null || data.isBlock()) continue;
            InputInterfaceEntry en = (InputInterfaceEntry)data;
            if (!data.getName().trim().equalsIgnoreCase(name) || type != en.getEntryType()) continue;
            this.list.remove(i);
            boolean badd = true;
            if (type == 0) {
                InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
                badd = pentry.getValue() != null && pentry.getValue().trim().length() != 0;
            } else if (type == 1) {
                InputInterfaceTable tentry = (InputInterfaceTable)entry;
                boolean bl = badd = tentry.getTableData() != null && tentry.getTableData().size() != 0;
            }
            if (badd) {
                if (type == 3 || type == 2) {
                    logger.debug("adding entry at top of list for units & defaults.");
                    this.list.add(1, entry);
                } else {
                    logger.debug("adding entry at bottom of list for primitive entries & tables.");
                    this.list.addLast(entry);
                }
                logger.debug("replacing entry..." + this.list.getFullName() + "." + entry.getName());
                if (callListener && source != null) {
                    this.entryChanged(this.list.getFullName(), entry, source);
                }
            }
            return;
        }
        logger.debug("adding entry..." + this.list.getFullName() + "." + entry.getName());
        this.addEntry(entry);
        if (callListener && source != null) {
            this.entryChanged(this.list.getFullName(), entry, source);
        }
    }

    public void replaceEntry(InputInterfaceEntry entry) {
        this.replaceEntry(entry, null, true);
    }

    public void replaceEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        this.replaceEntry(entry, source, true);
    }

    public void removeEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source) {
        this.removeEntry(entry, source, true);
    }

    public void removeEntry(InputInterfaceEntry entry) {
        this.removeEntry(entry, null, true);
    }

    public void removeEntry(InputInterfaceEntry entry, InputInterfaceEntryChangeListener source, boolean callListener) {
        int type = entry.getEntryType();
        String name = entry.getName();
        for (int i = 0; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data == null || data.isBlock()) continue;
            InputInterfaceEntry en = (InputInterfaceEntry)data;
            if (!data.getName().trim().equalsIgnoreCase(name) || type != en.getEntryType()) continue;
            this.list.remove(i);
            if (callListener) {
                this.entryChanged(this.list.getFullName(), entry, source);
            }
            return;
        }
    }

    public void removeBlock(InputInterfaceBlock block) {
        this.list.remove(block);
    }

    public void removeBlock(String name) {
        for (int i = 0; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data == null || !data.isBlock() || !data.getName().equals(name)) continue;
            ((InputInterfaceBlock)data).remove(0);
            this.list.remove(data);
        }
    }

    public boolean selectParentBlock() {
        if (this.list.get(0) != null) {
            this.list = (InputInterfaceBlock)this.list.get(0);
            return true;
        }
        return false;
    }

    public boolean selectBlock(String blockName) {
        return this.selectBlock(blockName, "\\.");
    }

    public boolean selectBlock(String blockName, String delimiter) {
        if (blockName == __ROOT__) {
            this.selectRoot();
            return true;
        }
        String[] decomp = null;
        if (delimiter == null || delimiter.trim().length() == 0) {
            decomp = new String[]{blockName};
        } else {
            decomp = blockName.split(delimiter);
            if (decomp == null) {
                return false;
            }
        }
        if (decomp.length > 1) {
            this.selectRoot();
        }
        for (int i = 0; i < decomp.length; ++i) {
            String ident = decomp[i];
            if (!this.selectBlockSub(ident)) {
                logger.debug("couldn't select block: " + ident);
                return false;
            }
            logger.debug("selected block: " + ident);
        }
        return true;
    }

    private boolean selectBlockSub(String blockName) {
        for (int i = 1; i < this.list.size(); ++i) {
            String name;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            logger.debug("name of data .... " + data.getName());
            if (!data.isBlock() || !(name = data.getName()).trim().equalsIgnoreCase(blockName)) continue;
            this.list = (InputInterfaceBlock)data;
            return true;
        }
        return false;
    }

    public InputInterfaceBlock getCurrentBlock() {
        return this.list;
    }

    public InputInterfacePrimitiveEntry getPrimitiveEntry(String name) {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            logger.debug("at getPrimitiveEntry: got data: " + data.getName());
            if (!data.getName().trim().equalsIgnoreCase(name) || data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 0) continue;
            return (InputInterfacePrimitiveEntry)entry;
        }
        InputInterfacePrimitiveEntry ent = new InputInterfacePrimitiveEntry();
        ent.setName(name);
        this.addEntry(ent);
        return ent;
    }

    public InputInterfacePrimitiveEntry[] getAllPrimitiveEntries() {
        int i;
        Vector<InputInterfacePrimitiveEntry> entries = new Vector<InputInterfacePrimitiveEntry>();
        for (i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 0) continue;
            entries.addElement((InputInterfacePrimitiveEntry)entry);
        }
        if (entries.size() == 0) {
            return null;
        }
        InputInterfacePrimitiveEntry[] ret = new InputInterfacePrimitiveEntry[entries.size()];
        for (i = 0; i < entries.size(); ++i) {
            ret[i] = (InputInterfacePrimitiveEntry)entries.get(i);
        }
        return ret;
    }

    public InputInterfaceTable getTable() {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 1) continue;
            return (InputInterfaceTable)entry;
        }
        logger.debug("getCurrentBlock().getFullName(): " + this.getCurrentBlock().getFullName());
        InputInterfaceTableColumns[] cols = null;
        if (this.manager != null) {
            logger.debug("obtaining table spec...");
            InputInterfaceTableSpec tspec = this.manager.getTableSpec(this.list.getFullName());
            if (tspec != null) {
                logger.debug("obtaining columns");
                cols = tspec.getTableColumns();
            }
        }
        InputInterfaceTable ta = new InputInterfaceTable(this.getCurrentBlock().getName(), null, cols, new Vector());
        this.replaceEntry(ta);
        return ta;
    }

    public InputInterfaceDefaults getDefaults() {
        if (!this.list.hasDefaults()) {
            return null;
        }
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 2) continue;
            return (InputInterfaceDefaults)entry;
        }
        return null;
    }

    public InputInterfaceDefaults getDefaults(String name) {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.getName().trim().equalsIgnoreCase(name) || data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 2) continue;
            return (InputInterfaceDefaults)entry;
        }
        return new InputInterfaceDefaults();
    }

    public InputInterfaceUnits getUnits() {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (entry = (InputInterfaceEntry)data).getEntryType() != 3) continue;
            return (InputInterfaceUnits)entry;
        }
        return new InputInterfaceUnits();
    }

    public void selectRoot() {
        if (this.selectParentBlock()) {
            this.selectRoot();
        }
    }

    public InputInterfaceBlock getRootList() {
        this.selectRoot();
        return this.list;
    }

    public boolean stateChanged() {
        return this.stateChanged;
    }

    public void setState(boolean stateChanged) {
        this.stateChanged = stateChanged;
    }

    public String toString() {
        logger.debug("obtaining string representation of 'inputinterface'...");
        this.blockDepth = 0;
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        this.writer = null;
        this.string = "";
        this.saveSub();
        return this.string;
    }

    public void save() {
        this.saveTo(new File(this.fileName));
    }

    public void save(boolean recreate) {
        this.saveTo(new File(this.fileName), recreate);
    }

    public void saveTo(File file) {
        this.saveTo(file, false);
    }

    private void deb(InputInterfaceBlock block) {
        if (!this.hasData(block)) {
            return;
        }
        ++this.blockDepth;
        String ws = this.getWhiteSpace(this.blockDepth);
        logger.debug(ws + block.getName() + "{");
        if (this.writer != null) {
            this.writer.println(ws + block.getName() + "{");
        } else {
            this.string = this.string + ws + block.getName() + "{" + System.getProperty("line.separator");
        }
        if (block.hasUnits()) {
            this.writeUnits(block, this.blockDepth);
        }
        if (block.hasDefaults()) {
            this.writeDefaults(block, this.blockDepth);
        }
        for (int i = 1; i < block.size(); ++i) {
            String foo;
            InputInterfaceData dat = (InputInterfaceData)block.get(i);
            if (dat.isBlock()) {
                this.deb((InputInterfaceBlock)dat);
                continue;
            }
            if (!(dat instanceof InputInterfaceEntry) || (foo = this.toString((InputInterfaceEntry)dat)) == null) continue;
            logger.debug(foo);
            if (this.writer != null) {
                this.writer.println(foo);
                continue;
            }
            this.string = this.string + foo + System.getProperty("line.separator");
        }
        --this.blockDepth;
        logger.debug(ws + "}");
        if (this.writer != null) {
            this.writer.println(ws + "}");
        } else {
            this.string = this.string + ws + "}" + System.getProperty("line.separator");
        }
    }

    private boolean hasData(InputInterfaceBlock block) {
        for (int i = 1; i < block.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (!data.isBlock()) {
                InputInterfacePrimitiveEntry pent;
                InputInterfaceEntry entry = (InputInterfaceEntry)data;
                if (entry.getEntryType() == 1) {
                    boolean[] val = ((InputInterfaceTable)entry).getValidColumns();
                    boolean bl = false;
                    for (int ii = 0; ii < val.length; ++ii) {
                        if (!val[ii]) continue;
                        bl = true;
                    }
                    if (!bl) {
                        continue;
                    }
                } else if (entry.getEntryType() == 0 ? (pent = (InputInterfacePrimitiveEntry)entry).getValue() == null || pent.getValue().trim().length() == 0 : entry.getEntryType() == 3) continue;
                return true;
            }
            boolean bl = this.hasData((InputInterfaceBlock)data);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file, boolean recreate) {
        FileStateObserver.generateLockFile(file.getParentFile());
        this.block = true;
        this.blockDepth = 0;
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        logger.info("saving input to: " + file);
        try {
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (int i = 1; i < this.list.size(); ++i) {
                InputInterfaceData data = (InputInterfaceData)this.list.get(i);
                if (!data.isBlock()) continue;
                this.deb((InputInterfaceBlock)data);
            }
            logger.info("input saved.");
            this.writer.close();
            this.iSavedIt = !recreate;
        }
        catch (Exception exc) {
            try {
                logger.warn("file in use?");
                exc.printStackTrace();
                this.writer.close();
                this.iSavedIt = !recreate;
            }
            catch (Throwable throwable) {
                this.writer.close();
                this.iSavedIt = !recreate;
                throw throwable;
            }
        }
        this.selectRoot();
        this.block = false;
        this.stateChanged = false;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileStateObserver.removeLockFile(file.getParentFile());
    }

    private boolean currBlockHasData() {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock()) {
                InputInterfacePrimitiveEntry pent;
                InputInterfaceEntry entry = (InputInterfaceEntry)data;
                if (entry.getEntryType() == 1) {
                    boolean[] val = ((InputInterfaceTable)entry).getValidColumns();
                    boolean bl = false;
                    for (int ii = 0; ii < val.length; ++ii) {
                        if (!val[ii]) continue;
                        bl = true;
                    }
                    if (!bl) {
                        continue;
                    }
                } else if (entry.getEntryType() == 0 ? (pent = (InputInterfacePrimitiveEntry)entry).getValue() == null || pent.getValue().trim().length() == 0 : entry.getEntryType() == 3) continue;
                return true;
            }
            this.selectBlock(data.getName());
            if (this.currBlockHasData()) {
                this.selectParentBlock();
                return true;
            }
            this.selectParentBlock();
        }
        return false;
    }

    private void saveSub() {
        try {
            for (int i = this.restartAt; i < this.list.size(); ++i) {
                InputInterfaceData data = (InputInterfaceData)this.list.get(i);
                String name = data.getName();
                if (data.isBlock()) {
                    ++this.blockDepth;
                    this.selectBlock(name, null);
                    Integer ii = new Integer(i + 1);
                    this.restartAts.push(ii);
                    logger.debug("entering block: " + name);
                    logger.debug("pushed: " + ii);
                    boolean bool = this.currBlockHasData();
                    if (!bool) {
                        this.endBlockWrite();
                        this.saveSub();
                    } else {
                        this.writeBlock((InputInterfaceBlock)data);
                        if (((InputInterfaceBlock)data).hasUnits()) {
                            this.writeUnits();
                        }
                        if (((InputInterfaceBlock)data).hasDefaults()) {
                            this.writeDefaults();
                        }
                        this.restartAt = 1;
                        this.saveSub();
                    }
                } else {
                    InputInterfaceEntry entry = (InputInterfaceEntry)data;
                    if (this.blockDepth == 0 && data.getName().trim().length() == 0) {
                        logger.debug("something is wrong....");
                    } else {
                        this.writeEntry(entry);
                        if (i != this.list.size() - 1) continue;
                        this.endBlockWrite();
                        this.saveSub();
                    }
                }
                break;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void endBlockWrite() {
        logger.debug("exiting block: " + this.list.getName());
        if (this.currBlockHasData()) {
            this.writeBlockEnd();
        }
        if (!this.selectParentBlock()) {
            return;
        }
        logger.debug("re-entering block: " + this.list.getName());
        --this.blockDepth;
        logger.debug("blockDepth at this point: " + this.blockDepth);
        this.restartAt = (Integer)this.restartAts.pop();
        logger.debug("poped: " + this.restartAt);
        if (this.restartAt == this.list.size()) {
            this.endBlockWrite();
        }
    }

    private void writeBlock(InputInterfaceBlock block) {
        String whiteSpace = this.getWhiteSpace();
        if (block.getName().equals("wavefunction_solver")) {
            logger.debug("getTags(): ");
            String[] tgs = this.getTags();
            logger.debug("num tags: " + tgs.length);
            for (int i = 0; i < tgs.length; ++i) {
                logger.debug("tag: " + tgs[i]);
            }
        }
        if (this.writer != null) {
            this.writer.println(whiteSpace + block.getName() + "{");
        } else {
            this.string = this.string + whiteSpace + block.getName() + "{" + System.getProperty("line.separator");
        }
    }

    private String toString(InputInterfaceEntry entry) {
        String whiteSpace = this.getWhiteSpace(this.blockDepth);
        int type = entry.getEntryType();
        if (entry.ignoreMe()) {
            return null;
        }
        if (type == 0) {
            InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
            String name = primitive.getName();
            String value = primitive.getValueDelimitedBy();
            if (this.writeDelimitedByColon) {
                value = primitive.getValue();
            }
            if (primitive.isDoubleQuoted()) {
                value = "\"" + value + "\"";
            }
            boolean writeThis = false;
            if (this.writeNullValue) {
                writeThis = name != null && name.trim().length() != 0 && value != null;
            } else {
                boolean bl = writeThis = name != null && name.trim().length() != 0 && value != null && value.trim().length() != 0;
            }
            if (writeThis) {
                return whiteSpace + this.indent + name + " = " + value + " " + primitive.getUnit();
            }
        } else if (type == 1) {
            InputInterfaceTable table = (InputInterfaceTable)entry;
            String[] idents = table.getColumnIdentifiers();
            String identString = whiteSpace + this.indent + "#tag";
            boolean[] bcols = table.getValidColumns();
            if (idents != null) {
                for (int i = 0; i < idents.length; ++i) {
                    if (!bcols[i]) continue;
                    identString = identString + " " + idents[i];
                }
                Vector tableData = table.getTableData();
                String dataString = whiteSpace + this.indent;
                InputInterfaceTableSpec spec = null;
                try {
                    spec = this.manager.getTableSpec(this.list.getFullName());
                }
                catch (Exception exc) {
                    // empty catch block
                }
                for (int i = 0; i < tableData.size(); ++i) {
                    String[] row = (String[])tableData.get(i);
                    if (!InputInterfaceTable.isValidRow(row)) continue;
                    for (int j = 0; j < row.length; ++j) {
                        if (!bcols[j]) continue;
                        String dat = row[j];
                        if (spec != null && spec.getTableColumn(idents[j]).isFirstLetterCaps()) {
                            dat = Utils.firstLetterCaps(dat);
                        }
                        dataString = row[j] != null && row[j].length() != 0 ? dataString + " " + dat : dataString + " *";
                    }
                    if (i >= tableData.size() - 1) continue;
                    dataString = dataString + System.getProperty("line.separator") + whiteSpace + this.indent;
                }
                return identString + System.getProperty("line.separator") + dataString;
            }
        }
        return null;
    }

    private void writeEntry(InputInterfaceEntry entry) {
        String whiteSpace = this.getWhiteSpace();
        int type = entry.getEntryType();
        if (entry.ignoreMe()) {
            return;
        }
        if (type == 0) {
            InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
            String name = primitive.getName();
            String value = primitive.getValueDelimitedBy();
            if (this.writeDelimitedByColon) {
                value = primitive.getValue();
            }
            if (primitive.isDoubleQuoted()) {
                value = "\"" + value + "\"";
            }
            boolean writeThis = false;
            if (this.writeNullValue) {
                writeThis = name != null && name.trim().length() != 0 && value != null;
            } else {
                boolean bl = writeThis = name != null && name.trim().length() != 0 && value != null && value.trim().length() != 0;
            }
            if (writeThis) {
                if (this.writer != null) {
                    this.writer.println(whiteSpace + this.indent + name + " = " + value + " " + primitive.getUnit());
                } else {
                    this.string = this.string + whiteSpace + this.indent + name + " = " + value + " " + primitive.getUnit() + System.getProperty("line.separator");
                }
            }
        } else if (type == 1) {
            InputInterfaceTable table = (InputInterfaceTable)entry;
            String[] idents = table.getColumnIdentifiers();
            String identString = whiteSpace + this.indent + "#tag";
            boolean[] bcols = table.getValidColumns();
            if (idents != null) {
                for (int i = 0; i < idents.length; ++i) {
                    if (!bcols[i]) continue;
                    identString = identString + " " + idents[i];
                }
                Vector tableData = table.getTableData();
                String dataString = whiteSpace + this.indent;
                InputInterfaceTableSpec spec = null;
                try {
                    spec = this.manager.getTableSpec(this.list.getFullName());
                }
                catch (Exception exc) {
                    // empty catch block
                }
                for (int i = 0; i < tableData.size(); ++i) {
                    String[] row = (String[])tableData.get(i);
                    if (!InputInterfaceTable.isValidRow(row)) continue;
                    for (int j = 0; j < row.length; ++j) {
                        if (!bcols[j]) continue;
                        String dat = row[j];
                        if (spec != null && spec.getTableColumn(idents[j]).isFirstLetterCaps()) {
                            dat = Utils.firstLetterCaps(dat);
                        }
                        dataString = row[j] != null && row[j].length() != 0 ? dataString + " " + dat : dataString + " *";
                    }
                    if (i >= tableData.size() - 1) continue;
                    dataString = dataString + System.getProperty("line.separator") + whiteSpace + this.indent;
                }
                if (this.writer != null) {
                    this.writer.println(identString + System.getProperty("line.separator") + dataString);
                } else {
                    this.string = this.string + identString + System.getProperty("line.separator") + dataString + System.getProperty("line.separator");
                }
            }
        }
    }

    private void writeUnits(InputInterfaceBlock block, int bld) {
        String whiteSpace = this.getWhiteSpace(bld);
        for (int i = 1; i < block.size(); ++i) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (data.isBlock() || (type = (entry = (InputInterfaceEntry)data).getEntryType()) != 3) continue;
            InputInterfaceUnits units = (InputInterfaceUnits)entry;
            String[] un = units.getUnits();
            String unitString = whiteSpace + this.indent + "#units";
            for (int j = 0; j < un.length; ++j) {
                unitString = unitString + " " + un[j];
            }
            if (this.writer != null) {
                this.writer.println(unitString);
                continue;
            }
            this.string = this.string + unitString + System.getProperty("line.separator");
        }
    }

    private void writeDefaults(InputInterfaceBlock block, int bld) {
        String whiteSpace = this.getWhiteSpace(bld);
        for (int i = 1; i < block.size(); ++i) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (data.isBlock() || (type = (entry = (InputInterfaceEntry)data).getEntryType()) != 2) continue;
            InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
            String[] de = defs.getDefaults();
            String defString = whiteSpace + this.indent + "#default";
            for (int j = 0; j < de.length; ++j) {
                defString = defString + " " + de[j];
                if (j >= de.length - 1) continue;
                defString = defString + ",";
            }
            if (this.writer != null) {
                this.writer.println(defString);
                continue;
            }
            this.string = this.string + defString + System.getProperty("line.separator");
        }
    }

    private void writeUnits() {
        String whiteSpace = this.getWhiteSpace();
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (type = (entry = (InputInterfaceEntry)data).getEntryType()) != 3) continue;
            InputInterfaceUnits units = (InputInterfaceUnits)entry;
            String[] un = units.getUnits();
            String unitString = whiteSpace + this.indent + "#units";
            for (int j = 0; j < un.length; ++j) {
                unitString = unitString + " " + un[j];
            }
            if (this.writer != null) {
                this.writer.println(unitString);
                continue;
            }
            this.string = this.string + unitString + System.getProperty("line.separator");
        }
    }

    private void writeDefaults() {
        String whiteSpace = this.getWhiteSpace();
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceEntry entry;
            int type;
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock() || (type = (entry = (InputInterfaceEntry)data).getEntryType()) != 2) continue;
            InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
            String[] de = defs.getDefaults();
            String defString = whiteSpace + this.indent + "#default";
            for (int j = 0; j < de.length; ++j) {
                defString = defString + " " + de[j];
                if (j >= de.length - 1) continue;
                defString = defString + ",";
            }
            if (this.writer != null) {
                this.writer.println(defString);
                continue;
            }
            this.string = this.string + defString + System.getProperty("line.separator");
        }
    }

    private void writeBlockEnd() {
        if (this.list.get(0) != null) {
            if (this.writer != null) {
                this.writer.println(this.getWhiteSpace() + "}");
            } else {
                this.string = this.string + this.getWhiteSpace() + "}" + System.getProperty("line.separator");
            }
        }
    }

    private String getWhiteSpace(int depth) {
        String ret = "";
        for (int i = 0; i < depth - 1; ++i) {
            ret = ret + this.indent;
        }
        return ret;
    }

    private String getWhiteSpace() {
        String string = new String();
        for (int i = 0; i < this.blockDepth - 1; ++i) {
            string = string + this.indent;
        }
        return string;
    }

    public void scanList() {
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        logger.debug("scanning list ...");
        this.scan();
    }

    public String[] getTags() {
        int i;
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        for (i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            names.addElement(data.getName());
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            for (i = 0; i < names.size(); ++i) {
                ret[i] = (String)names.get(i);
            }
        }
        return ret;
    }

    public InputInterfaceData[] getAllEntries() {
        InputInterfaceData[] ret = new InputInterfaceData[this.list.size() - 1];
        for (int i = 1; i < this.list.size(); ++i) {
            ret[i - 1] = (InputInterfaceData)this.list.get(i);
        }
        return ret;
    }

    public String[] getBlockTags() {
        int i;
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        for (i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock()) continue;
            names.addElement(data.getName());
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            for (i = 0; i < names.size(); ++i) {
                ret[i] = (String)names.get(i);
            }
        }
        return ret;
    }

    public InputInterfaceBlock getBlock(String name) {
        for (int i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (!data.isBlock() || !data.getName().trim().equalsIgnoreCase(name)) continue;
            return (InputInterfaceBlock)data;
        }
        return null;
    }

    public int getBlockCount() {
        String[] blocks = this.getBlockTags();
        if (blocks == null) {
            return 0;
        }
        return blocks.length;
    }

    public int getPrimitiveEntryCount() {
        InputInterfacePrimitiveEntry[] pes = this.getAllPrimitiveEntries();
        if (pes == null) {
            return 0;
        }
        return pes.length;
    }

    public String[] getEntryTags() {
        int i;
        String[] ret = null;
        Vector<String> names = new Vector<String>();
        for (i = 1; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            if (data.isBlock()) continue;
            names.addElement(data.getName());
        }
        if (names.size() > 0) {
            ret = new String[names.size()];
            for (i = 0; i < names.size(); ++i) {
                ret[i] = (String)names.get(i);
            }
        }
        return ret;
    }

    private void scan() {
        this.scan(false);
    }

    private void scan(InputInterfaceBlock block, boolean replace) {
        String blname = block.getFullName();
        for (int i = 1; i < block.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            String name = data.getName();
            if (data.isBlock()) {
                this.scan((InputInterfaceBlock)data, replace);
                continue;
            }
            InputInterfaceEntry entry = (InputInterfaceEntry)data;
            int type = entry.getEntryType();
            if (type == 0) {
                InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
                logger.debug("    token: ");
                logger.debug("        name: " + primitive.getName());
                logger.debug("        value: " + primitive.getValue());
                logger.debug("        unit: " + primitive.getUnit());
            } else if (type == 1) {
                int ii;
                InputInterfaceTable table = (InputInterfaceTable)entry;
                String[] tableIdentifiers = table.getTableIdentifiers();
                Vector tableData = table.getTableData();
                if (replace && block.hasDefaults()) {
                    tableIdentifiers = this.getUniqueIdentifiers(this.defaultName, tableIdentifiers);
                    table.setTableIdentifiers(tableIdentifiers);
                    this.expandTableData(tableData, tableIdentifiers.length);
                    Vector<String[]> replaceVector = new Vector<String[]>();
                    for (int j = 0; j < tableIdentifiers.length; ++j) {
                        for (int jj = 0; jj < this.defaultName.length; ++jj) {
                            if (!tableIdentifiers[j].trim().equalsIgnoreCase(this.defaultName[jj].trim())) continue;
                            replaceVector.addElement(new String[]{Integer.toString(j), this.defaultValue[jj]});
                        }
                    }
                    for (int ii2 = 0; ii2 < tableData.size(); ++ii2) {
                        String[] cols = (String[])tableData.get(ii2);
                        for (int j = 0; j < replaceVector.size(); ++j) {
                            String[] rep = (String[])replaceVector.get(j);
                            int irep = Integer.parseInt(rep[0]);
                            if (!cols[irep].trim().equals("*")) continue;
                            cols[irep] = rep[1];
                        }
                    }
                }
                logger.debug("    table: ");
                logger.debug("        ident: ");
                logger.debug("            ");
                for (ii = 0; ii < tableIdentifiers.length; ++ii) {
                    logger.debug("    " + tableIdentifiers[ii]);
                }
                logger.debug("        value:");
                for (ii = 0; ii < tableData.size(); ++ii) {
                    String[] cols = (String[])tableData.get(ii);
                    for (int j = 0; j < cols.length; ++j) {
                        logger.debug("    " + cols[j]);
                    }
                }
                if (this.manager != null) {
                    logger.debug("obtaining table spec...");
                    InputInterfaceTableSpec tspec = this.manager.getTableSpec(block.getFullName());
                    if (tspec != null) {
                        logger.debug("obtaining columns");
                        InputInterfaceTableColumns[] cols = tspec.getTableColumns();
                        if (cols != null) {
                            logger.debug("adding columns...");
                            ((InputInterfaceTable)entry).setInputInterfaceTableColumns(cols);
                        }
                    }
                }
            } else if (type == 2) {
                InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                logger.debug("    defaults:");
                String[] de = defs.getDefaults();
                if (replace) {
                    this.defaultName = new String[de.length];
                    this.defaultValue = new String[de.length];
                }
                for (int ii = 0; ii < de.length; ++ii) {
                    logger.debug("            default no." + ii + ": " + de[ii]);
                    if (!replace) continue;
                    String[] tmp = de[ii].split("=");
                    this.defaultName[ii] = tmp[0] != null ? tmp[0].trim() : "";
                    this.defaultValue[ii] = tmp[1] != null ? tmp[1].trim() : "";
                }
            } else if (type == 3) {
                InputInterfaceUnits units = (InputInterfaceUnits)entry;
                logger.debug("    units:");
                String[] un = units.getUnits();
                for (int ii = 0; ii < un.length; ++ii) {
                    logger.debug("            unit no." + ii + ": " + un[ii]);
                }
            }
            this.entryChanged(blname, entry, null);
        }
    }

    private void scan(boolean replace) {
        for (int i = this.restartAt; i < this.list.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)this.list.get(i);
            String name = data.getName();
            if (data.isBlock()) {
                this.selectBlock(name, null);
                logger.debug("entering block: " + name);
                logger.debug("full name of this block: " + ((InputInterfaceBlock)data).getFullName());
                Integer ii = new Integer(i + 1);
                this.restartAts.push(ii);
                if (((InputInterfaceBlock)data).hasTable()) {
                    logger.debug("this block has a table...");
                }
                if (((InputInterfaceBlock)data).hasDefaults()) {
                    logger.debug("this block has default values ...");
                }
                if (((InputInterfaceBlock)data).hasUnits()) {
                    logger.debug("this block has units ...");
                }
                if (this.list.size() == 1) {
                    this.endBlockScan();
                    this.scan(replace);
                    break;
                }
                this.restartAt = 1;
                this.scan(replace);
                break;
            }
            InputInterfaceEntry entry = (InputInterfaceEntry)data;
            int type = entry.getEntryType();
            if (type == 0) {
                InputInterfacePrimitiveEntry primitive = (InputInterfacePrimitiveEntry)entry;
                logger.debug("    token: ");
                logger.debug("        name: " + primitive.getName());
                logger.debug("        value: " + primitive.getValue());
                logger.debug("        unit: " + primitive.getUnit());
            } else if (type == 1) {
                int ii;
                InputInterfaceTable table = (InputInterfaceTable)entry;
                String[] tableIdentifiers = table.getTableIdentifiers();
                Vector tableData = table.getTableData();
                if (replace && this.list.hasDefaults()) {
                    tableIdentifiers = this.getUniqueIdentifiers(this.defaultName, tableIdentifiers);
                    table.setTableIdentifiers(tableIdentifiers);
                    this.expandTableData(tableData, tableIdentifiers.length);
                    Vector<String[]> replaceVector = new Vector<String[]>();
                    for (int j = 0; j < tableIdentifiers.length; ++j) {
                        for (int jj = 0; jj < this.defaultName.length; ++jj) {
                            if (!tableIdentifiers[j].trim().equalsIgnoreCase(this.defaultName[jj].trim())) continue;
                            replaceVector.addElement(new String[]{Integer.toString(j), this.defaultValue[jj]});
                        }
                    }
                    for (int ii2 = 0; ii2 < tableData.size(); ++ii2) {
                        String[] cols = (String[])tableData.get(ii2);
                        for (int j = 0; j < replaceVector.size(); ++j) {
                            String[] rep = (String[])replaceVector.get(j);
                            int irep = Integer.parseInt(rep[0]);
                            if (!cols[irep].trim().equals("*")) continue;
                            cols[irep] = rep[1];
                        }
                    }
                }
                logger.debug("    table: ");
                logger.debug("        ident: ");
                logger.debug("            ");
                for (ii = 0; ii < tableIdentifiers.length; ++ii) {
                    logger.debug("    " + tableIdentifiers[ii]);
                }
                logger.debug("        value:");
                for (ii = 0; ii < tableData.size(); ++ii) {
                    String[] cols = (String[])tableData.get(ii);
                    for (int j = 0; j < cols.length; ++j) {
                        logger.debug("    " + cols[j]);
                    }
                }
                if (this.manager != null) {
                    logger.debug("obtaining table spec...");
                    InputInterfaceTableSpec tspec = this.manager.getTableSpec(this.list.getFullName());
                    if (tspec != null) {
                        logger.debug("obtaining columns");
                        InputInterfaceTableColumns[] cols = tspec.getTableColumns();
                        if (cols != null) {
                            logger.debug("adding columns...");
                            ((InputInterfaceTable)entry).setInputInterfaceTableColumns(cols);
                        }
                    }
                }
            } else if (type == 2) {
                InputInterfaceDefaults defs = (InputInterfaceDefaults)entry;
                logger.debug("    defaults:");
                String[] de = defs.getDefaults();
                if (replace) {
                    this.defaultName = new String[de.length];
                    this.defaultValue = new String[de.length];
                }
                for (int ii = 0; ii < de.length; ++ii) {
                    logger.debug("            default no." + ii + ": " + de[ii]);
                    if (!replace) continue;
                    String[] tmp = de[ii].split("=");
                    this.defaultName[ii] = tmp[0] != null ? tmp[0].trim() : "";
                    this.defaultValue[ii] = tmp[1] != null ? tmp[1].trim() : "";
                }
            } else if (type == 3) {
                InputInterfaceUnits units = (InputInterfaceUnits)entry;
                logger.debug("    units:");
                String[] un = units.getUnits();
                for (int ii = 0; ii < un.length; ++ii) {
                    logger.debug("            unit no." + ii + ": " + un[ii]);
                }
            }
            this.entryChanged(this.list.getFullName(), entry, null);
            if (i != this.list.size() - 1) continue;
            this.endBlockScan();
            this.scan(replace);
            break;
        }
    }

    private void endBlockScan() {
        logger.debug("exiting block: " + this.list.getName());
        if (!this.selectParentBlock()) {
            return;
        }
        logger.debug("re-entering block: " + this.list.getName());
        this.restartAt = (Integer)this.restartAts.pop();
        logger.debug("popped: " + this.restartAt);
        if (this.restartAt == this.list.size()) {
            this.endBlockScan();
        }
    }

    private String[] getUniqueIdentifiers(String[] ident1, String[] ident2) {
        int i;
        if (ident1 == null || ident1.length == 0) {
            return ident2;
        }
        Vector<String> foo = new Vector<String>();
        for (int i2 = 0; i2 < ident1.length; ++i2) {
            boolean dupli = false;
            for (int j = 0; j < ident2.length; ++j) {
                if (!ident1[i2].trim().equalsIgnoreCase(ident2[j].trim())) continue;
                dupli = true;
            }
            if (dupli) continue;
            foo.addElement(ident1[i2]);
        }
        String[] ret = new String[ident2.length + foo.size()];
        for (i = 0; i < ident2.length; ++i) {
            ret[i] = ident2[i];
            logger.debug("at getUniqueIdentifiers: i, ret " + i + " " + ret[i]);
        }
        for (i = 0; i < foo.size(); ++i) {
            ret[ident2.length + i] = (String)foo.elementAt(i);
            logger.debug("at getUniqueIdentifiers: i, ret " + new Integer(i + ident2.length) + " " + ret[ident2.length + i]);
        }
        return ret;
    }

    private void expandTableData(Vector tableData, int newSize) {
        if (tableData == null) {
            return;
        }
        for (int i = 0; i < tableData.size(); ++i) {
            int j;
            String[] tmp = (String[])tableData.elementAt(i);
            if (tmp.length >= newSize) {
                return;
            }
            String[] newCol = new String[newSize];
            for (j = 0; j < tmp.length; ++j) {
                newCol[j] = tmp[j];
            }
            for (j = tmp.length; j < newSize; ++j) {
                newCol[j] = "*";
            }
            tableData.set(i, newCol);
        }
    }

    protected void replaceAst() {
        this.selectRoot();
        this.restartAts = new Stack();
        this.restartAt = 1;
        logger.debug("scanning list & replacing * with defaults ...");
        InputInterfaceBlock rootBlock = this.getRootList();
        for (int i = 1; i < rootBlock.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)rootBlock.get(i);
            if (!data.isBlock()) continue;
            this.scan((InputInterfaceBlock)data, true);
        }
    }

    public void setInputInterfaceTableSpecManager(InputInterfaceTableSpecManager manager) {
        this.manager = manager;
    }

    public InputInterfaceTableSpecManager getInputInterfaceTableSpecManager() {
        return this.manager;
    }

    public void setInputInterfaceTableSpecs(InputInterfaceTableSpec[] specs) {
        this.specs = specs;
    }

    public InputInterfaceTableSpec[] getInputInterfaceTableSpecs() {
        return this.specs;
    }

    public void writeValueDelimitedByColon(boolean writeDelimitedByColon) {
        this.writeDelimitedByColon = writeDelimitedByColon;
    }

    public void writeNullValue(boolean writeNullValue) {
        this.writeNullValue = writeNullValue;
    }

    public void overWriteBlock(String blockName, String tagName, InputInterface from) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error("could not find block: " + blockName);
            return;
        }
        logger.debug("got block: " + block);
        this.selectAndCreateBlock(tagName);
        for (int i = 1; i < block.size(); ++i) {
            InputInterfaceData data = (InputInterfaceData)block.get(i);
            if (data.isBlock()) {
                this.overWriteBlock(block.getName(), data.getName(), from);
                from.selectParentBlock();
                this.selectParentBlock();
                continue;
            }
            this.replaceEntry((InputInterfaceEntry)data);
        }
    }

    public void swapBlock(String blockName, String tagName, InputInterface from) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error("could not find block: " + blockName);
            return;
        }
        logger.debug("got block: " + block);
        this.selectAndCreateBlock(blockName);
        this.replaceBlock(block);
        this.selectRoot();
    }

    public void swapBlock(String blockName, String tagName, InputInterface from, InputInterfaceBlockChangeListener caller) {
        from.selectBlock(blockName);
        InputInterfaceBlock block = from.getBlock(tagName);
        if (block == null) {
            logger.error("could not find block: " + blockName);
            return;
        }
        logger.debug("got block: " + block);
        this.selectAndCreateBlock(blockName);
        this.replaceBlock(block, caller);
        this.selectRoot();
    }

    public static void main(String[] args) {
        InputInterface input = new InputInterface();
        InputInterfaceBlock block = new InputInterfaceBlock();
        block.setName("control");
        input.addBlock(block);
        input.selectBlock("control", null);
        InputInterfacePrimitiveEntry entry = new InputInterfacePrimitiveEntry();
        entry.setName("foo");
        entry.setValue("bar");
        entry.setUnit("hartree");
        input.addEntry(entry);
        input.selectRoot();
        input.scanList();
    }

    public String getType() {
        return "PHASE input object";
    }

    public static boolean isTrue(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String st = str.trim();
        return st.equalsIgnoreCase("1") || st.equalsIgnoreCase("on") || st.equalsIgnoreCase("yes");
    }
}

