/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.imageviewer;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.imageviewer.MainPanel;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.BufferedReader;
import java.io.File;
import org.apache.log4j.Logger;

public class ImageViewerBooter
implements Runnable {
    private Logger logger = Logger.getLogger(ImageViewerBooter.class.getName());
    private int res = 150;
    private int pageNum;
    private String[] files;

    public ImageViewerBooter(String file) {
        this.files = new String[]{file};
    }

    public ImageViewerBooter(String[] files) {
        this.files = files;
    }

    public ImageViewerBooter(int res, String[] files) {
        this.res = res;
        this.files = files;
    }

    public void run() {
        if (this.files == null || this.files.length == 0) {
            this.logger.info("no files selected");
            return;
        }
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        try {
            this.res = Integer.parseInt(gp.getProperty("image_viewer_default_resolution"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            for (int i = 0; i < this.files.length; ++i) {
                String infileName = this.files[i];
                String[] pageArray = null;
                String originalName = infileName;
                if (infileName.toLowerCase().trim().endsWith(".eps") || infileName.toLowerCase().trim().endsWith(".ps") || infileName.toLowerCase().trim().endsWith(".pdf")) {
                    pageArray = this.getTemporaryImageFile(infileName);
                    if (pageArray != null && pageArray.length != 0) {
                        infileName = pageArray[0];
                    } else {
                        this.logger.error("invalid ps/eps/pdf file");
                        return;
                    }
                }
                if (!new File(infileName).exists()) {
                    this.logger.error("file does not exist!");
                    continue;
                }
                MainPanel mp = new MainPanel(infileName, originalName);
                if (!mp.getStatus()) continue;
                mp.setPageNum(this.pageNum);
                this.pageNum = 0;
                if (pageArray != null) {
                    mp.setPageArray(pageArray);
                }
                mp.display();
                mp.requestFocus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("failed to boot image viewer");
        }
    }

    public String[] getTemporaryImageFile(String infileName) {
        String FS = System.getProperty("file.separator");
        File infileFile = new File(infileName);
        String fileName = infileFile.getName();
        String tmpDir = System.getProperty("user.home") + FS + ".phase-viewer";
        String imageFile = tmpDir + FS + fileName;
        String imageFileIn = Utils.getPathDQ(imageFile + "%d.png");
        infileName = Utils.getPathDQ(infileName);
        String epsCrop = "";
        if (fileName.trim().toLowerCase().endsWith(".eps")) {
            epsCrop = "-dEPSCrop";
        }
        String gs = PropertiesManager.getGlobalProperties(0).getProperty("gs");
        String gsExe = Utils.getPathDQ(gs) + " -q -dNOPROMPT -dBATCH -sDEVICE=png16m -r" + this.res + " " + epsCrop + " -dNOPAUSE -sOutputFile=" + imageFileIn + " " + infileName;
        this.logger.info("gsexe: " + gsExe);
        BufferedReader[] br = new BufferedReader[2];
        try {
            br = ExternalProgramExecuter.executeGetBR(gsExe, true);
            br[0].close();
            br[1].close();
        }
        catch (Exception e) {
            // empty catch block
        }
        while (true) {
            ++this.pageNum;
            File pageFile = new File(imageFile + this.pageNum + ".png");
            if (!pageFile.exists()) break;
            pageFile.deleteOnExit();
        }
        --this.pageNum;
        this.logger.info("number of pages: " + this.pageNum);
        String[] tmpImageFiles = new String[this.pageNum];
        for (int i = 0; i < this.pageNum; ++i) {
            int ii = i + 1;
            tmpImageFiles[i] = imageFile + ii + ".png";
        }
        return tmpImageFiles;
    }

    public static boolean isImageFile(String name) {
        String lower = name.toLowerCase();
        return lower.endsWith(".jpg") || lower.endsWith(".jpeg") || lower.endsWith(".png") || lower.endsWith(".eps") || lower.endsWith(".ps") || lower.endsWith(".pdf") || lower.endsWith(".gif") || lower.endsWith(".tif") || lower.endsWith(".tiff") || lower.endsWith(".bmp");
    }
}

