/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.FrameCombo;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class XBSImporter
implements Importer {
    private Logger logger = Logger.getLogger(XBSImporter.class.getName());
    private String[] frameChoice = new String[]{"first frame", "last frame", "all"};
    private String frame = this.frameChoice[0];
    private final String ATOM = "atom";
    private final String GAMMA = "Gamma";
    private final String C01 = "C01";
    private final String C02 = "C02";
    private final String C03 = "C03";
    private final String FRAME = "frame";
    private final String[] NOT_ELEM_NAME = new String[]{"Gamma", "C01", "C02", "C03", "C12", "C21", "C13", "C31", "C23", "C32", "C123", "C213", "C321"};
    private PropertyChangeListener listener;
    private FrameCombo select;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        BufferedReader reader = null;
        AtomCoords firstFrame = new AtomCoords();
        firstFrame.setUnit(2);
        firstFrame.isCart(true);
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = "";
            AtomList list = firstFrame.getAtomList();
            String[] avec = null;
            String[] bvec = null;
            String[] cvec = null;
            while ((line = reader.readLine()) != null) {
                String C032;
                String[] ar;
                if (!(line = line.trim()).startsWith("atom")) continue;
                String[] array = line.split("\\s+");
                if (array == null || array.length < 5) {
                    AtomCoords[] atomCoordsArray = null;
                    return atomCoordsArray;
                }
                boolean isAtom = true;
                String elemName = array[1];
                for (int i = 0; i < this.NOT_ELEM_NAME.length; ++i) {
                    if (!elemName.equals(this.NOT_ELEM_NAME[i])) continue;
                    isAtom = false;
                }
                if (isAtom) {
                    String[] co = new String[]{array[2], array[3], array[4]};
                    Atom atom = new Atom(elemName, co);
                    list.addAtom(atom);
                }
                if (elemName.equals("C01") && avec == null) {
                    String C012 = reader.readLine();
                    if (C012 == null) continue;
                    ar = C012.trim().split("\\s+");
                    if (ar.length >= 5) {
                        avec = new String[]{ar[2], ar[3], ar[4]};
                        this.logger.debug("c01: 0: " + ar[0] + " 1: " + ar[1] + " 2: " + ar[2] + " 3: " + ar[3] + " 4: " + ar[4]);
                        this.logger.debug("got avec: " + avec[0] + " " + avec[1] + " " + avec[2]);
                    }
                }
                if (elemName.equals("C02") && bvec == null) {
                    String C022 = reader.readLine();
                    if (C022 == null) continue;
                    ar = C022.trim().split("\\s+");
                    if (ar.length >= 5) {
                        bvec = new String[]{ar[2], ar[3], ar[4]};
                        this.logger.debug("got bvec: " + bvec[0] + " " + bvec[1] + " " + bvec[2]);
                    }
                }
                if (!elemName.equals("C03") || cvec != null || (C032 = reader.readLine()) == null || (ar = C032.trim().split("\\s+")).length < 5) continue;
                cvec = new String[]{ar[2], ar[3], ar[4]};
                this.logger.debug("got cvec: " + cvec[0] + " " + cvec[1] + " " + cvec[2]);
            }
            if (avec != null && bvec != null && cvec != null) {
                Cell cell = new Cell(avec, bvec, cvec);
                firstFrame.setCell(cell);
            } else {
                this.logger.debug("failed to get cell.");
            }
        }
        catch (IOException ioe) {
            this.logger.error("failed parse..");
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exc) {}
        }
        String dir = new File(fileName).getParent();
        String name = new File(fileName).getName().trim();
        String[] foo = name.split("\\.");
        if (foo.length == 1) {
            return new AtomCoords[]{firstFrame};
        }
        String mvfile_prefix = "";
        for (int i = 0; i < foo.length - 1; ++i) {
            mvfile_prefix = mvfile_prefix + foo[i];
        }
        String mvfile = dir + System.getProperty("file.separator") + mvfile_prefix + ".mv";
        if (!new File(mvfile).exists()) {
            return new AtomCoords[]{firstFrame};
        }
        int numAt = firstFrame.getNumAt();
        String[] elemNames = new String[numAt];
        int numFrame = 0;
        for (int i = 0; i < numAt; ++i) {
            elemNames[i] = firstFrame.getAtomList().getAtomAt(i).getElementName();
        }
        Vector<AtomCoords> frames = new Vector<AtomCoords>();
        frames.addElement(firstFrame);
        try {
            reader = new BufferedReader(new FileReader(mvfile));
            String line = "";
            int icount = 0;
            AtomCoords tmpCoords = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("frame")) {
                    tmpCoords = new AtomCoords();
                    frames.addElement(tmpCoords);
                    icount = 0;
                    ++numFrame;
                    continue;
                }
                String[] array = line.split("\\s+");
                if (array.length < 3) continue;
                if (icount < numAt) {
                    Atom atom = new Atom(elemNames[icount], new String[]{array[0], array[1], array[2]});
                    tmpCoords.getAtomList().addAtom(atom);
                }
                if (++icount != numAt) continue;
                String[] avec = null;
                String[] bvec = null;
                String[] cvec = null;
                try {
                    reader.readLine();
                    reader.readLine();
                    String av = reader.readLine();
                    reader.readLine();
                    String bv = reader.readLine();
                    reader.readLine();
                    String cv = reader.readLine();
                    avec = av.trim().split("\\s+");
                    bvec = bv.trim().split("\\s+");
                    cvec = cv.trim().split("\\s+");
                }
                catch (Exception exp) {
                    // empty catch block
                }
                if (avec == null || bvec == null || cvec == null) continue;
                tmpCoords.setCell(new Cell(avec, bvec, cvec));
            }
        }
        catch (Exception exce) {
            this.logger.error("failed parse: " + mvfile);
            exce.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exc) {}
        }
        int targetFrame = -1;
        if (this.select != null) {
            targetFrame = this.select.getTargetFrame(frames.size());
        }
        if (targetFrame < 0) {
            Object[] cds = new AtomCoords[frames.size()];
            frames.copyInto(cds);
            return cds;
        }
        return new AtomCoords[]{(AtomCoords)frames.get(targetFrame)};
    }

    public boolean hasOptions() {
        return true;
    }

    public String getType() {
        return "XBS file";
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName().toLowerCase();
                if (fileName != null) {
                    return fileName.endsWith(".bs") || fileName.endsWith(".BS");
                }
                return false;
            }

            public String getDescription() {
                return "XBS file (*.bs)";
            }
        };
    }

    public void createOptionsPanel(boolean isheavy, PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        if (!isheavy) {
            OptionsPanel op = new OptionsPanel();
        } else {
            OptionsPanelHeavy op = new OptionsPanelHeavy();
        }
    }

    public void setOptions(HashMap options) {
    }

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }

    class OptionsPanelHeavy
    extends InternalFrameChase {
        OptionsPanelHeavy() {
            super("options", new Dimension(200, 150));
            this.init();
        }

        private void init() {
            JPanel pchoice = new JPanel();
            XBSImporter.this.select = new FrameCombo();
            pchoice.add(XBSImporter.this.select);
            JPanel btnpanel = new JPanel();
            JButton ok = new JButton("ok");
            btnpanel.add(ok);
            JPanel panel = new JPanel();
            panel.add(pchoice);
            panel.add(btnpanel);
            this.getContentPane().add(panel);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanelHeavy.this.dispose();
                    XBSImporter.this.listener.propertyChange(null);
                }
            });
            this.pack();
            this.setVisible(true);
        }
    }

    class OptionsPanel
    extends InternalFrameChase {
        OptionsPanel() {
            super("options", true, true, true, true, new Dimension(200, 150));
            this.init();
        }

        private void init() {
            JPanel pchoice = new JPanel();
            XBSImporter.this.select = new FrameCombo();
            pchoice.add(XBSImporter.this.select);
            JPanel btnpanel = new JPanel();
            JButton ok = new JButton("ok");
            btnpanel.add(ok);
            JPanel panel = new JPanel();
            panel.add(pchoice);
            panel.add(btnpanel);
            this.getContentPane().add(panel);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.dispose();
                    XBSImporter.this.listener.propertyChange(null);
                }
            });
        }
    }
}

