/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.AtomCoordsIO;
import ciss.phase_viewer.atomcoord.io.Exportable;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ExporterGUIPanel
extends JPanel {
    private Logger logger = Logger.getLogger(ExporterGUIPanel.class.getName());
    private Exportable caller;
    private Exporter[] exporters;
    private JInternalFrame internalFrame;
    private JFrame jFrame;
    private AtomCoords[] targetCoords;
    private JComboBox comboType;
    private JTextField pathTF;
    private JButton bootChooser;
    private JButton btnopt;

    public ExporterGUIPanel(Exportable caller, JInternalFrame internalFrame) {
        this.caller = caller;
        this.internalFrame = internalFrame;
        this.targetCoords = caller.getCoordsToExport();
        this.init();
    }

    public ExporterGUIPanel(Exportable caller, JFrame jFrame) {
        this.caller = caller;
        this.jFrame = jFrame;
        this.targetCoords = caller.getCoordsToExport();
        this.init();
    }

    private void init() {
        this.createExporters();
        String[] types = new String[this.exporters.length];
        for (int i = 0; i < this.exporters.length; ++i) {
            types[i] = this.exporters[i].getType();
        }
        this.comboType = new JComboBox<String>(types);
        this.pathTF = new JTextField(20);
        this.bootChooser = new JButton("choose...");
        JPanel panel1 = new JPanel();
        JPanel pcomboType = new JPanel();
        pcomboType.setBorder(new TitledBorder("file type"));
        pcomboType.add(this.comboType);
        JPanel pchooser = new JPanel();
        this.btnopt = new JButton("options");
        pchooser.setLayout(new BoxLayout(pchooser, 0));
        pchooser.add(this.pathTF);
        pchooser.add(this.bootChooser);
        pchooser.add(this.btnopt);
        panel1.add(pcomboType);
        panel1.add(pchooser);
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        JButton exportbtn = new JButton("export");
        JButton btncancel = new JButton("cancel");
        pbtns.add(exportbtn);
        pbtns.add(btncancel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(panel1);
        panel.add(pbtns);
        this.comboType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExporterGUIPanel.this.exporters[ExporterGUIPanel.this.comboType.getSelectedIndex()].hasOptions()) {
                    ExporterGUIPanel.this.btnopt.setEnabled(true);
                } else {
                    ExporterGUIPanel.this.btnopt.setEnabled(false);
                }
            }
        });
        this.bootChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExporterGUIPanel.this.chooser();
            }
        });
        exportbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new doExport()).start();
                if (ExporterGUIPanel.this.jFrame != null) {
                    ExporterGUIPanel.this.jFrame.dispose();
                } else if (ExporterGUIPanel.this.internalFrame != null) {
                    ExporterGUIPanel.this.internalFrame.dispose();
                }
            }
        });
        this.btnopt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isHeavy = true;
                if (ExporterGUIPanel.this.internalFrame != null) {
                    isHeavy = false;
                }
                ExporterGUIPanel.this.exporters[ExporterGUIPanel.this.comboType.getSelectedIndex()].createOptionsPanel(isHeavy, null, "");
            }
        });
        btncancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ExporterGUIPanel.this.jFrame != null) {
                    ExporterGUIPanel.this.jFrame.dispose();
                } else if (ExporterGUIPanel.this.internalFrame != null) {
                    ExporterGUIPanel.this.internalFrame.dispose();
                }
            }
        });
        this.add(panel);
        this.comboType.setSelectedIndex(0);
    }

    private void createExporters() {
        int i;
        Document doc = XMLUtils.getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        List list = root.getChildren("exporter");
        Vector<String> vec = new Vector<String>();
        for (i = 0; i < list.size(); ++i) {
            String loadClass = ((Element)list.get(i)).getChildTextTrim("loadclass");
            vec.addElement(loadClass);
        }
        this.exporters = new Exporter[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            String load = (String)vec.get(i);
            this.exporters[i] = (Exporter)PluginLoader.instantiate(load, null);
        }
    }

    private void chooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser("atom", true);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select atomic configuration file");
        fdlg.setFileSelectionMode(0);
        FileFilter filter = this.exporters[this.comboType.getSelectedIndex()].getFileFilter();
        if (filter != null) {
            fdlg.addChoosableFileFilter(filter);
        }
        if (fdlg.showOpenDialog(this) != 0) {
            return;
        }
        this.pathTF.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    class doExport
    implements Runnable {
        doExport() {
        }

        public void run() {
            String file = ExporterGUIPanel.this.pathTF.getText();
            ExporterGUIPanel.this.exporters[ExporterGUIPanel.this.comboType.getSelectedIndex()].writeAtomCoordsTo(ExporterGUIPanel.this.targetCoords, file);
            ExporterGUIPanel.this.caller.coordsExported(ExporterGUIPanel.this.targetCoords, ExporterGUIPanel.this.comboType.getSelectedItem().toString(), file);
        }
    }
}

