/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.export.SaveAsPluginAdapter;
import jas.hist.JASHist;
import jas.hist.SaveAsPlugin;
import jas.hist.XMLHistBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.freehep.graphics2d.exportchooser.ExportFileType;

class ExportTest
extends JFrame
implements Runnable {
    private JASHist plot;

    public ExportTest() throws Exception {
        super("Export Test");
        this.setDefaultCloseOperation(0);
        XMLHistBuilder xMLHistBuilder = new XMLHistBuilder(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("ExportTest.plotml"))), "ExportTest.plotml");
        this.plot = xMLHistBuilder.getSoloPlot();
        this.plot.setAllowUserInteraction(false);
        this.getContentPane().add(this.plot);
    }

    public static void main(String[] stringArray) throws Exception {
        ExportTest exportTest = new ExportTest();
        exportTest.pack();
        exportTest.show();
        Thread.currentThread();
        Thread.sleep(500L);
        SwingUtilities.invokeAndWait(exportTest);
        System.exit(0);
    }

    public void run() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("ExportTest.ini")));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",=");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                Properties properties = new Properties();
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken().trim();
                    if (!stringTokenizer.hasMoreTokens()) break;
                    String string6 = stringTokenizer.nextToken().trim();
                    properties.setProperty(string5, string6);
                }
                this.test(string2, string3, string4, properties);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void test(String string, String string2, String string3, Properties properties) throws Exception {
        Class<?> clazz = Class.forName(string3);
        Object object = clazz.newInstance();
        if (object instanceof ExportFileType) {
            object = new SaveAsPluginAdapter((ExportFileType)object);
        }
        SaveAsPlugin saveAsPlugin = (SaveAsPlugin)object;
        saveAsPlugin.restoreOptions(properties);
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        System.out.println(string + " running...");
        long l = System.currentTimeMillis();
        saveAsPlugin.saveAs(this.plot, fileOutputStream, file, this);
        long l2 = System.currentTimeMillis();
        ((OutputStream)fileOutputStream).close();
        System.out.println(string + " done, time=" + (l2 - l) + "ms size=" + file.length());
    }
}

