/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.rtsp.Debug;
import com.sun.media.rtsp.MessageProcessor;
import com.sun.media.rtsp.RtspManager;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Connection
extends Thread
implements Runnable {
    public int connectionId;
    private Socket socket;
    private RtspManager rtspManager;
    private MessageProcessor mp;
    private boolean connectionIsAlive;

    public Connection(RtspManager rtspManager, int connectionId, byte[] dstAddress, int port) throws UnknownHostException, ConnectException {
        this.rtspManager = rtspManager;
        this.connectionId = connectionId;
        String domain = new String(dstAddress);
        InetAddress dst = InetAddress.getByName(domain);
        try {
            this.socket = new Socket(dst, port);
            this.start();
        }
        catch (IOException e2) {
            throw new ConnectException();
        }
    }

    public Connection(RtspManager rtspManager, int connectionId, Socket socket) {
        this.rtspManager = rtspManager;
        this.connectionId = connectionId;
        this.socket = socket;
        this.start();
    }

    public boolean sendData(byte[] message) {
        boolean success = false;
        try {
            OutputStream out = this.socket.getOutputStream();
            out.write(message);
            out.flush();
            success = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    public void run() {
        this.connectionIsAlive = true;
        while (this.connectionIsAlive) {
            try {
                InputStream in = this.socket.getInputStream();
                DataInputStream din = new DataInputStream(in);
                byte ch = din.readByte();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(ch);
                while (!this.eomReached(baos.toByteArray())) {
                    baos.write(din.readByte());
                }
                int length = this.getContentLength(new String(baos.toByteArray()));
                int i2 = 0;
                while (i2 < length) {
                    baos.write(din.readByte());
                    ++i2;
                }
                if (this.mp == null) {
                    this.mp = new MessageProcessor(this.connectionId, this.rtspManager);
                }
                this.mp.processMessage(baos.toByteArray());
            }
            catch (Exception e2) {
                this.connectionIsAlive = false;
            }
        }
    }

    private boolean eomReached(byte[] buffer) {
        boolean endReached = false;
        int size = buffer.length;
        if (size >= 4 && buffer[size - 4] == 13 && buffer[size - 3] == 10 && buffer[size - 2] == 13 && buffer[size - 1] == 10) {
            endReached = true;
        }
        return endReached;
    }

    private int getContentLength(String msg_header) {
        int length;
        int start = msg_header.indexOf("Content-length");
        if (start == -1) {
            start = msg_header.indexOf("Content-Length");
        }
        if (start == -1) {
            length = 0;
        } else {
            start = msg_header.indexOf(58, start) + 2;
            int end = msg_header.indexOf(13, start);
            String length_str = msg_header.substring(start, end);
            length = new Integer(length_str);
        }
        return length;
    }

    public void cleanup() {
        Debug.println("RTSP::Connection:cleanup, id=" + this.connectionId);
        this.close();
        this.rtspManager.removeConnection(this.connectionId);
    }

    public void close() {
        this.connectionIsAlive = false;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getIpAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }
}

