/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import java.util.Stack;
import org.python.parser.IntStack;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.TreeBuilder;

class JJTPythonGrammarState {
    private Stack nodes = new Stack();
    private IntStack marks = new IntStack();
    private IntStack lines = new IntStack();
    private IntStack columns = new IntStack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private TreeBuilder builder = new TreeBuilder(this);

    JJTPythonGrammarState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node n) {
        this.nodes.push(n);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void pushNodePos(int line, int col) {
        this.lines.push(line);
        this.columns.push(col);
    }

    void setNodePos() {
        SimpleNode n = (SimpleNode)this.peekNode();
        n.beginLine = this.lines.pop();
        n.beginColumn = this.columns.pop();
    }

    void clearNodeScope(Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(Node n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
    }

    void closeNodeScope(Node n, int num) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        this.mk = this.marks.pop();
        SimpleNode newNode = null;
        try {
            newNode = this.builder.closeNode(sn, num);
        }
        catch (ParseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new ParseException("Internal error:" + exc);
        }
        if (newNode == null) {
            throw new ParseException("Internal AST builder error");
        }
        this.pushNode(newNode);
        this.node_created = true;
    }

    void closeNodeScope(Node n, boolean condition) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        if (condition) {
            SimpleNode newNode = null;
            try {
                newNode = this.builder.closeNode(sn, this.nodeArity());
            }
            catch (ParseException exc) {
                throw exc;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Internal error:" + exc);
            }
            if (newNode == null) {
                throw new ParseException("Internal AST builder error");
            }
            this.mk = this.marks.pop();
            this.pushNode(newNode);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }

    public void dumpTop(String reason) {
        int a = this.nodeArity();
        System.out.println("dumpTop:" + reason);
        System.out.println("arity:" + a);
        for (int i = 0; i < a; ++i) {
            Node n = (Node)this.nodes.elementAt(this.nodes.size() - i - 1);
            System.out.println("   " + n);
        }
    }

    public Node openNode(int id) {
        return this.builder.openNode(id);
    }

    public void dump(String reason) {
        int i;
        int a = this.nodeArity();
        System.out.println("dump:" + reason);
        System.out.println("  mk:" + this.mk + "  sp:" + this.sp);
        for (i = 0; i < this.nodes.size(); ++i) {
            Node n = (Node)this.nodes.elementAt(i);
            System.out.println("   " + n);
        }
        for (i = 0; i < this.marks.size(); ++i) {
            System.out.println("   " + this.marks.elementAt(i));
        }
    }
}

