/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.Component;
import java.io.PrintStream;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.SceneGraphObject;
import org.cybergarage.x3d.j3d.AnchorNodeObject;
import org.cybergarage.x3d.j3d.AppearanceNodeObject;
import org.cybergarage.x3d.j3d.BillboardNodeObject;
import org.cybergarage.x3d.j3d.BoxNodeObject;
import org.cybergarage.x3d.j3d.CollisionNodeObject;
import org.cybergarage.x3d.j3d.ConeNodeObject;
import org.cybergarage.x3d.j3d.CylinderNodeObject;
import org.cybergarage.x3d.j3d.DirectionalLightNodeObject;
import org.cybergarage.x3d.j3d.ElevationGridNodeObject;
import org.cybergarage.x3d.j3d.ExponentialFogNodeObject;
import org.cybergarage.x3d.j3d.ExtrusionNodeObject;
import org.cybergarage.x3d.j3d.GroupNodeObject;
import org.cybergarage.x3d.j3d.ImageTextureLoader;
import org.cybergarage.x3d.j3d.ImageTextureNodeObject;
import org.cybergarage.x3d.j3d.IndexedFaceSetNodeObject;
import org.cybergarage.x3d.j3d.IndexedLineSetNodeObject;
import org.cybergarage.x3d.j3d.InlineNodeObject;
import org.cybergarage.x3d.j3d.LODNodeObject;
import org.cybergarage.x3d.j3d.LinerFogNodeObject;
import org.cybergarage.x3d.j3d.MaterialNodeObject;
import org.cybergarage.x3d.j3d.PixelTextureNodeObject;
import org.cybergarage.x3d.j3d.PointLightNodeObject;
import org.cybergarage.x3d.j3d.PointSetNodeObject;
import org.cybergarage.x3d.j3d.RootNodeObject;
import org.cybergarage.x3d.j3d.ShapeNodeObject;
import org.cybergarage.x3d.j3d.SphereNodeObject;
import org.cybergarage.x3d.j3d.SpotLightNodeObject;
import org.cybergarage.x3d.j3d.SwitchNodeObject;
import org.cybergarage.x3d.j3d.TextNodeObject;
import org.cybergarage.x3d.j3d.TextureTransformNodeObject;
import org.cybergarage.x3d.j3d.TransformNodeObject;
import org.cybergarage.x3d.node.AnchorNode;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.CollisionNode;
import org.cybergarage.x3d.node.ConeNode;
import org.cybergarage.x3d.node.CylinderNode;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.ElevationGridNode;
import org.cybergarage.x3d.node.ExtrusionNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.ImageTextureNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.LODNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.NavigationInfoNode;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.node.PointLightNode;
import org.cybergarage.x3d.node.PointSetNode;
import org.cybergarage.x3d.node.RootNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.SphereNode;
import org.cybergarage.x3d.node.SpotLightNode;
import org.cybergarage.x3d.node.SwitchNode;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.node.TextureTransformNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.util.Debug;

public class SceneGraphJ3dObject
implements SceneGraphObject {
    private VirtualUniverse mUniverse3D = null;
    private Locale mLocale = null;
    private RootNodeObject mRootNode = null;
    private Background mBackground = null;
    private boolean mIsBranchGroupAdded = false;
    private AmbientLight mAmbientLight = null;
    private PointLight mPointLight = null;
    private View[] mView = null;
    private ViewPlatform[] mViewPlatform = null;
    private TransformGroup[] mViewTransformGroup = null;
    private TransformGroup[] mCanvas3DTransformGroup = null;
    private Canvas3D[] mCanvas3D = null;

    public SceneGraphJ3dObject(SceneGraph sg) {
        this.initializeRootNode(sg);
        this.setCanvas3D(new Canvas3D[0]);
    }

    public SceneGraphJ3dObject(Canvas3D[] canvases, SceneGraph sg, boolean initScene) {
        this.initialize(canvases, sg, initScene);
    }

    public SceneGraphJ3dObject(Canvas3D[] canvases, SceneGraph sg) {
        this.initialize(canvases, sg, true);
    }

    public SceneGraphJ3dObject(Canvas3D canvas3D, SceneGraph sg, boolean initScene) {
        Canvas3D[] canvases = new Canvas3D[]{canvas3D};
        this.initialize(canvases, sg, initScene);
    }

    public SceneGraphJ3dObject(Canvas3D canvas3D, SceneGraph sg) {
        Canvas3D[] canvases = new Canvas3D[]{canvas3D};
        this.initialize(canvases, sg, true);
    }

    public void initialize(Canvas3D[] canvases, SceneGraph sg, boolean initScene) {
        this.initializeRootNode(sg);
        this.setCanvas3D(canvases);
        if (initScene) {
            this.initializeScene(canvases, sg);
        }
    }

    private void initializeRootNode(SceneGraph sg) {
        RootNode rootNode = sg.getRootNode();
        this.mRootNode = new RootNodeObject(rootNode);
        rootNode.setObject(this.mRootNode);
    }

    private void initializeScene(Canvas3D[] canvas3D, SceneGraph sg) {
        this.mUniverse3D = new VirtualUniverse();
        this.mLocale = new Locale(this.mUniverse3D);
        int nCanvas3D = canvas3D.length;
        this.mView = new View[nCanvas3D];
        this.mViewPlatform = new ViewPlatform[nCanvas3D];
        this.mViewTransformGroup = new TransformGroup[nCanvas3D];
        this.mCanvas3DTransformGroup = new TransformGroup[nCanvas3D];
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        for (int n = 0; n < nCanvas3D; ++n) {
            this.mViewTransformGroup[n] = new TransformGroup();
            this.mViewTransformGroup[n].setCapability(17);
            this.mViewTransformGroup[n].setCapability(18);
            this.mRootNode.addChild((Node)this.mViewTransformGroup[n]);
            this.mCanvas3DTransformGroup[n] = new TransformGroup();
            this.mCanvas3DTransformGroup[n].setCapability(17);
            this.mCanvas3DTransformGroup[n].setCapability(18);
            this.mViewTransformGroup[n].addChild((Node)this.mCanvas3DTransformGroup[n]);
            this.mViewPlatform[n] = new ViewPlatform();
            this.mViewPlatform[n].setActivationRadius(Float.MAX_VALUE);
            this.mCanvas3DTransformGroup[n].addChild((Node)this.mViewPlatform[n]);
            this.mView[n] = new View();
            this.mView[n].addCanvas3D(canvas3D[n]);
            this.mView[n].setPhysicalBody(body);
            this.mView[n].setPhysicalEnvironment(environment);
            this.mView[n].attachViewPlatform(this.mViewPlatform[n]);
        }
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        Color3f bgColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.mBackground = new Background(bgColor);
        this.mBackground.setApplicationBounds((Bounds)bounds);
        this.mBackground.setCapability(12);
        this.mBackground.setCapability(13);
        this.mBackground.setCapability(16);
        this.mBackground.setCapability(17);
        this.mRootNode.addChild((Node)this.mBackground);
        this.mAmbientLight = new AmbientLight(new Color3f(0.0f, 0.0f, 0.0f));
        this.mAmbientLight.setCapability(16);
        this.mAmbientLight.setCapability(17);
        this.mAmbientLight.setCapability(14);
        this.mAmbientLight.setCapability(15);
        this.mAmbientLight.setEnable(false);
        this.mRootNode.addChild((Node)this.mAmbientLight);
        this.mPointLight = new PointLight();
        this.mPointLight.setColor(new Color3f(0.8f, 0.8f, 0.8f));
        this.mPointLight.setCapability(16);
        this.mPointLight.setCapability(17);
        this.mPointLight.setCapability(12);
        this.mPointLight.setCapability(13);
        this.mPointLight.setCapability(20);
        this.mPointLight.setCapability(21);
        this.mPointLight.setCapability(18);
        this.mPointLight.setCapability(19);
        this.mPointLight.setAttenuation(1.0f, 0.0f, 0.0f);
        this.mPointLight.setEnable(false);
        BoundingSphere bound = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        this.mPointLight.setInfluencingBounds((Bounds)bound);
        this.mRootNode.addChild((Node)this.mPointLight);
        this.addBranchGroup();
    }

    public RootNodeObject getRootNode() {
        return this.mRootNode;
    }

    public BranchGroup getBranchGroup() {
        return this.mRootNode;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public Background getBackground() {
        return this.mBackground;
    }

    private void setCanvas3D(Canvas3D[] canvas3D) {
        this.mCanvas3D = canvas3D;
    }

    public int getNCanvas3Ds() {
        if (this.mCanvas3D == null) {
            return 0;
        }
        return this.mCanvas3D.length;
    }

    public Canvas3D[] getCanvas3Ds() {
        return this.mCanvas3D;
    }

    public Canvas3D getCanvas3D(int n) {
        return this.mCanvas3D[n];
    }

    public View[] getViews() {
        return this.mView;
    }

    public View getView(int n) {
        return this.mView[n];
    }

    public TransformGroup[] getViewTransformGroups() {
        return this.mViewTransformGroup;
    }

    public void setViewTransformGroup(int n, Transform3D t) {
        this.mViewTransformGroup[n].setTransform(t);
    }

    public TransformGroup getViewTransformGroup(int n) {
        return this.mViewTransformGroup[n];
    }

    public TransformGroup[] getCanvas3DTransformGroups() {
        return this.mCanvas3DTransformGroup;
    }

    public void setCanvas3DTransformGroup(int n, Transform3D t) {
        this.mCanvas3DTransformGroup[n].setTransform(t);
    }

    public TransformGroup getCanvas3DTransformGroup(int n) {
        return this.mCanvas3DTransformGroup[n];
    }

    public AmbientLight getAmbientLight() {
        return this.mAmbientLight;
    }

    public PointLight getHeadlight() {
        return this.mPointLight;
    }

    public void setHeadlightState(boolean state) {
        if (this.mPointLight == null) {
            return;
        }
        this.mPointLight.setEnable(state);
    }

    public boolean isHeadlightOn() {
        if (this.mPointLight == null) {
            return false;
        }
        return this.mPointLight.getEnable();
    }

    public void addBranchGroup() {
        if (this.mLocale == null) {
            return;
        }
        if (!this.mIsBranchGroupAdded) {
            this.mLocale.addBranchGraph((BranchGroup)this.mRootNode);
            this.mIsBranchGroupAdded = true;
        }
    }

    public void removeBranchGroup() {
        if (this.mLocale == null) {
            return;
        }
        if (this.mIsBranchGroupAdded) {
            this.mLocale.removeBranchGraph((BranchGroup)this.mRootNode);
            this.mIsBranchGroupAdded = false;
        }
    }

    public boolean addNode(SceneGraph sg, org.cybergarage.x3d.node.Node node) {
        Debug.message("SceneGraphJ3dObject::addNode = " + sg + ", " + node);
        if (node.isRootNode()) {
            return false;
        }
        this.removeBranchGroup();
        boolean ret = node.addObject();
        this.addBranchGroup();
        return ret;
    }

    public boolean removeNode(SceneGraph sg, org.cybergarage.x3d.node.Node node) {
        Debug.message("SceneGraphJ3dObject::removeNode = " + sg + ", " + node);
        if (node.isRootNode()) {
            return false;
        }
        this.removeBranchGroup();
        boolean ret = node.removeObject();
        this.addBranchGroup();
        return ret;
    }

    public boolean initialize(SceneGraph sg) {
        Debug.message("SceneGraphJ3DObject::initialize");
        this.removeBranchGroup();
        for (org.cybergarage.x3d.node.Node node = sg.getNodes(); node != null; node = node.nextTraversal()) {
            if (node.hasObject()) continue;
            node.recreateNodeObject();
        }
        this.update(sg);
        float sceneGraphRadius = sg.getRadius();
        Debug.message("\tradius = " + sceneGraphRadius);
        int nViews = this.getNCanvas3Ds();
        for (int n = 0; n < nViews; ++n) {
            View view = this.getView(n);
            view.setBackClipDistance((double)(sceneGraphRadius * 10.0f));
            view.setFrontClipDistance((double)(sceneGraphRadius / 1000.0f));
            Debug.message("\tfrontClipPolicy = " + view.getFrontClipPolicy());
            Debug.message("\tbackClipPolicy = " + view.getBackClipPolicy());
            Debug.message("\tfrontClipDistance = " + view.getFrontClipDistance());
            Debug.message("\tbackClipDistance = " + view.getBackClipDistance());
        }
        Background bg = this.getBackground();
        if (bg != null) {
            float[] bboxCenter = sg.getBoundingBoxCenter();
            Point3d center = new Point3d((double)bboxCenter[0], (double)bboxCenter[1], (double)bboxCenter[2]);
            BoundingSphere bounds = new BoundingSphere(center, (double)sceneGraphRadius);
            bg.setApplicationBounds((Bounds)bounds);
        }
        this.addBranchGroup();
        return true;
    }

    public boolean uninitialize(SceneGraph sg) {
        return true;
    }

    public Bounds getSceneGraphBounds(SceneGraph sg, ViewpointNode viewNode) {
        float[] viewPos = new float[3];
        viewNode.getPosition(viewPos);
        float sgRadius = sg.getRadius() * 1000.0f;
        if ((double)sgRadius == 0.0) {
            sgRadius = 1000.0f;
        }
        return new BoundingSphere(new Point3d((double)viewPos[0], (double)viewPos[1], (double)viewPos[2]), (double)sgRadius);
    }

    public void updateHeadlight(SceneGraph sg, ViewpointNode viewNode) {
        PointLight light = this.getHeadlight();
        if (light == null) {
            return;
        }
        float[] pos = new float[3];
        viewNode.getPosition(pos);
        light.setPosition(new Point3f(pos));
        light.setInfluencingBounds(this.getSceneGraphBounds(sg, viewNode));
    }

    public void updateViewInfomation(ViewpointNode viewNode) {
        float[] position = new float[3];
        float[] orientation = new float[4];
        viewNode.getPosition(position);
        viewNode.getOrientation(orientation);
        float fov = viewNode.getFieldOfView();
        int nViews = this.getNCanvas3Ds();
        for (int n = 0; n < nViews; ++n) {
            View view = this.getView(n);
            TransformGroup viewTrans = this.getViewTransformGroup(n);
            Transform3D trans3D = new Transform3D();
            viewTrans.getTransform(trans3D);
            Vector3f vector = new Vector3f(position);
            trans3D.setTranslation(vector);
            AxisAngle4f axisAngle = new AxisAngle4f(orientation);
            trans3D.setRotation(axisAngle);
            viewTrans.setTransform(trans3D);
            view.setFieldOfView((double)fov);
            Debug.message("SceneGraphJ3dObject::updateViewInfomation");
            Debug.message("\tviewpos = " + position[0] + ", " + position[1] + ", " + position[2]);
            Debug.message("\tfrontClipDistance = " + view.getFrontClipDistance());
            Debug.message("\tbackClipDistance = " + view.getBackClipDistance());
        }
    }

    public void updateBackground(SceneGraph sg, BackgroundNode bgNode, ViewpointNode viewNode) {
        Background bg = this.getBackground();
        if (bg == null) {
            return;
        }
        Color3f bgColor = null;
        if (0 < bgNode.getNSkyColors()) {
            float[] color = new float[3];
            bgNode.getSkyColor(0, color);
            bgColor = new Color3f(color);
        } else {
            bgColor = new Color3f(0.0f, 0.0f, 0.0f);
        }
        bg.setColor(bgColor);
        bg.setApplicationBounds(this.getSceneGraphBounds(sg, viewNode));
    }

    public void updateNodes(SceneGraph sg) {
        for (org.cybergarage.x3d.node.Node node = sg.getNodes(); node != null; node = node.nextTraversal()) {
            node.updateObject();
        }
    }

    public boolean update(SceneGraph sg) {
        BackgroundNode bg;
        ViewpointNode view = sg.getViewpointNode();
        if (view == null) {
            view = sg.getDefaultViewpointNode();
        }
        this.updateViewInfomation(view);
        NavigationInfoNode navInfo = sg.getNavigationInfoNode();
        if (navInfo == null) {
            navInfo = sg.getDefaultNavigationInfoNode();
        }
        boolean headlightOn = navInfo.getHeadlight();
        this.setHeadlightState(headlightOn);
        if (headlightOn) {
            this.updateHeadlight(sg, view);
        }
        if ((bg = sg.getBackgroundNode()) == null) {
            bg = sg.getDefaultBackgroundNode();
        }
        this.updateBackground(sg, bg, view);
        this.updateNodes(sg);
        return true;
    }

    public boolean remove(SceneGraph sg) {
        this.removeBranchGroup();
        for (org.cybergarage.x3d.node.Node node = sg.getNodes(); node != null; node = node.nextTraversal()) {
            NodeObject nodeObject = node.getObject();
            if (nodeObject == null) continue;
            nodeObject.remove(node);
        }
        this.addBranchGroup();
        return true;
    }

    public boolean start(SceneGraph sg) {
        Debug.message("SceneGraphJ3dObject.start");
        int nCanvas3D = this.getNCanvas3Ds();
        for (int n = 0; n < nCanvas3D; ++n) {
            View view = this.getView(n);
            view.startBehaviorScheduler();
            view.startView();
            this.getCanvas3D(n).startRenderer();
        }
        return true;
    }

    public boolean stop(SceneGraph sg) {
        Debug.message("SceneGraphJ3dObject.stop");
        int nCanvas3D = this.getNCanvas3Ds();
        for (int n = 0; n < nCanvas3D; ++n) {
            View view = this.getView(n);
            view.stopBehaviorScheduler();
            view.stopView();
            this.getCanvas3D(n).stopRenderer();
        }
        return true;
    }

    public NodeObject createNodeObject(SceneGraph sg, org.cybergarage.x3d.node.Node node) {
        NodeObject nodeObject = null;
        if (node.isAnchorNode()) {
            nodeObject = new AnchorNodeObject((AnchorNode)node);
        } else if (node.isAppearanceNode()) {
            nodeObject = new AppearanceNodeObject((AppearanceNode)node);
        } else if (node.isBackgroundNode()) {
            nodeObject = null;
        } else if (node.isBillboardNode()) {
            nodeObject = new BillboardNodeObject((BillboardNode)node);
        } else if (node.isBoxNode()) {
            nodeObject = new BoxNodeObject((BoxNode)node);
        } else if (node.isCollisionNode()) {
            nodeObject = new CollisionNodeObject((CollisionNode)node);
        } else if (node.isColorNode()) {
            nodeObject = null;
        } else if (node.isColorInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isConeNode()) {
            nodeObject = new ConeNodeObject((ConeNode)node);
        } else if (node.isCoordinateNode()) {
            nodeObject = null;
        } else if (node.isCoordinateInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isCylinderNode()) {
            nodeObject = new CylinderNodeObject((CylinderNode)node);
        } else if (node.isDirectionalLightNode()) {
            nodeObject = new DirectionalLightNodeObject((DirectionalLightNode)node);
        } else if (node.isElevationGridNode()) {
            nodeObject = new ElevationGridNodeObject((ElevationGridNode)node);
        } else if (node.isExtrusionNode()) {
            nodeObject = new ExtrusionNodeObject((ExtrusionNode)node);
        } else if (node.isFogNode()) {
            FogNode fogNode = (FogNode)node;
            if (fogNode.isLiner()) {
                nodeObject = new LinerFogNodeObject(fogNode);
            }
            if (fogNode.isExponential()) {
                nodeObject = new ExponentialFogNodeObject(fogNode);
            }
        } else if (node.isFontStyleNode()) {
            nodeObject = null;
        } else if (node.isGroupNode()) {
            nodeObject = new GroupNodeObject((GroupNode)node);
        } else if (node.isImageTextureNode()) {
            ImageTextureLoader imgTexLoader;
            nodeObject = null;
            ImageTextureNode imgTex = (ImageTextureNode)node;
            Canvas3D[] canvas3d = this.getCanvas3Ds();
            if (0 < canvas3d.length && (imgTexLoader = new ImageTextureLoader(imgTex, (Component)canvas3d[0])).hasComponent()) {
                nodeObject = new ImageTextureNodeObject(imgTexLoader);
            }
        } else if (node.isIndexedFaceSetNode()) {
            nodeObject = new IndexedFaceSetNodeObject((IndexedFaceSetNode)node);
        } else if (node.isIndexedLineSetNode()) {
            nodeObject = new IndexedLineSetNodeObject((IndexedLineSetNode)node);
        } else if (node.isInlineNode()) {
            nodeObject = new InlineNodeObject((InlineNode)node);
        } else if (node.isLODNode()) {
            nodeObject = new LODNodeObject((LODNode)node);
        } else if (node.isMaterialNode()) {
            nodeObject = new MaterialNodeObject((MaterialNode)node);
        } else if (node.isNavigationInfoNode()) {
            nodeObject = null;
        } else if (node.isNormalNode()) {
            nodeObject = null;
        } else if (node.isNormalInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isOrientationInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isPixelTextureNode()) {
            nodeObject = new PixelTextureNodeObject((PixelTextureNode)node);
        } else if (node.isPointLightNode()) {
            nodeObject = new PointLightNodeObject((PointLightNode)node);
        } else if (node.isPointSetNode()) {
            nodeObject = new PointSetNodeObject((PointSetNode)node);
        } else if (node.isPositionInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isScalarInterpolatorNode()) {
            nodeObject = null;
        } else if (node.isScriptNode()) {
            nodeObject = null;
        } else if (node.isShapeNode()) {
            nodeObject = new ShapeNodeObject((ShapeNode)node);
        } else if (node.isSphereNode()) {
            nodeObject = new SphereNodeObject((SphereNode)node);
        } else if (node.isSpotLightNode()) {
            nodeObject = new SpotLightNodeObject((SpotLightNode)node);
        } else if (node.isSwitchNode()) {
            nodeObject = new SwitchNodeObject((SwitchNode)node);
        } else if (node.isTextNode()) {
            nodeObject = new TextNodeObject((TextNode)node);
        } else if (node.isTextureTransformNode()) {
            nodeObject = new TextureTransformNodeObject((TextureTransformNode)node);
        } else if (node.isTransformNode()) {
            nodeObject = new TransformNodeObject((TransformNode)node);
        } else if (node.isViewpointNode()) {
            nodeObject = null;
        } else if (node.isWorldInfoNode()) {
            nodeObject = null;
        }
        return nodeObject;
    }

    public boolean setRenderingMode(SceneGraph sg, int mode) {
        for (ShapeNode shapeNode = sg.findShapeNode(); shapeNode != null; shapeNode = (ShapeNode)shapeNode.nextTraversalSameType()) {
            PolygonAttributes polyAttr;
            Appearance app;
            ShapeNodeObject shapeObject = (ShapeNodeObject)shapeNode.getObject();
            if (shapeNode == null || (app = shapeObject.getAppearance()) == null || (polyAttr = app.getPolygonAttributes()) == null) continue;
            if (mode == 0) {
                polyAttr.setPolygonMode(1);
            } else if (mode == 1) {
                polyAttr.setPolygonMode(2);
            }
            app.setPolygonAttributes(polyAttr);
        }
        return true;
    }

    public Shape3D pickShape3D(Canvas3D canvas3D, int mx, int my) {
        PickCanvas pickObject = new PickCanvas(canvas3D, (BranchGroup)this.mRootNode);
        pickObject.setShapeLocation(mx, my);
        PickResult pickResult = pickObject.pickClosest();
        if (pickResult == null) {
            return null;
        }
        Shape3D shape3d = (Shape3D)pickResult.getNode(1);
        return shape3d;
    }

    public ShapeNode pickShapeNode(SceneGraph sg, Canvas3D canvas3D, int mx, int my) {
        Debug.message("SceneGraphJ3dObject::pickShapeNode = " + mx + ", " + my);
        Shape3D pickedShape3D = this.pickShape3D(canvas3D, mx, my);
        ShapeNode pickedShapeNode = null;
        if (pickedShape3D != null) {
            for (ShapeNode shape = sg.findShapeNode(); shape != null; shape = (ShapeNode)shape.nextTraversalSameType()) {
                if (shape.getObject() != pickedShape3D) continue;
                pickedShapeNode = shape;
                break;
            }
        }
        Debug.message("\tPicked Shape3D = " + pickedShape3D);
        Debug.message("\tPicked Shape   = " + pickedShapeNode);
        return pickedShapeNode;
    }

    public void addNodeString(StringBuffer stringBuffer, Node node, int indent) {
        int n;
        for (n = 0; n < indent; ++n) {
            stringBuffer.append('\t');
        }
        stringBuffer.append(node.toString());
        stringBuffer.append('\n');
        try {
            Group gnode = (Group)node;
            for (n = 0; n < gnode.numChildren(); ++n) {
                this.addNodeString(stringBuffer, gnode.getChild(n), indent + 1);
            }
        }
        catch (CapabilityNotSetException e) {
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addNodeString(stringBuffer, (Node)this.getRootNode(), 0);
        return stringBuffer.toString();
    }

    public void outputNode(PrintStream out, org.cybergarage.x3d.node.Node node, int indentLevel) {
        for (int n = 0; n < indentLevel; ++n) {
            out.print("\t");
        }
        String nodeName = node.getName();
        String nodeType = node.getTypeString();
        NodeObject nodeObj = node.getObject();
        if (!node.isInstanceNode()) {
            if (nodeName != null && 0 < nodeName.length()) {
                out.print("DEF " + nodeName + " ");
            }
            out.println(nodeType + " = " + nodeObj);
        } else {
            out.println("USE " + nodeType + " ");
        }
        for (org.cybergarage.x3d.node.Node cnode = node.getChildNodes(); cnode != null; cnode = cnode.next()) {
            this.outputNode(out, cnode, indentLevel + 1);
        }
    }

    public void print(SceneGraph sg) {
        for (org.cybergarage.x3d.node.Node node = sg.getNodes(); node != null; node = node.next()) {
            this.outputNode(System.out, node, 0);
        }
    }
}

