/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.PasswordManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class HostList
extends LinkedList {
    private static Logger logger = Logger.getLogger(HostList.class.getName());
    private static HostList list;
    private final String FS = ConstParameters.FS;
    private String hostsFile = System.getProperty("user.home") + this.FS + ".phase-viewer" + this.FS + "hosts.xml";
    private PasswordManager pass;

    public static HostList getHostList() {
        if (list == null) {
            list = new HostList();
        }
        return list;
    }

    public static String[] getHostNames() {
        HostList li = HostList.getHostList();
        String[] hosts = new String[li.size()];
        for (int i = 0; i < li.size(); ++i) {
            hosts[i] = li.getHostInfo(i).getName();
        }
        return hosts;
    }

    private HostList() {
        if (!new File(this.hostsFile).exists()) {
            this.createHostsFile();
        }
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error(exc);
            logger.warn("can't manage password ...");
        }
        boolean foundLocalhost = false;
        Document document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        Element rootElement = document.getRootElement();
        List list = rootElement.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element ele = (Element)list.get(i);
            String nam = ele.getName();
            HostInfo inf = new HostInfo(nam);
            List children = ele.getChildren();
            for (int j2 = 0; j2 < children.size(); ++j2) {
                Element child = (Element)children.get(j2);
                String key = child.getName();
                String val = MyElement.decode(child.getTextTrim());
                inf.setProperty(key, val);
            }
            if (nam.trim().equals("localhost")) {
                this.addFirst(inf);
                continue;
            }
            this.addLast(inf);
        }
        try {
            this.readPasswordFile();
        }
        catch (IOException ioe) {
            logger.debug("couldn't read password files");
        }
    }

    private void createHostsFile() {
        String vendor;
        Document document = new Document();
        Element rootElement = new Element("hosts");
        Element localHost = new Element("localhost");
        Element address = new Element("address").setText(MyElement.encode("127.0.0.1"));
        Element userName = new Element("username").setText(MyElement.encode(System.getProperty("user.name")));
        Element bindir = new Element("bindir").setText(MyElement.encode(System.getProperty("pviewer.home") + System.getProperty("file.separator") + "bin"));
        Element mpiDir = null;
        if (Utils.isWindows() && (vendor = System.getProperty("pviewer.vendor")) != null && vendor.equalsIgnoreCase("asms")) {
            mpiDir = new Element("mpidir").setText(MyElement.encode(System.getProperty("pviewer.home") + System.getProperty("file.separator") + "mpi"));
        }
        Element basedir = new Element("basedir").setText(MyElement.encode(System.getProperty("user.home") + System.getProperty("file.separator") + "phase-viewer-projects"));
        Element isdefault = new Element("default").setText(MyElement.encode("true"));
        localHost.addContent(address);
        localHost.addContent(userName);
        localHost.addContent(bindir);
        localHost.addContent(basedir);
        localHost.addContent(isdefault);
        if (mpiDir != null) {
            localHost.addContent(mpiDir);
        }
        rootElement.addContent(localHost);
        document.setRootElement(rootElement);
        XMLUtils.saveDocumentTo(document, this.hostsFile);
    }

    public HostInfo getDefaultHost() {
        for (int i = 0; i < this.size(); ++i) {
            String foo = this.getHostInfo(i).getProperty("default");
            if (foo == null || !foo.equalsIgnoreCase("true")) continue;
            return this.getHostInfo(i);
        }
        return this.getHostInfo("localhost");
    }

    public HostInfo getHostInfo(int i) {
        HostInfo info;
        if (i == -1) {
            return null;
        }
        try {
            info = (HostInfo)this.get(i);
        }
        catch (Exception e) {
            logger.warn("failed to get HostInfo at: " + i);
            return null;
        }
        return info;
    }

    public HostInfo getHostInfo(String hostName) {
        for (int i = 0; i < this.size(); ++i) {
            HostInfo hinfo = this.getHostInfo(i);
            if (!hinfo.getName().equals(hostName)) continue;
            return hinfo;
        }
        return null;
    }

    public HostInfo getHostInfoFromAddress(String address) {
        for (int i = 0; i < this.size(); ++i) {
            HostInfo hinfo = this.getHostInfo(i);
            TaggedString[] ts = hinfo.getHostProperties();
            if (ts == null || ts.length == 0) continue;
            for (int j2 = 0; j2 < ts.length; ++j2) {
                if (!ts[j2].getTag().equals("address") || !ts[j2].getValue().equals(address)) continue;
                return hinfo;
            }
        }
        return null;
    }

    protected void debug() {
        for (int i = 0; i < this.size(); ++i) {
            logger.debug("for HostInfo " + i);
            this.getHostInfo(i).debug();
        }
    }

    public void save() {
        int i;
        Document document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        if (document == null) {
            this.createHostsFile();
            document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        }
        Element rootElement = document.getRootElement();
        List list = rootElement.getChildren();
        for (i = 0; i < list.size(); ++i) {
            Element el = (Element)list.get(i);
            boolean valid = false;
            for (int j2 = 0; j2 < this.size(); ++j2) {
                if (!this.getHostInfo(j2).getName().equals(el.getName())) continue;
                valid = true;
            }
            if (valid) continue;
            rootElement.removeContent(el);
        }
        for (i = 0; i < this.size(); ++i) {
            HostInfo info = this.getHostInfo(i);
            String name = info.getName();
            Element elemHost = rootElement.getChild(name);
            if (elemHost == null) {
                elemHost = new Element(name);
                rootElement.addContent(elemHost);
            }
            logger.debug("host: " + elemHost.getName());
            TaggedString[] props = info.getHostProperties();
            for (int j3 = 0; j3 < props.length; ++j3) {
                String key = props[j3].getTag();
                String val = props[j3].getValue();
                Element child = elemHost.getChild(key);
                if (child == null) {
                    child = new Element(key);
                    elemHost.addContent(child);
                }
                child.setText(MyElement.encode(val));
                logger.debug("hostinfo: " + key + ", " + val);
            }
        }
        XMLUtils.saveDocumentTo(document, this.hostsFile);
        Vector<TaggedString> passVector = new Vector<TaggedString>();
        Vector<String> rempassVector = new Vector<String>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            String name;
            HostInfo info = this.getHostInfo(i2);
            String ssavepass = info.getProperty("savepass");
            boolean savepass = false;
            if (ssavepass != null && ssavepass.equalsIgnoreCase("true")) {
                savepass = true;
            }
            if (savepass) {
                name = info.getName();
                String passString = info.getPasswordString();
                passVector.addElement(new TaggedString(name, passString));
                continue;
            }
            name = info.getName();
            rempassVector.addElement(name);
        }
        if (passVector.size() >= 1) {
            try {
                this.writePasswordFile(passVector);
            }
            catch (IOException ioe) {
                logger.error("failed to save encrypted passwords to disk");
            }
        }
        if (rempassVector.size() >= 1) {
            String passwordDir = System.getProperty("user.home") + this.FS + ".phase-viewer" + this.FS + "passwords";
            for (int ii = 0; ii < rempassVector.size(); ++ii) {
                new File(passwordDir + this.FS + (String)rempassVector.elementAt(ii)).delete();
            }
        }
    }

    protected void writePasswordFile(Vector passVector) throws IOException {
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error("failed to create password manager");
            return;
        }
        String passwordDir = System.getProperty("user.home") + this.FS + ".phase-viewer" + this.FS + "passwords";
        new File(passwordDir).mkdir();
        for (int i = 0; i < passVector.size(); ++i) {
            TaggedString data = (TaggedString)passVector.get(i);
            String name = data.getTag().trim();
            String passwd = data.getValue().trim();
            byte[] passb = null;
            try {
                passb = this.pass.getEncryptedPassword(passwd);
            }
            catch (Exception exc) {
                logger.error("failed to encrypt password");
                continue;
            }
            if (passb == null) continue;
            BufferedOutputStream bostream = new BufferedOutputStream(new FileOutputStream(passwordDir + this.FS + name));
            bostream.write(passb, 0, passb.length);
            bostream.flush();
        }
    }

    protected void readPasswordFile() throws IOException {
        File passwdDir = new File(System.getProperty("user.home") + this.FS + ".phase-viewer" + this.FS + "passwords");
        if (!passwdDir.exists()) {
            return;
        }
        File[] passwdFiles = passwdDir.listFiles();
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error(exc);
            logger.warn("can't manage password ...");
            return;
        }
        for (int i = 0; i < passwdFiles.length; ++i) {
            String name = passwdFiles[i].getName();
            BufferedInputStream bistream = new BufferedInputStream(new FileInputStream(passwdDir.getAbsolutePath() + this.FS + name));
            byte[] pas = new byte[bistream.available()];
            bistream.read(pas);
            String planepass = "";
            try {
                planepass = this.pass.getPlanePassword(pas);
                logger.debug("plain password: " + planepass);
            }
            catch (Exception exc) {
                logger.debug("couldn't get plain password...");
                continue;
            }
            for (int j2 = 0; j2 < this.size(); ++j2) {
                HostInfo info = this.getHostInfo(j2);
                if (!info.getName().trim().equals(name)) continue;
                info.setPasswordString(planepass);
                info.setSavePassword(true);
            }
        }
    }
}

