/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptexecscripts;

import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptexecscripts.ScriptExecScript;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ExecScriptCreator {
    private static Logger logger = Logger.getLogger(ExecScriptCreator.class.getName());

    private ExecScriptCreator() {
    }

    public static String getScriptExecScript(String scriptType, ScriptWrapper[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            logger.error("no exec scripts.");
            return "";
        }
        String[] string = new String[execScripts.length];
        for (int i = 0; i < execScripts.length; ++i) {
            string[i] = new File(execScripts[i].getPath()).getName();
        }
        String ret = ExecScriptCreator.getScriptExecScript(scriptType, string, hostInfo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptExecScript(String scriptType, String[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            logger.error("no exec scripts.");
            return "";
        }
        ScriptExecScript execscript = ExecScriptCreator.getScriptExecScriptSub(scriptType);
        if (execscript == null) {
            logger.error("failed to get exec script creator.");
            return "";
        }
        String file = System.getProperty("java.io.tmpdir");
        if (!file.endsWith(System.getProperty("file.separator"))) {
            file = file + System.getProperty("file.separator");
        }
        file = file + execscript.getScriptExecScriptName(hostInfo);
        String script = execscript.createScriptExecScript(execScripts, hostInfo);
        BufferedWriter bwriter = null;
        try {
            new File(file).delete();
            bwriter = new BufferedWriter(new FileWriter(file));
            bwriter.write(script, 0, script.length());
            bwriter.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                bwriter.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return file;
    }

    public static String getScriptExecScriptExecString(String scriptType, String scriptExecScript, HostInfo hostInfo) {
        ScriptExecScript execscript = ExecScriptCreator.getScriptExecScriptSub(scriptType);
        return execscript.getScriptExecScriptExecString(scriptExecScript, hostInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptExecScript getScriptExecScriptSub(String scriptType) {
        boolean registered = false;
        for (int i = 0; i < ScriptWrapper.REGISTERED_SCRIPT_TYPE.length; ++i) {
            if (!scriptType.equals(ScriptWrapper.REGISTERED_SCRIPT_TYPE[i])) continue;
            registered = true;
            break;
        }
        if (!registered) {
            logger.error("unsupported script type!");
            return null;
        }
        Properties props = new Properties();
        InputStream inp = null;
        try {
            inp = ExecScriptCreator.class.getResourceAsStream("/ciss/phase_viewer/scripting/scriptexecscripts/scriptexecscripts.properties");
            props.load(inp);
        }
        catch (IOException ioe) {
            logger.error("failed to load property file...");
        }
        finally {
            try {
                inp.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        String loadClass = props.getProperty(scriptType);
        if (loadClass == null || loadClass.trim().length() == 0) {
            logger.error("invalid properties file...");
            return null;
        }
        ScriptExecScript execscript = (ScriptExecScript)PluginLoader.instantiate(loadClass, null);
        return execscript;
    }
}

