/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.Drawable;
import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.graph.SimpleChart;
import ciss.phase_viewer.graph.chart.ChartCreator;
import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.export.PDFExportFileType;
import ciss.phase_viewer.graph.export.SVGExportFileType;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportDialog;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.DefaultPieDataset;

public class GraphPanel
extends InternalFrameChase
implements Drawable,
MouseListener,
MouseMotionListener {
    private Logger logger = Logger.getLogger(GraphPanel.class.getName());
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private DefaultPieDataset datasetpie = new DefaultPieDataset();
    private ChartCreator chartCreator;
    private PlotProperties plotProperties;
    private Vector childrenPanel = new Vector();
    private String baseDir;
    private JLabel labelxy;
    private double translate_factor = 0.33;
    private double zoom_factor = 1.3;
    private JToggleButton btntoggle;
    private boolean disableDrag = true;
    private PlotAttributesEditor paeditor;
    private Format format = ConstParameters.formater_float;
    private float[] prevPos = null;
    private int ignoreCount = 0;
    private ValueAxis[] domains;
    private ValueAxis[] ranges;
    private double[] xmins;
    private double[] xmaxs;
    private double[] ymins;
    private double[] ymaxs;
    private int numdomain;
    private int numrange;
    private boolean dragging1 = false;
    private boolean dragging3 = false;

    public GraphPanel(SimpleChart simpleChart) {
        super(simpleChart.getFrameTitle(), true, true, true, true, simpleChart.getSize());
        this.chart = simpleChart.getChart();
        this.plotProperties = new PlotProperties();
        this.baseDir = System.getProperty("user.dir");
        if (this.chart == null) {
            this.logger.error("plot failed.");
            this.dispose();
            return;
        }
        this.createGUI();
        this.setSize(simpleChart.getSize());
    }

    public GraphPanel(String title, PlotProperties properties, String baseDir) {
        super(title, true, true, true, true, new Dimension(512, 512));
        this.plotProperties = properties;
        if (baseDir == null) {
            baseDir = System.getProperty("user.dir");
        }
        this.baseDir = baseDir;
        this.chartCreator = new ChartCreator();
        this.chart = this.chartCreator.getChart(properties);
        if (this.chart == null) {
            this.logger.error("plot failed.");
            this.dispose();
            return;
        }
        this.createGUI();
    }

    private void createGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BorderLayout());
        pbtn.add((Component)this.createButtonPanel(), "West");
        container.add(pbtn);
        this.chartPanel = new ChartPanel(this.chart, true, true, true, true, true);
        this.chartPanel.setPreferredSize(this.getSize());
        container.add(this.chartPanel);
        this.chartPanel.addMouseMotionListener(this);
        this.chartPanel.addMouseListener(this);
        this.labelxy = new JLabel("x: y: ");
        if (this.plotProperties.getPlotType() == 0) {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.labelxy, "West");
            this.getContentPane().add((Component)p, "South");
        }
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        String trans = props.getProperty("graph_mouse_motion_translate_factor");
        String zoom = props.getProperty("graph_mouse_motion_zoom_factor");
        try {
            this.translate_factor = Double.parseDouble(trans);
            this.zoom_factor = Double.parseDouble(zoom);
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    public GraphPanel(String title, PlotProperties properties) {
        this(title, properties, System.getProperty("user.dir"));
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public PlotProperties getPlotProperties() {
        return this.plotProperties;
    }

    public String toString() {
        return "title: " + this.title;
    }

    public void addChildrenPanel(JInternalFrame frame) {
        this.childrenPanel.addElement(frame);
    }

    private void addDestroyer() {
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameClosed(InternalFrameEvent ec) {
            }

            public void internalFrameActivated(InternalFrameEvent ea) {
            }

            public void internalFrameClosing(InternalFrameEvent eclosing) {
                GraphPanel.this.destroy();
            }

            public void internalFrameDeactivated(InternalFrameEvent edea) {
            }

            public void internalFrameDeiconified(InternalFrameEvent edei) {
            }

            public void internalFrameIconified(InternalFrameEvent ei) {
            }

            public void internalFrameOpened(InternalFrameEvent eo) {
            }
        });
    }

    private void destroy() {
        for (int i = 0; i < this.childrenPanel.size(); ++i) {
            ((JInternalFrame)this.childrenPanel.get(i)).dispose();
        }
        this.dispose();
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton btnproperty = new JButton(Resources.getIcon("/toolbarButtonGraphics/general/Properties16.gif"));
        btnproperty.setToolTipText("boot property editor");
        JButton btnexport = new JButton(Resources.getIcon("/toolbarButtonGraphics/general/Export16.gif"));
        btnexport.setToolTipText("export plot to graphics file");
        JButton btnclose = new JButton(Resources.getIcon("/org/javalobby/icons/16x16/Exit.gif"));
        btnclose.setToolTipText("exit");
        this.btntoggle = new JToggleButton(Resources.getIcon("/org/javalobby/icons/16x16/BlueCircle.gif"));
        this.btntoggle.setToolTipText("toggle mouse-motion listener");
        p.add(btnproperty);
        p.add(btnexport);
        p.add(this.btntoggle);
        p.add(btnclose);
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.chart = null;
                GraphPanel.this.chartPanel = null;
                GraphPanel.this.destroy();
            }
        });
        btnexport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.export();
            }
        });
        btnproperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.bootPropertyEditor();
            }
        });
        this.btntoggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.toggleMouseMotionListener();
            }
        });
        return p;
    }

    private void toggleMouseMotionListener() {
        if (this.btntoggle.isSelected()) {
            this.chartPanel.removeMouseMotionListener(this.chartPanel);
            this.chartPanel.removeMouseListener(this.chartPanel);
            this.disableDrag = false;
        } else {
            this.chartPanel.addMouseMotionListener(this.chartPanel);
            this.chartPanel.addMouseListener(this.chartPanel);
            this.disableDrag = true;
        }
    }

    private void bootPropertyEditor() {
        this.paeditor = new PlotAttributesEditor(this);
    }

    public PlotAttributesEditor getEditor() {
        return this.paeditor;
    }

    private void export() {
        String inidir = new String();
        PDFExportFileType pdfexport = new PDFExportFileType(this);
        SVGExportFileType svgexport = new SVGExportFileType(this);
        ExportDialog exportD = new ExportDialog();
        Properties prop = new Properties();
        prop.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", this.baseDir + System.getProperty("file.separator") + this.title);
        exportD.setUserProperties(prop);
        exportD.addExportFileType(pdfexport);
        exportD.addExportFileType(svgexport);
        exportD.showExportDialog(this, "export view as ...", this.chartPanel, this.title);
    }

    public void draw(Graphics2D g2d, Rectangle2D rec) {
        this.chart.draw(g2d, rec);
    }

    public void mouseMoved(MouseEvent e) {
        float[] pos = this.mousePos2GraphPos(e);
        if (pos != null) {
            this.labelxy.setText(" x:  " + this.format.format(new Float(pos[0])) + "  y:  " + this.format.format(new Float(pos[1])));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.disableDrag) {
            return;
        }
        if (this.dragging3 || this.dragging1) {
            this.changeGraph(e);
        }
    }

    private void changeGraph(MouseEvent e) {
        int i;
        int i2;
        if (this.prevPos == null) {
            this.prevPos = this.mousePos2GraphPos(e);
            return;
        }
        float[] currentPos = this.mousePos2GraphPos(e);
        if (currentPos == null) {
            return;
        }
        this.logger.debug("currentPos: x=" + currentPos[0] + ", y=" + currentPos[1]);
        this.logger.debug("previousPos: x=" + this.prevPos[0] + ", y=" + this.prevPos[1]);
        float[] difxs = new float[this.numdomain];
        float[] difys = new float[this.numrange];
        for (i2 = 0; i2 < this.numdomain; ++i2) {
            difxs[i2] = this.prevPos[i2] - currentPos[i2];
        }
        for (i2 = this.numdomain; i2 < this.numrange + this.numdomain; ++i2) {
            difys[i2 - this.numdomain] = this.prevPos[i2] - currentPos[i2];
        }
        Plot plot = this.getChart().getPlot();
        if (!(plot instanceof CombinedDomainXYPlot || plot instanceof CombinedRangeXYPlot || plot instanceof XYPlot)) {
            return;
        }
        PlotRenderingInfo plotinfo = this.getChartPanel().getChartRenderingInfo().getPlotInfo();
        XYPlot xyplot = null;
        if (plot instanceof CombinedDomainXYPlot) {
            xyplot = ((CombinedDomainXYPlot)plot).findSubplot(plotinfo, new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof CombinedRangeXYPlot) {
            xyplot = ((CombinedRangeXYPlot)plot).findSubplot(plotinfo, new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof XYPlot) {
            xyplot = (XYPlot)plot;
        }
        if (xyplot == null) {
            return;
        }
        double factormin = 0.0;
        double factormax = 0.0;
        if (this.dragging3) {
            factormin = this.translate_factor;
            factormax = this.translate_factor;
        } else if (this.dragging1) {
            factormin = -this.zoom_factor;
            factormax = this.zoom_factor;
        }
        for (i = 0; i < this.numdomain; ++i) {
            double newxmin = this.xmins[i] + (double)difxs[i] * factormin;
            double newxmax = this.xmaxs[i] + (double)difxs[i] * factormax;
            this.domains[i].setLowerBound(newxmin);
            this.domains[i].setUpperBound(newxmax);
        }
        for (i = 0; i < this.numrange; ++i) {
            double newymin = this.ymins[i] + (double)difys[i] * factormin;
            double newymax = this.ymaxs[i] + (double)difys[i] * factormax;
            this.ranges[i].setLowerBound(newymin);
            this.ranges[i].setUpperBound(newymax);
        }
        this.prevPos = currentPos;
    }

    private float[] mousePos2GraphPos(MouseEvent e) {
        int i;
        int i2;
        Plot plot = this.getChart().getPlot();
        if (!(plot instanceof CombinedDomainXYPlot || plot instanceof CombinedRangeXYPlot || plot instanceof XYPlot)) {
            return null;
        }
        PlotRenderingInfo plotinfo = this.getChartPanel().getChartRenderingInfo().getPlotInfo();
        XYPlot xyplot = null;
        if (plot instanceof CombinedDomainXYPlot) {
            xyplot = ((CombinedDomainXYPlot)plot).findSubplot(plotinfo, new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof CombinedRangeXYPlot) {
            xyplot = ((CombinedRangeXYPlot)plot).findSubplot(plotinfo, new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof XYPlot) {
            xyplot = (XYPlot)plot;
        }
        if (xyplot == null) {
            return null;
        }
        this.numdomain = xyplot.getDomainAxisCount();
        this.domains = new ValueAxis[this.numdomain];
        this.xmins = new double[this.numdomain];
        this.xmaxs = new double[this.numdomain];
        for (i2 = 0; i2 < this.numdomain; ++i2) {
            this.domains[i2] = xyplot.getDomainAxis(i2);
            this.xmins[i2] = this.domains[i2].getLowerBound();
            this.xmaxs[i2] = this.domains[i2].getUpperBound();
        }
        this.numrange = xyplot.getRangeAxisCount();
        this.ranges = new ValueAxis[this.numrange];
        this.ymins = new double[this.numrange];
        this.ymaxs = new double[this.numrange];
        for (i2 = 0; i2 < this.numrange; ++i2) {
            this.ranges[i2] = xyplot.getRangeAxis(i2);
            this.ymins[i2] = this.ranges[i2].getLowerBound();
            this.ymaxs[i2] = this.ranges[i2].getUpperBound();
        }
        Rectangle2D dataArea = this.getChartPanel().getScreenDataArea(e.getX(), e.getY());
        if (dataArea == null) {
            return null;
        }
        double x = (double)e.getX() - dataArea.getX();
        double y = dataArea.getY() + dataArea.getHeight() - (double)e.getY();
        float[] posxs = new float[this.numdomain];
        for (int i3 = 0; i3 < this.numdomain; ++i3) {
            double xhh = (this.xmaxs[i3] - this.xmins[i3]) / dataArea.getWidth();
            posxs[i3] = (float)(this.xmins[i3] + x * xhh);
        }
        float[] posys = new float[this.numrange];
        for (int i4 = 0; i4 < this.numrange; ++i4) {
            double yhh = (this.ymaxs[i4] - this.ymins[i4]) / dataArea.getHeight();
            posys[i4] = (float)(this.ymins[i4] + y * yhh);
        }
        float[] ret = new float[this.numdomain + this.numrange];
        for (i = 0; i < this.numdomain; ++i) {
            ret[i] = posxs[i];
        }
        for (i = this.numdomain; i < this.numrange + this.numdomain; ++i) {
            ret[i] = posys[i - this.numdomain];
        }
        return ret;
    }

    public void mouseReleased(MouseEvent e) {
        this.prevPos = null;
        this.dragging3 = false;
        this.dragging1 = false;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.dragging3 = true;
        } else if (e.getButton() == 1) {
            this.dragging1 = true;
        }
        this.prevPos = null;
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

