/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import ciss.phase_viewer.outputinterface.OutputData;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

class DataTab
extends JPanel {
    private OutputData data;
    private Logger logger = Logger.getLogger(DataTab.class.getName());
    private JTable table;

    protected DataTab(OutputData data) {
        this.data = data;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (this.data.getHeader() != null && this.data.getHeader().length() != 0) {
            panel.add(this.createHeaderPanel());
        }
        panel.add(this.createTable());
        this.add(panel);
    }

    private JPanel createHeaderPanel() {
        JScrollPane scr = new JScrollPane();
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("info"));
        p.setLayout(new BoxLayout(p, 1));
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setText(this.data.getHeader());
        scr.getViewport().setView(textArea);
        p.add(scr);
        return p;
    }

    private JPanel createTable() {
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("data"));
        p.setLayout(new BoxLayout(p, 1));
        JScrollPane scr = new JScrollPane();
        Object[] ident = this.data.getIdentifier();
        Object[][] data2d = this.data.getData2D();
        if (data2d == null || data2d.length == 0) {
            this.logger.debug("no data!");
            return p;
        }
        if (ident == null || ident.length == 0) {
            ident = new String[data2d[0].length];
            for (int i = 0; i < ident.length; ++i) {
                ident[i] = "-";
            }
        }
        DefaultTableModel tableModel = new DefaultTableModel(data2d, ident);
        this.table = new JTable(tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
        scr.getViewport().setView(this.table);
        p.add(scr);
        return p;
    }

    protected JTable getTable() {
        return this.table;
    }

    protected String getDataName() {
        return this.data.getName();
    }
}

