/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.filebrowser.BtnUp;
import ciss.phase_viewer.filebrowser.ComboBoxFileBrowser;
import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserNode;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import ciss.phase_viewer.filebrowser.FileBrowserUtils;
import ciss.phase_viewer.filebrowser.FilePropertyViewer;
import ciss.phase_viewer.filebrowser.FileTransfer;
import ciss.phase_viewer.filebrowser.KeyListenerTree;
import ciss.phase_viewer.filebrowser.MouseListenerTree;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FileBrowserTree
extends JPanel
implements SftpListener {
    private static Logger logger = Logger.getLogger(FileBrowserTree.class.getName());
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    private int type = 0;
    private int os = 0;
    private String initialDir;
    private String FS = System.getProperty("file.separator");
    private int curdir = 0;
    private RemoteFile[] templist;
    private RemoteFile[][] work = new RemoteFile[512][];
    private RemoteFile root;
    private JScrollPane scrollpane;
    protected JTree tree;
    private Vector listeners = new Vector();
    private boolean isremote = false;
    private ChannelSftp c;
    private boolean initExpand = true;
    private FileBrowserTreeListener parent;
    private String nodeClassString;
    private Vector mouseListeners = new Vector();
    private boolean useCombo = true;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private boolean bootingEditor = false;
    private boolean editor = true;
    private String[] tmpFiles;
    private FileTransfer transfer;

    public FileBrowserTree(int os, String initialDir, FileBrowserTreeListener parent, String nodeClassString, boolean init) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.nodeClassString = nodeClassString;
        if (init) {
            this.init();
        }
    }

    public FileBrowserTree(int os, String initialDir, FileBrowserTreeListener parent, String nodeClassString, boolean init, boolean useCombo) {
        this.os = os;
        this.initialDir = initialDir;
        this.parent = parent;
        this.nodeClassString = nodeClassString;
        this.useCombo = useCombo;
        if (init) {
            this.init();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setChannelSftp(ChannelSftp c) {
        this.c = c;
    }

    public void setParent(FileBrowserTreeListener parent) {
        this.parent = parent;
    }

    public RemoteFile[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            logger.info("no file selected!");
            return null;
        }
        RemoteFile[] ret = new RemoteFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            ret[i] = this.getSubDirList(paths[i]);
        }
        return ret;
    }

    public RemoteFile getCurrentDir() {
        TreePath path = this.tree.getSelectionPath();
        RemoteFile f = this.getSubDirList(path);
        if (f == null) {
            return null;
        }
        logger.debug("file: " + f + ", isDir: " + f.isDirectory());
        RemoteFile ret = f;
        if (!f.isDirectory()) {
            ret = (RemoteFile)f.getParentFile();
            logger.debug("dir at getcurrentdir: " + ret);
        }
        return ret;
    }

    public void setRemote(boolean isremote) {
        this.isremote = isremote;
    }

    public boolean isRemote() {
        return this.isremote;
    }

    public void addFileBrowserListener(FileBrowserTreeListener fbl) {
        this.listeners.addElement(fbl);
    }

    public void init(String initialDir) {
        this.initialDir = initialDir;
        this.init();
    }

    public void reload() {
        int i;
        Vector<Enumeration<TreePath>> vector = new Vector<Enumeration<TreePath>>();
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            vector.addElement(this.tree.getExpandedDescendants(this.tree.getPathForRow(i)));
        }
        this.init();
        for (i = 0; i < vector.size(); ++i) {
            Enumeration enumeration = (Enumeration)vector.get(i);
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                TreePath tp = (TreePath)enumeration.nextElement();
                logger.debug("expanded path: " + tp.toString());
                this.tree.expandPath(tp);
                this.tree.scrollPathToVisible(tp);
            }
        }
    }

    public void init() {
        String exp;
        if (this.os == 1) {
            this.FS = "/";
        }
        if ((exp = PropertiesManager.getGlobalProperties(0).getProperty("file_browser_init_expand")) != null && exp.trim().equalsIgnoreCase("false")) {
            this.initExpand = false;
        }
        this.setLayout(new BoxLayout(this, 1));
        if (this.initialDir != null && this.initialDir.trim().length() != 0 && this.os != 0) {
            logger.debug("initialDir: " + this.initialDir);
            String[] array = this.initialDir.trim().split("/");
            String newinitdir = "";
            if (array != null && array.length != 0) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i].trim().length() == 0) continue;
                    newinitdir = newinitdir + "/" + array[i];
                }
                this.initialDir = newinitdir;
                logger.debug("new initdir: " + this.initialDir);
            }
        }
        if (this.root == null) {
            if (this.initialDir == null || !new RemoteFile(this.initialDir, this.c).exists()) {
                logger.debug("initial dir doesn't exist / null");
                this.root = this.os == 0 ? new RemoteFile(System.getProperty("user.home")) : new RemoteFile("/", this.c);
            } else {
                logger.debug("initial dir exists.");
                this.root = new RemoteFile(this.initialDir + this.FS, this.c);
            }
        }
        this.root.isRoot(true);
        this.createTree();
    }

    public void setRoot(String newRoot) {
        RemoteFile test2 = new RemoteFile(newRoot, this.c);
        if (!test2.exists()) {
            return;
        }
        this.initialDir = newRoot;
        this.root = new RemoteFile(newRoot, this.c);
        this.root.isRoot(true);
        this.init();
    }

    public void bootFilePropertyViewer() {
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            FilePropertyViewer filePropertyViewer = new FilePropertyViewer(selectedFiles);
        }
    }

    public void createNewFile() {
        String message = "enter new file name";
        RemoteFile file = this.getSelectedFiles()[0];
        RemoteFile newfile = this.getNewFile(message, file);
        if (newfile == null) {
            logger.info("canceled.");
            return;
        }
        try {
            if (!newfile.createNewFile()) {
                logger.error("failed to create file " + file);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.init();
    }

    public void bootProgram(boolean editor) {
        this.editor = editor;
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null && !this.isRemote()) {
            for (int i = 0; i < selectedFiles.length; ++i) {
                FileBrowserUtils.bootProgram(editor, selectedFiles[i].getAbsolutePath());
            }
        } else if (selectedFiles != null && this.isRemote()) {
            Vector<String> tmpvec = new Vector<String>();
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (selectedFiles[i].isDirectory()) continue;
                tmpvec.addElement(selectedFiles[i].getName());
            }
            if (tmpvec.size() == 0) {
                return;
            }
            this.bootingEditor = true;
            this.tmpFiles = new String[tmpvec.size()];
            tmpvec.copyInto(this.tmpFiles);
            this.transfer.downloadToTmpFile();
        }
    }

    public void deleteSelectedFiles() {
        boolean warn = true;
        String ask = this.gp.getProperty("sftp_client_ask_delfile");
        if (ask != null) {
            logger.debug("ask: " + ask);
            if (ask.trim().equals("false")) {
                warn = false;
                logger.debug("deleteing file without warning");
            } else {
                logger.debug("warn");
            }
        } else {
            logger.debug("sftp_client_ask_deflfile not set, using default");
        }
        RemoteFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            int res = 0;
            if (warn) {
                String message = "deleting " + selectedFiles.length + " file(s) ... proceed?";
                res = JOptionPane.showInternalConfirmDialog(Desk.getDesktop(), message);
            }
            if (res == 0) {
                for (int i = 0; i < selectedFiles.length; ++i) {
                    logger.info("deleteing file: " + selectedFiles[i].getAbsolutePath());
                    boolean b = selectedFiles[i].delete();
                    if (b) continue;
                    logger.warn("failed to delete: " + selectedFiles[i].getAbsolutePath());
                }
            }
        }
        this.init();
    }

    public void mkdir() {
        logger.debug("running....");
        RemoteFile file = this.getSelectedFiles()[0];
        String message = "enter new directory name";
        RemoteFile newdir = this.getNewFile(message, file);
        if (newdir == null) {
            logger.info("canceled.");
            return;
        }
        new Thread(new DirMaker(newdir)).start();
    }

    public void rename() {
        String message = "enter new file name";
        RemoteFile file = this.getSelectedFiles()[0];
        RemoteFile renameTo = this.getNewFile(message, file);
        if (renameTo == null) {
            logger.info("canceled.");
            return;
        }
        new Thread(new Renamer(file, renameTo)).start();
    }

    public void setFileTransfer(FileTransfer transfer) {
        this.transfer = transfer;
    }

    public void uploadFiles() {
        if (this.transfer != null) {
            this.transfer.uploadFiles();
        }
    }

    public void downloadFiles() {
        if (this.transfer != null) {
            this.transfer.downloadFiles();
        }
    }

    public String[] getSelectedPaths() {
        RemoteFile[] files = this.getSelectedFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        String[] ret = new String[files.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = files[i].getAbsolutePath();
        }
        return ret;
    }

    public boolean isConnected() {
        if (this.transfer != null) {
            return this.transfer.isConnected();
        }
        return false;
    }

    private RemoteFile getNewFile(String message, RemoteFile file) {
        logger.debug("getting file name....");
        String name = JOptionPane.showInternalInputDialog(Desk.getDesktop(), message);
        logger.debug("got file name: " + name);
        if (name == null) {
            return null;
        }
        RemoteFile parent = null;
        parent = !file.isDirectory() ? (RemoteFile)file.getParentFile() : new RemoteFile(file.getAbsolutePath(), this.c);
        String newfile = "";
        String fs = file.getSeparator();
        if (parent != null) {
            newfile = parent.getAbsolutePath() + fs;
            newfile = newfile + name;
        }
        return new RemoteFile(newfile, this.c);
    }

    private void createTree() {
        FileBrowserNode treenode = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{this.root});
        this.tree = new JTree(treenode);
        this.tree.setSelectionRow(0);
        FileBrowserNode treenode_tmp = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{""});
        treenode.add(treenode_tmp);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath tp = e.getPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.addExpandTree(tp, file);
            }

            public void treeWillCollapse(TreeExpansionEvent e) {
                TreePath tp = e.getPath().getParentPath();
                RemoteFile file = FileBrowserTree.this.getSubDirList(tp);
                FileBrowserTree.this.showDirectory(tp, file);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FileBrowserTree.this.notifyListeners();
            }
        });
        this.tree.addMouseListener(new MouseListenerTree(this));
        this.tree.addKeyListener(new KeyListenerTree(this));
        this.removeAll();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (this.useCombo) {
            ComboBoxFileBrowser combo = new ComboBoxFileBrowser(this, this.c);
            p.add(combo);
        } else {
            BtnUp up = new BtnUp(this, this.c);
            p.add(up);
        }
        JButton btnreload = new JButton("reload");
        p.add(btnreload);
        this.add(p);
        this.scrollpane = new JScrollPane(this.tree);
        this.add(this.scrollpane);
        if (this.initExpand) {
            this.tree.expandRow(0);
        }
        this.revalidate();
        btnreload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileBrowserTree.this.reload();
            }
        });
    }

    private void notifyListeners() {
        FileBrowserEvent fbe = new FileBrowserEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FileBrowserTreeListener)this.listeners.elementAt(i)).directoryHasChanged(fbe);
        }
    }

    private void addExpandTree(TreePath tp, RemoteFile file) {
        if (file == null) {
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        logger.debug("at addExpandTree: " + node.toString());
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            int i;
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            Arrays.sort(this.templist);
            Vector<RemoteFile> dirs = new Vector<RemoteFile>();
            Vector<RemoteFile> fil = new Vector<RemoteFile>();
            for (int i2 = 0; i2 < this.templist.length; ++i2) {
                if (this.templist[i2].isDirectory()) {
                    dirs.add(this.templist[i2]);
                    continue;
                }
                fil.add(this.templist[i2]);
            }
            int count = 0;
            for (i = 0; i < dirs.size(); ++i) {
                this.templist[count] = (RemoteFile)dirs.get(i);
                ++count;
            }
            for (i = 0; i < fil.size(); ++i) {
                this.templist[count] = (RemoteFile)fil.get(i);
                ++count;
            }
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            logger.debug("templist");
            for (i = 0; i < this.templist.length; ++i) {
                logger.debug("templist: " + this.templist[i].getAbsolutePath());
            }
            node.removeAllChildren();
            for (i = 0; i < this.work[this.curdir].length; ++i) {
                Object[] files;
                FileBrowserNode temp = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{this.work[this.curdir][i]});
                logger.debug("at addExpandTree: " + temp.toString());
                node.add(temp);
                if (!this.work[this.curdir][i].isDirectory() || (files = (RemoteFile[])this.work[this.curdir][i].listFiles()) == null || files.length == 0) continue;
                Arrays.sort(files);
                for (int j = 0; j < files.length; ++j) {
                    FileBrowserNode tempsub = FileBrowserNode.getInstance(this.nodeClassString, new Object[]{files[j]});
                    logger.debug("tempsub: " + tempsub.toString());
                    temp.add(tempsub);
                }
            }
        }
    }

    private void showDirectory(TreePath tp, RemoteFile file) {
        if (file == null) {
            this.templist = new RemoteFile[1];
            ++this.curdir;
            this.work[this.curdir] = this.templist;
            return;
        }
        FileBrowserNode node = (FileBrowserNode)tp.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (file.isDirectory()) {
            int i;
            this.templist = (RemoteFile[])file.listFiles();
            if (this.templist.length == 0) {
                return;
            }
            ++this.curdir;
            Vector<RemoteFile> dirs = new Vector<RemoteFile>();
            Vector<RemoteFile> files = new Vector<RemoteFile>();
            for (int i2 = 0; i2 < this.templist.length; ++i2) {
                if (this.templist[i2].isDirectory()) {
                    dirs.add(this.templist[i2]);
                    continue;
                }
                files.add(this.templist[i2]);
            }
            int count = 0;
            for (i = 0; i < dirs.size(); ++i) {
                this.templist[count] = (RemoteFile)dirs.get(i);
                ++count;
            }
            for (i = 0; i < files.size(); ++i) {
                this.templist[count] = (RemoteFile)files.get(i);
                ++count;
            }
            this.work[this.curdir] = this.templist;
        }
    }

    private RemoteFile getSubDirList(TreePath treepath) {
        if (treepath == null) {
            return null;
        }
        String string = treepath.getPathComponent(0).toString();
        if (!string.trim().endsWith(this.FS)) {
            string = string + this.FS;
        }
        int count = treepath.getPathCount();
        for (int i = 1; i < count; ++i) {
            string = string + treepath.getPathComponent(i).toString();
            if (i + 1 == count) break;
            string = string + this.FS;
        }
        logger.debug("subdirlist: " + string);
        return new RemoteFile(string, this.c);
    }

    protected RemoteFile getCurrentRoot() {
        return this.root;
    }

    protected void setNewRoot(RemoteFile newRoot) {
        this.root = newRoot;
        this.root.isRoot(true);
        this.createTree();
    }

    protected ChannelSftp getChannelSftp() {
        return this.c;
    }

    public void uploadFinished(SftpEvent e) {
    }

    public void downloadFinished(SftpEvent e) {
        if (this.bootingEditor && this.tmpFiles != null && this.tmpFiles.length != 0) {
            String dir = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator");
            for (int i = 0; i < this.tmpFiles.length; ++i) {
                FileBrowserUtils.bootProgram(this.editor, dir + this.tmpFiles[i]);
            }
            this.bootingEditor = false;
        }
    }

    class Renamer
    implements Runnable {
        private RemoteFile origfile;
        private RemoteFile newfile;

        protected Renamer(RemoteFile origfile, RemoteFile newfile) {
            this.origfile = origfile;
            this.newfile = newfile;
        }

        public void run() {
            boolean res = this.origfile.renameTo(this.newfile);
            if (!res) {
                logger.warn("failed rename");
                return;
            }
            FileBrowserTree.this.init();
        }
    }

    class DirMaker
    implements Runnable {
        private RemoteFile newdir;

        protected DirMaker(RemoteFile newdir) {
            this.newdir = newdir;
            logger.debug("instantiated DirMaker");
        }

        public void run() {
            logger.info("creating new dir: " + this.newdir.getAbsolutePath());
            this.newdir.mkdir();
            FileBrowserTree.this.init();
        }
    }
}

