/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import org.apache.log4j.Logger;

public class Monoclinic
extends BravaisLattice {
    private Logger logger = Logger.getLogger(Monoclinic.class.getName());

    public String getName() {
        return this.latticeSystem + " monoclinic";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (this.latticeSystem.equals("basecentered")) {
            double[] avec = new double[]{0.5 * this.a, -0.5 * this.b, 0.0};
            double[] bvec = new double[]{0.5 * this.a, 0.5 * this.b, 0.0};
            double be = this.beta * (Math.PI / 180);
            double[] cvec = new double[]{this.c * Math.cos(be), 0.0, this.c * Math.sin(be)};
            return new double[][]{avec, bvec, cvec};
        }
        return this.getGenericPrimitiveVector();
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha, double beta, double gamma) {
        boolean len = !this.epsilonEquals(a, b) && !this.epsilonEquals(b, c) && !this.epsilonEquals(a, c);
        boolean ang = this.epsilonEquals(alpha, 90.0) && !this.epsilonEquals(beta, 90.0) && this.epsilonEquals(gamma, 90.0);
        return len && ang;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[]{"primitive", "basecentered"};
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        boolean b4;
        if (!this.epsilonEquals(this.a, this.b) && !this.epsilonEquals(this.b, this.c) && !this.epsilonEquals(this.a, this.c) && this.epsilonEquals(this.alpha, 90.0) && !this.epsilonEquals(this.beta, 90.0) && this.epsilonEquals(this.gamma, 90.0)) {
            return this;
        }
        double cosbeta = Math.cos(Math.PI / 180 * this.beta);
        double sinbeta = Math.sin(Math.PI / 180 * this.beta);
        if (this.epsilonEquals(cosbeta, 0.0) || this.epsilonEquals(sinbeta, 0.0)) {
            return null;
        }
        boolean b1 = this.epsilonEquals(avec[0], bvec[0]) && this.epsilonEquals(avec[1], -bvec[1]);
        boolean b2 = this.epsilonEquals(avec[2], 0.0) && this.epsilonEquals(bvec[2], 0.0);
        boolean b3 = !this.epsilonEquals(avec[0], -avec[1]);
        boolean bl = b4 = !this.epsilonEquals(this.beta, 90.0);
        if (b1 && b2 && b3 && b4) {
            this.logger.debug("base-centered monoclinic");
            Monoclinic mono = new Monoclinic();
            mono.a = avec[0] * 2.0;
            mono.b = -avec[1] * 2.0;
            mono.c = cvec[2] / sinbeta;
            mono.alpha = 90.0;
            mono.gamma = 90.0;
            mono.beta = this.beta;
            mono.latticeSystem = "basecentered";
            return mono;
        }
        return null;
    }

    public String getCrystalSystem() {
        return "monoclinic";
    }
}

