/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.bond;

import ciss.phase_viewer.acviewer.scenegraphelements.CylinderCreatorTG;
import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditableBG;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import org.apache.log4j.Logger;

public class BondObject
extends DynamicallyEditableBG {
    private Logger logger = Logger.getLogger(BondObject.class.getName());
    public static int COVBOND = 0;
    public static int HBOND = 1;
    private int mode = COVBOND;
    private double[] nearestNeighbor;
    private float[] bondColor;
    private int numNodes = 30;
    private double bondWidth = 0.1;
    private CylinderCreatorTG cylindercreate;
    private BranchGroup bondBranch;
    private int index = 0;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private AtomObject atom1;
    private AtomObject atom2;
    private Point3d Cyl1Now;
    private Point3d Cyl2Now;
    private int cyl;
    private int linePattern;

    public BondObject(double[] nearestNeighbor) {
        this.nearestNeighbor = nearestNeighbor;
        this.bondBranch = new BranchGroup();
        this.bondBranch.setCapability(17);
    }

    public void setAssociatedAtoms(AtomObject atom1, AtomObject atom2) {
        this.atom1 = atom1;
        this.atom2 = atom2;
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (this.mode == HBOND) {
            try {
                String[] col = this.gp.getProperty("hbond_color").split(",");
                this.bondColor = new float[]{Float.parseFloat(col[0]), Float.parseFloat(col[1]), Float.parseFloat(col[2])};
                String width = this.gp.getProperty("hbond_width");
                this.bondWidth = Double.parseDouble(width) * (double)2.2f * (double)this.mACVD.getScaleAtom() / (double)((float)Math.pow(this.mCD.getNumAt(), 0.3333333432674408));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getType() {
        return 1;
    }

    public void create() {
        this.cyl = CylinderCreatorTG.CYLINDER;
        this.linePattern = 0;
        if (this.mode == COVBOND && this.mACVD.getUseWireForBond()) {
            this.cyl = CylinderCreatorTG.WIRE;
        }
        if (this.mode == HBOND) {
            this.cyl = CylinderCreatorTG.WIRE;
            if (this.gp.getProperty("hbond_type").equals("dashed")) {
                this.linePattern = 1;
            }
            if (this.gp.getProperty("hbond_type").equals("dotted")) {
                this.linePattern = 2;
            }
        }
        this.Cyl1Now = new Point3d(this.nearestNeighbor[0], this.nearestNeighbor[1], this.nearestNeighbor[2]);
        this.Cyl2Now = new Point3d(this.nearestNeighbor[3], this.nearestNeighbor[4], this.nearestNeighbor[5]);
        this.cylindercreate = new CylinderCreatorTG(this.Cyl1Now, this.Cyl2Now, this.bondWidth, new Color3f(this.bondColor), this.numNodes, this.cyl, this.linePattern);
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        group.addChild((Node)this.cylindercreate);
        this.addChild((Node)group);
    }

    public BondObject getCopy() {
        this.nullifyBuffer();
        if (this.atom1 == null || this.atom2 == null) {
            return null;
        }
        if (!this.atom1.isSelected() || !this.atom2.isSelected()) {
            return null;
        }
        double[] neib = new double[6];
        double[] d1 = this.atom1.getPosDouble();
        double[] d2 = this.atom2.getPosDouble();
        neib[0] = d1[0];
        neib[1] = d1[1];
        neib[2] = d1[2];
        neib[3] = d2[0];
        neib[4] = d2[1];
        neib[5] = d2[2];
        this.nearestNeighbor = neib;
        double[] nn = new double[this.nearestNeighbor.length];
        for (int i = 0; i < this.nearestNeighbor.length; ++i) {
            nn[i] = this.nearestNeighbor[i];
        }
        BondObject copy = new BondObject(nn);
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.bondColor));
        material.setShininess(120.0f);
        app.setMaterial(material);
        float transparency = 0.6f;
        try {
            transparency = Float.parseFloat(this.gp.getProperty("transparency_of_temporary_atom"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        TransparencyAttributes ta = new TransparencyAttributes(2, 0.0f);
        ta.setTransparency(transparency);
        app.setTransparencyAttributes(ta);
        Point3d Cyl1 = new Point3d(this.nearestNeighbor[0], this.nearestNeighbor[1], this.nearestNeighbor[2]);
        Point3d Cyl2 = new Point3d(this.nearestNeighbor[3], this.nearestNeighbor[4], this.nearestNeighbor[5]);
        this.transformBuffer = new CylinderCreatorTG(this.Cyl1Now, this.Cyl2Now, this.bondWidth, new Color3f(this.bondColor), this.numNodes, this.cyl, this.linePattern);
        copy.addChild((Node)this.transformBuffer);
        copy.setIndex(this.index);
        return copy;
    }

    protected boolean intermediateStateNecessary() {
        return this.buffer != null && this.transformBuffer != null;
    }

    public void recreate(double[] nearestNeighbor) {
        this.logger.debug("recreating bond");
        if (this.cylindercreate == null) {
            return;
        }
        Point3d Cyl1 = new Point3d(nearestNeighbor[0], nearestNeighbor[1], nearestNeighbor[2]);
        Point3d Cyl2 = new Point3d(nearestNeighbor[3], nearestNeighbor[4], nearestNeighbor[5]);
        if (this.mCD.forceUpdate()) {
            this.logger.debug("use wire for bond: " + this.mACVD.getUseWireForBond());
            if (this.mACVD.getUseWireForBond()) {
                this.cylindercreate.setMode(CylinderCreatorTG.WIRE);
            } else {
                this.cylindercreate.setMode(CylinderCreatorTG.CYLINDER);
            }
            this.cylindercreate.setRadius(this.mACVD.getBondWidth());
            this.cylindercreate.setColor(new Color3f(this.mACVD.getBondColor()));
        }
        this.cylindercreate.recreate(Cyl1, Cyl2, this.mCD.forceUpdate());
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setBondColor(float[] bondColor) {
        this.bondColor = bondColor;
    }

    public void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    public void setBondWidth(double bondWidth) {
        this.bondWidth = bondWidth;
    }

    public void createBuffer() {
        this.buffer = this.getCopy();
    }

    public void nullifyBuffer() {
        this.buffer = null;
        this.transformBuffer = null;
    }
}

