/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.bond;

import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondObject;

public class BondInfo
implements Comparable {
    private int atom1;
    private int atom2;
    private double[] coords;
    private boolean valid = false;
    private double crtdst;
    private BondObject bobject;
    private double length = -100.0;

    public BondInfo() {
    }

    public void nullify() {
        this.coords = null;
    }

    public BondInfo(int atom1, int atom2, double[] coords) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.coords = coords;
    }

    public void addBondInfo(int atom1, int atom2, double[] coords) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.coords = coords;
    }

    public void isValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int[] getIndexPair() {
        int[] ret = new int[]{this.atom1, this.atom2};
        return ret;
    }

    public void setIndexPair(int atom1, int atom2) {
        this.atom1 = atom1;
        this.atom2 = atom2;
    }

    public double[] getCoordinates() {
        return this.coords;
    }

    public void setCriticalDistanceSquared(double crtdst) {
        this.crtdst = crtdst;
    }

    public double getCriticalDistanceSquared() {
        return this.crtdst;
    }

    public void setBond(BondObject bobject) {
        this.bobject = bobject;
    }

    public BondObject getBond() {
        return this.bobject;
    }

    public void setBondLengthSquared(double length) {
        this.length = length;
    }

    public double getBondLength() {
        if (this.length > 0.0) {
            return Math.sqrt(this.length);
        }
        return Math.sqrt(Math.pow(this.coords[3] - this.coords[0], 2.0) + Math.pow(this.coords[4] - this.coords[1], 2.0) + Math.pow(this.coords[5] - this.coords[2], 2.0));
    }

    public boolean equals(BondInfo bondInfo) {
        int[] test2 = bondInfo.getIndexPair();
        return test2[0] == this.atom1 && test2[1] == this.atom2;
    }

    public int compareTo(Object o) {
        if (!(o instanceof BondInfo)) {
            throw new ClassCastException();
        }
        if (((BondInfo)o).length > this.length) {
            return -1;
        }
        if (((BondInfo)o).length == this.length) {
            return 0;
        }
        return 1;
    }
}

