/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.__builtin__;
import org.python.util.InteractiveInterpreter;

public class InteractiveConsole
extends InteractiveInterpreter {
    public String filename;

    public InteractiveConsole() {
        this(null, "<console>");
    }

    public InteractiveConsole(PyObject locals) {
        this(locals, "<console>");
    }

    public InteractiveConsole(PyObject locals, String filename) {
        super(locals);
        this.filename = filename;
    }

    public void interact() {
        this.interact(InteractiveConsole.getDefaultBanner());
    }

    public static String getDefaultBanner() {
        String compiler = System.getProperty("java.compiler");
        return "Jython " + PySystemState.version + " on " + PySystemState.platform + " (JIT: " + (compiler == null ? "null" : compiler) + ")";
    }

    public void interact(String banner) {
        if (banner != null) {
            this.write(banner);
            this.write("\n");
        }
        this.exec("2");
        boolean more = false;
        while (true) {
            String line;
            PyObject prompt = more ? this.systemState.ps2 : this.systemState.ps1;
            try {
                line = this.raw_input(prompt);
            }
            catch (PyException exc) {
                if (!Py.matchException(exc, Py.EOFError)) {
                    throw exc;
                }
                this.write("\n");
                break;
            }
            more = this.push(line);
        }
    }

    public boolean push(String line) {
        if (this.buffer.length() > 0) {
            this.buffer.append("\n");
        }
        this.buffer.append(line);
        boolean more = this.runsource(this.buffer.toString(), this.filename);
        if (!more) {
            this.resetbuffer();
        }
        return more;
    }

    public String raw_input(PyObject prompt) {
        return __builtin__.raw_input(prompt);
    }
}

