/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.TimeFunctions;

public class time
implements ClassDictInit {
    public static PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static double __initialclock__ = 0.0;
    protected static Locale currentLocale = null;
    protected static DateFormatSymbols datesyms = new DateFormatSymbols();
    protected static String[] shortdays = null;
    protected static String[] shortmonths = null;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        dict.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        TimeZone tz = TimeZone.getDefault();
        tzname = new PyTuple(new PyObject[]{new PyString(time.getDisplayName(tz, false, 0)), new PyString(time.getDisplayName(tz, true, 0))});
        daylight = tz.useDaylightTime() ? 1 : 0;
        timezone = -tz.getRawOffset() / 1000;
        altzone = timezone - time.getDSTSavings(tz) / 1000;
    }

    public static double time$() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock$() {
        if (__initialclock__ == 0.0) {
            __initialclock__ = time.time$();
        }
        return time.time$() - __initialclock__;
    }

    private static void throwValueError(String msg) {
        throw new PyException(Py.ValueError, new PyString(msg));
    }

    private static int item(PyTuple tup, int i) {
        int val = ((PyInteger)tup.__getitem__(i).__int__()).getValue();
        boolean valid = true;
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                valid = 1 <= val && val <= 12;
                break;
            }
            case 2: {
                valid = 1 <= val && val <= 31;
                break;
            }
            case 3: {
                valid = 0 <= val && val <= 23;
                break;
            }
            case 4: {
                valid = 0 <= val && val <= 59;
                break;
            }
            case 5: {
                valid = 0 <= val && val <= 59;
                break;
            }
            case 6: {
                valid = 0 <= val && val <= 6;
                break;
            }
            case 7: {
                valid = 1 <= val && val < 367;
                break;
            }
            case 8: {
                boolean bl = valid = -1 <= val && val <= 1;
            }
        }
        if (!valid) {
            String msg;
            switch (i) {
                case 1: {
                    msg = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    msg = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    msg = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    msg = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    msg = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    msg = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    msg = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    msg = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    msg = "ignore";
                }
            }
            time.throwValueError(msg);
        }
        if (i == 1) {
            --val;
        }
        return val;
    }

    private static GregorianCalendar _tupletocal(PyTuple tup) {
        return new GregorianCalendar(time.item(tup, 0), time.item(tup, 1), time.item(tup, 2), time.item(tup, 3), time.item(tup, 4), time.item(tup, 5));
    }

    public static double mktime(PyTuple tup) {
        GregorianCalendar cal;
        try {
            cal = time._tupletocal(tup);
        }
        catch (PyException e) {
            e.type = Py.OverflowError;
            throw e;
        }
        int dst = time.item(tup, 8);
        if (dst == 0 || dst == 1) {
            cal.set(16, dst * time.getDSTSavings(cal.getTimeZone()));
        }
        return (double)cal.getTime().getTime() / 1000.0;
    }

    protected static PyTuple _timefields(double secs, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.clear();
        cal.setTime(new Date((long)(secs * 1000.0)));
        int dow = cal.get(7) - 2;
        if (dow < 0) {
            dow += 7;
        }
        boolean isdst = tz.inDaylightTime(cal.getTime());
        return new PyTuple(new PyObject[]{new PyInteger(cal.get(1)), new PyInteger(cal.get(2) + 1), new PyInteger(cal.get(5)), new PyInteger(cal.get(10) + 12 * cal.get(9)), new PyInteger(cal.get(12)), new PyInteger(cal.get(13)), new PyInteger(dow), new PyInteger(cal.get(6)), new PyInteger(isdst ? 1 : 0)});
    }

    public static PyTuple localtime() {
        return time.localtime(time.time$());
    }

    public static PyTuple localtime(double secs) {
        return time._timefields(secs, TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return time.gmtime(time.time$());
    }

    public static PyTuple gmtime(double secs) {
        return time._timefields(secs, TimeZone.getTimeZone("GMT"));
    }

    public static String ctime() {
        return time.ctime(time.time$());
    }

    public static String ctime(double secs) {
        return time.asctime(time.localtime(secs));
    }

    private static String _shortday(int dow) {
        try {
            if (shortdays == null) {
                shortdays = new String[7];
                String[] names = datesyms.getShortWeekdays();
                for (int i = 0; i < 6; ++i) {
                    time.shortdays[i] = names[i + 2];
                }
                time.shortdays[6] = names[1];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            time.throwValueError("day of week out of range (0-6)");
        }
        return shortdays[dow];
    }

    private static String _shortmonth(int month0to11) {
        try {
            if (shortmonths == null) {
                shortmonths = new String[12];
                String[] names = datesyms.getShortMonths();
                for (int i = 0; i < 12; ++i) {
                    time.shortmonths[i] = names[i];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            time.throwValueError("month out of range (1-12)");
        }
        return shortmonths[month0to11];
    }

    private static String _padint(int i, int target) {
        String s = Integer.toString(i);
        int sz = s.length();
        if (target <= sz) {
            return s;
        }
        if (target == sz + 1) {
            return "0" + s;
        }
        if (target == sz + 2) {
            return "00" + s;
        }
        char[] c = new char[target - sz];
        while (target > sz) {
            c[target - sz] = 48;
            --target;
        }
        return new String(c) + s;
    }

    private static String _twodigit(int i) {
        return time._padint(i, 2);
    }

    private static String _truncyear(int year) {
        String yearstr = time._padint(year, 4);
        return yearstr.substring(yearstr.length() - 2, yearstr.length());
    }

    public static String asctime() {
        return time.asctime(time.localtime());
    }

    public static String asctime(PyTuple tup) {
        time.checkLocale();
        int day = time.item(tup, 6);
        int mon = time.item(tup, 1);
        return time._shortday(day) + " " + time._shortmonth(mon) + " " + time._twodigit(time.item(tup, 2)) + " " + time._twodigit(time.item(tup, 3)) + ":" + time._twodigit(time.item(tup, 4)) + ":" + time._twodigit(time.item(tup, 5)) + " " + time.item(tup, 0);
    }

    public static void sleep(double secs) {
        try {
            Thread.sleep((long)(secs * 1000.0));
        }
        catch (InterruptedException e) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static String strftime(String format) {
        return time.strftime(format, time.localtime());
    }

    public static String strftime(String format, PyTuple tup) {
        time.checkLocale();
        String s = "";
        int lastc = 0;
        GregorianCalendar cal = null;
        while (lastc < format.length()) {
            int i = format.indexOf("%", lastc);
            if (i < 0) {
                s = s + format.substring(lastc);
                break;
            }
            if (i == format.length() - 1) {
                s = s + "%";
                break;
            }
            s = s + format.substring(lastc, i);
            switch (format.charAt(++i)) {
                case 'a': {
                    int j = time.item(tup, 6);
                    s = s + time._shortday(j);
                    break;
                }
                case 'A': {
                    String[] syms = datesyms.getWeekdays();
                    int j = time.item(tup, 6);
                    if (0 <= j && j < 6) {
                        s = s + syms[j + 2];
                        break;
                    }
                    if (j == 6) {
                        s = s + syms[1];
                        break;
                    }
                    time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int j = time.item(tup, 1);
                    s = s + time._shortmonth(j);
                    break;
                }
                case 'B': {
                    String[] syms = datesyms.getMonths();
                    int j = time.item(tup, 1);
                    s = s + syms[j];
                    break;
                }
                case 'c': {
                    s = s + time.asctime(tup);
                    break;
                }
                case 'd': {
                    s = s + time._twodigit(time.item(tup, 2));
                    break;
                }
                case 'H': {
                    s = s + time._twodigit(time.item(tup, 3));
                    break;
                }
                case 'I': {
                    int j = time.item(tup, 3) % 12;
                    if (j == 0) {
                        j = 12;
                    }
                    s = s + time._twodigit(j);
                    break;
                }
                case 'j': {
                    s = time._padint(time.item(tup, 7), 3);
                    break;
                }
                case 'm': {
                    s = s + time._twodigit(time.item(tup, 1) + 1);
                    break;
                }
                case 'M': {
                    s = s + time._twodigit(time.item(tup, 4));
                    break;
                }
                case 'p': {
                    int j = time.item(tup, 3);
                    String[] syms = datesyms.getAmPmStrings();
                    if (0 <= j && j < 12) {
                        s = s + syms[0];
                        break;
                    }
                    if (12 <= j && j < 24) {
                        s = s + syms[1];
                        break;
                    }
                    time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    s = s + time._twodigit(time.item(tup, 5));
                    break;
                }
                case 'U': {
                    if (cal == null) {
                        cal = time._tupletocal(tup);
                    }
                    cal.setFirstDayOfWeek(1);
                    cal.setMinimalDaysInFirstWeek(7);
                    int j = cal.get(3);
                    if (cal.get(2) == 0 && j >= 52) {
                        j = 0;
                    }
                    s = s + time._twodigit(j);
                    break;
                }
                case 'w': {
                    int j = (time.item(tup, 6) + 1) % 7;
                    s = s + time._twodigit(j);
                    break;
                }
                case 'W': {
                    if (cal == null) {
                        cal = time._tupletocal(tup);
                    }
                    cal.setFirstDayOfWeek(2);
                    cal.setMinimalDaysInFirstWeek(7);
                    int j = cal.get(3);
                    if (cal.get(2) == 0 && j >= 52) {
                        j = 0;
                    }
                    s = s + time._twodigit(j);
                    break;
                }
                case 'x': {
                    s = s + time._twodigit(time.item(tup, 1) + 1) + "/" + time._twodigit(time.item(tup, 2)) + "/" + time._truncyear(time.item(tup, 0));
                    break;
                }
                case 'X': {
                    s = s + time._twodigit(time.item(tup, 3)) + ":" + time._twodigit(time.item(tup, 4)) + ":" + time._twodigit(time.item(tup, 5));
                    break;
                }
                case 'Y': {
                    s = s + time._padint(time.item(tup, 0), 4);
                    break;
                }
                case 'y': {
                    s = s + time._truncyear(time.item(tup, 0));
                    break;
                }
                case 'Z': {
                    if (cal == null) {
                        cal = time._tupletocal(tup);
                    }
                    s = s + time.getDisplayName(cal.getTimeZone(), time.item(tup, 8) > 0, 0);
                    break;
                }
                case '%': {
                    s = s + "%";
                    break;
                }
                default: {
                    s = s + "%" + format.charAt(i);
                    ++i;
                }
            }
            lastc = i + 1;
            ++i;
        }
        return s;
    }

    private static void checkLocale() {
        if (!Locale.getDefault().equals(currentLocale)) {
            currentLocale = Locale.getDefault();
            datesyms = new DateFormatSymbols(currentLocale);
            shortdays = null;
            shortmonths = null;
        }
    }

    private static String getDisplayName(TimeZone tz, boolean dst, int style) {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.2") >= 0) {
            try {
                Method m = tz.getClass().getMethod("getDisplayName", Boolean.TYPE, Integer.TYPE);
                return (String)m.invoke((Object)tz, new Boolean(dst), new Integer(style));
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return tz.getID();
    }

    private static int getDSTSavings(TimeZone tz) {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.2") >= 0) {
            try {
                Method m = tz.getClass().getMethod("getDSTSavings", null);
                return (Integer)m.invoke((Object)tz, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        altzone = -1;
        tzname = null;
    }
}

