/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.supercell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class SupercellCreater {
    private String inputFile = "input";
    private String outputFile = "output";
    private String PRIMITIVE = "primitive";
    private String BRAVAIS = "bravais";
    private int numAt = 0;
    private double[][] AtomicConfig = new double[1][3];
    private double[][] AtomicConfigLarge = new double[1][3];
    private double[][] cellVec = new double[3][3];
    private int[] magnify = new int[3];
    private int numAtLarge = 1;
    private double latticeConstant = 1.0;
    private String[] element = new String[1];
    private String[] elementLarge = new String[1];
    private String latticeSystem = this.PRIMITIVE;
    private String coordSystem = "cartesian";
    private String Symmetry = "bcc";

    public void SupercellCreater() {
    }

    public void SupercellCreater(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.readFromInputFile();
    }

    public void setFiles(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.readFromInputFile();
    }

    private void readFromInputFile() {
        int i;
        String readString = new String();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.inputFile));
            while ((readString = br.readLine()) != null) {
                StringTokenizer st;
                StringTokenizer st2;
                if ((readString = readString.trim()).startsWith("NumAt")) {
                    String num = br.readLine();
                    st2 = new StringTokenizer(num);
                    this.numAt = Integer.parseInt(st2.nextToken());
                }
                if (readString.startsWith("AtomicConfig")) {
                    this.AtomicConfig = new double[this.numAt][3];
                    this.element = new String[this.numAt];
                    for (int i2 = 0; i2 < this.numAt; ++i2) {
                        String ac = br.readLine();
                        st = new StringTokenizer(ac);
                        if (st.countTokens() == 3) {
                            this.element[i2] = "";
                        }
                        if (st.countTokens() > 3) {
                            this.element[i2] = st.nextToken();
                        }
                        this.AtomicConfig[i2][0] = Double.parseDouble(st.nextToken());
                        this.AtomicConfig[i2][1] = Double.parseDouble(st.nextToken());
                        this.AtomicConfig[i2][2] = Double.parseDouble(st.nextToken());
                    }
                }
                if (readString.startsWith("LatticeSystem")) {
                    this.latticeSystem = br.readLine();
                }
                if (readString.startsWith("CoordinateSystem")) {
                    this.coordSystem = br.readLine();
                }
                if (readString.startsWith("Symmetry")) {
                    this.Symmetry = br.readLine();
                }
                if (readString.startsWith("LatticeConstant")) {
                    String lattice = br.readLine();
                    this.latticeConstant = !this.coordSystem.equals("internal") ? Double.parseDouble(lattice) : 1.0;
                }
                if (readString.startsWith("CellVec")) {
                    for (int i3 = 0; i3 < 3; ++i3) {
                        String cell = br.readLine();
                        st = new StringTokenizer(cell);
                        this.cellVec[i3][0] = Double.parseDouble(st.nextToken());
                        this.cellVec[i3][1] = Double.parseDouble(st.nextToken());
                        this.cellVec[i3][2] = Double.parseDouble(st.nextToken());
                    }
                }
                if (!readString.startsWith("Magnify")) continue;
                String mag = br.readLine();
                st2 = new StringTokenizer(mag);
                for (int i4 = 0; i4 < 3; ++i4) {
                    this.magnify[i4] = Integer.parseInt(st2.nextToken());
                }
            }
        }
        catch (Exception exc) {
            System.out.println("failed read from input file");
            System.exit(0);
        }
        System.out.println("num. At: " + this.numAt);
        System.out.println("atomic configuration: ");
        for (i = 0; i < this.numAt; ++i) {
            System.out.println(this.AtomicConfig[i][0] + " " + this.AtomicConfig[i][1] + " " + this.AtomicConfig[i][2]);
        }
        System.out.println("cellvector: ");
        for (i = 0; i < 3; ++i) {
            System.out.println(this.cellVec[i][0] + " " + this.cellVec[i][1] + " " + this.cellVec[i][2]);
        }
        System.out.println("magnify:");
        for (i = 0; i < 3; ++i) {
            System.out.print(this.magnify[i] + " ");
        }
        System.out.println();
        System.out.println("lattice constant: " + this.latticeConstant);
    }

    public void run() {
        block17: {
            int j2;
            int i;
            int Nlarge;
            int ilarge;
            double[] trans3;
            double[] trans2;
            double[] trans1;
            block18: {
                double[] addvec = new double[3];
                trans1 = new double[3];
                trans2 = new double[3];
                trans3 = new double[3];
                this.numAtLarge = this.numAt * this.magnify[0] * this.magnify[1] * this.magnify[2];
                if (this.latticeSystem.equals("bravais")) {
                    if (this.Symmetry.equals("bcc")) {
                        this.numAtLarge *= 2;
                    } else if (this.Symmetry.equals("fcc")) {
                        this.numAtLarge *= 4;
                    }
                }
                this.AtomicConfigLarge = new double[this.numAtLarge][3];
                this.elementLarge = new String[this.numAtLarge];
                ilarge = 0;
                for (int ia = 0; ia < this.magnify[0]; ++ia) {
                    for (int ib = 0; ib < this.magnify[1]; ++ib) {
                        for (int ic = 0; ic < this.magnify[2]; ++ic) {
                            int i2;
                            for (i2 = 0; i2 < 3; ++i2) {
                                addvec[i2] = (double)ia * this.cellVec[0][i2] + (double)ib * this.cellVec[1][i2] + (double)ic * this.cellVec[2][i2];
                            }
                            for (i2 = 0; i2 < this.numAt; ++i2) {
                                for (int j3 = 0; j3 < 3; ++j3) {
                                    this.AtomicConfigLarge[ilarge][j3] = this.AtomicConfig[i2][j3] + addvec[j3] * this.latticeConstant;
                                }
                                this.elementLarge[ilarge] = this.element[i2];
                                ++ilarge;
                            }
                        }
                    }
                }
                Nlarge = ilarge;
                if (!this.latticeSystem.equals("bravais")) break block17;
                if (!this.Symmetry.equals("bcc")) break block18;
                for (i = 0; i < 3; ++i) {
                    trans1[i] = this.cellVec[i][i] * 0.5;
                }
                for (i = 0; i < Nlarge; ++i) {
                    for (j2 = 0; j2 < 3; ++j2) {
                        this.AtomicConfigLarge[ilarge][j2] = this.AtomicConfigLarge[i][j2] + trans1[j2] * this.latticeConstant;
                    }
                    this.elementLarge[ilarge] = this.elementLarge[i];
                    ++ilarge;
                }
                break block17;
            }
            if (!this.Symmetry.equals("fcc")) break block17;
            trans1[0] = this.cellVec[0][0] * 0.5;
            trans1[1] = this.cellVec[1][1] * 0.5;
            trans1[2] = 0.0;
            trans2[0] = this.cellVec[0][0] * 0.5;
            trans2[1] = 0.0;
            trans2[2] = this.cellVec[2][2] * 0.5;
            trans3[0] = 0.0;
            trans3[1] = this.cellVec[1][1] * 0.5;
            trans3[2] = this.cellVec[2][2] * 0.5;
            for (i = 0; i < Nlarge; ++i) {
                for (j2 = 0; j2 < 3; ++j2) {
                    this.AtomicConfigLarge[ilarge][j2] = this.AtomicConfigLarge[i][j2] + trans1[j2] * this.latticeConstant;
                }
                this.elementLarge[ilarge] = this.elementLarge[i];
                ++ilarge;
                for (j2 = 0; j2 < 3; ++j2) {
                    this.AtomicConfigLarge[ilarge][j2] = this.AtomicConfigLarge[i][j2] + trans2[j2] * this.latticeConstant;
                }
                this.elementLarge[ilarge] = this.elementLarge[i];
                ++ilarge;
                for (j2 = 0; j2 < 3; ++j2) {
                    this.AtomicConfigLarge[ilarge][j2] = this.AtomicConfigLarge[i][j2] + trans3[j2] * this.latticeConstant;
                }
                this.elementLarge[ilarge] = this.elementLarge[i];
                ++ilarge;
            }
        }
    }

    public void saveToFile() {
        try {
            PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
            this.writeTo(fout);
            fout.close();
        }
        catch (Exception exc) {
            System.out.println("failed write to: " + this.outputFile);
        }
    }

    private void writeTo(PrintWriter fout) {
        int i;
        DecimalFormat formater = new DecimalFormat("0.0000");
        fout.println("# cellvec");
        for (i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                this.cellVec[i][j2] = (double)this.magnify[i] * this.cellVec[i][j2] * this.latticeConstant;
            }
        }
        for (i = 0; i < 3; ++i) {
            fout.println(formater.format(this.cellVec[i][0]) + " " + formater.format(this.cellVec[i][1]) + " " + formater.format(this.cellVec[i][2]));
        }
        fout.println("# atomic configuration");
        for (i = 0; i < this.numAtLarge; ++i) {
            fout.println(this.elementLarge[i] + " " + formater.format(this.AtomicConfigLarge[i][0]) + " " + formater.format(this.AtomicConfigLarge[i][1]) + " " + formater.format(this.AtomicConfigLarge[i][2]));
        }
    }

    public static void main(String[] args) {
        String inpFile = "input";
        String outFile = "output";
        if (args.length > 0) {
            inpFile = args[0];
            if (args.length > 1) {
                outFile = args[1];
            }
        }
        if (!new File(inpFile).exists()) {
            System.out.println("no such file: " + inpFile);
        }
        SupercellCreater creater = new SupercellCreater();
        creater.setFiles(inpFile, outFile);
        creater.run();
        creater.saveToFile();
    }
}

