/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.logger;

import javax.swing.JTextArea;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class JTextAreaAppender
extends AppenderSkeleton {
    private static JTextArea textarea;
    private static JTextAreaAppender appender;

    public JTextAreaAppender() {
        textarea = new JTextArea(5, 30);
        textarea.setEditable(false);
        this.layout = new PatternLayout("%-5p %6.10r[%t]%x(%F:%L) - %m%n");
    }

    protected void append(LoggingEvent event) {
        textarea.append(this.layout.format(event));
        textarea.setCaretPosition(textarea.getDocument().getLength());
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.layout != null) {
            textarea.append(this.layout.getFooter());
        }
    }

    public static JTextAreaAppender getAppender() {
        if (appender == null) {
            appender = new JTextAreaAppender();
        }
        return appender;
    }

    public static JTextArea getTextArea() {
        if (textarea == null) {
            textarea = new JTextArea(5, 30);
            textarea.setEditable(false);
        }
        return textarea;
    }
}

