/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.io.File;
import javax.swing.JFileChooser;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class ChaseFileChooser
extends JFileChooser {
    private Logger logger = Logger.getLogger(ChaseFileChooser.class.getName());
    public static final String base = "base";
    public static final String graph = "graph";
    public static final String pp = "pp";
    public static final String atom = "atom";
    public static final String media = "media";
    public static final String log = "log";
    public static final String path = "path";
    private String type;
    private static GlobalProperties mrud = PropertiesManager.getGlobalProperties(5);

    public ChaseFileChooser() {
        this.type = base;
        String initDir = mrud.getProperty(this.type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public ChaseFileChooser(String type) {
        this.type = type;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String parent = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
        mrud.setProperty(this.type, parent);
        mrud.storeProperty();
        return file;
    }

    public File[] getSelectedFiles() {
        File[] file = super.getSelectedFiles();
        if (file == null) {
            return null;
        }
        String parent = file[0].getParent();
        if (file[0].isDirectory()) {
            parent = file[0].getAbsolutePath();
        }
        mrud.setProperty(this.type, parent);
        mrud.storeProperty();
        return file;
    }
}

