/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.mouselistener;

import java.awt.event.MouseEvent;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.measure.Measurable;
import jp.advancesoft.chase.acviewer.measure.NullMeasure;
import jp.advancesoft.chase.acviewer.mouselistener.MouseMotionListenerAction;
import jp.advancesoft.chase.acviewer.scenegraphelements.Atom;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import org.apache.log4j.Logger;

public class LeftClickAction
extends MouseMotionListenerAction {
    private Logger logger = Logger.getLogger(LeftClickAction.class.getName());
    private boolean dragCalled = false;
    private float initx;
    private float inity;
    private Point3d initPoint;

    public LeftClickAction(MainPanel parent) {
        super(parent);
    }

    void finalize(MouseEvent e) {
        if (!this.dragCalled) {
            return;
        }
        this.parent.finalizeRectangle();
        Point3d finalPoint = LeftClickAction.getCoordsFromMousePos(this.parent, e);
        this.initPoint.z = 10.0;
        finalPoint.z = -10.0;
        BoundingBox bounds = new BoundingBox(this.initPoint, finalPoint);
        this.logger.debug("bounds: " + bounds);
        TransformGroup tg = this.parent.getScene().getTGAtom();
        boolean regedNullMeasure = false;
        for (int i = 0; i < tg.numChildren(); ++i) {
            Node object = tg.getChild(i);
            if (!(object instanceof AtomObject)) continue;
            AtomObject aobj = (AtomObject)object;
            Atom atom = aobj.getAtom();
            BoundingSphere abound = aobj.getTransformedBounds();
            if (!this.check(this.initPoint, finalPoint, abound)) continue;
            if (!regedNullMeasure) {
                ((TGAtom)this.parent.getScene().getTGAtom()).registerMeasure(new NullMeasure((Measurable)this.parent.getScene().getTGAtom()));
                regedNullMeasure = true;
            }
            this.logger.debug("caught atom: " + aobj);
            aobj.toggleSelected();
        }
        this.initx = 0.0f;
        this.inity = 0.0f;
        ((TGAtom)this.parent.getScene().getTGAtom()).setRotationEnabled(true);
        this.dragCalled = false;
    }

    private boolean check(Point3d point1, Point3d point2, BoundingSphere sphere) {
        double tmp;
        double x1 = point1.x;
        double y1 = point1.y;
        double x2 = point2.x;
        double y2 = point2.y;
        if (x1 > x2) {
            tmp = 0.0;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = 0.0;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        Point3d center = new Point3d();
        sphere.getCenter(center);
        double radius = sphere.getRadius();
        double x3 = center.x - radius;
        double y3 = -center.y - radius;
        double x4 = center.x + radius;
        double y4 = -center.y + radius;
        return x1 < x4 && x3 < x2 && y1 < y4 && y3 < y2;
    }

    void init(MouseEvent e) {
        this.initPoint = LeftClickAction.getCoordsFromMousePosPlat(this.parent, e);
        this.initx = (float)this.initPoint.x * 0.25f;
        this.inity = -((float)this.initPoint.y) * 0.25f;
        this.parent.initializeRectangle(this.initx, this.inity);
    }

    void processMouseDrag(MouseEvent e) {
        ((TGAtom)this.parent.getScene().getTGAtom()).setRotationEnabled(false);
        Point3d point = LeftClickAction.getCoordsFromMousePosPlat(this.parent, e);
        float floatx = (float)point.x * 0.25f - this.initx;
        float floaty = -((float)point.y) * 0.25f - this.inity;
        this.parent.updateRectangle(floatx, floaty);
        this.logger.debug("coordinate: " + point.x + ", " + point.y);
        this.dragCalled = true;
    }

    void processMouseMove(MouseEvent e) {
    }
}

