/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.pmodel;

import jp.advancesoft.pmodel.PmodelException;

public class Pmodel {
    static final int MAX_ATOM = 1000;
    static final double EPS = 1.0E-12;
    private int nSPG;
    private int choice;
    private String HM;
    private double[] cellAngle = new double[3];
    private double[] cellLength = new double[3];
    private double[][] cellMatrix = new double[3][3];
    private int numAtom = 0;
    private int numAtomOnBoundary = 0;
    private String[] symbol = new String[1000];
    private double[][] position = new double[1000][3];

    private native void readCIF(String var1, int[] var2, int[] var3, int[] var4, double[] var5, double[] var6, String[] var7, double[] var8);

    private native void makeLatticeC(int var1, int var2, int[] var3, String var4, String[] var5, double[] var6, double[] var7);

    public static void main(String[] args) throws PmodelException {
        String[] cpSymbol;
        int totalAtom;
        double[][] exPos;
        int i;
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: java Pmodel CIF_file_name [command]");
            System.out.println("command: 0  Debug Print [default]");
            System.out.println("       : 1  Cartesian(External) Coordinate");
            System.out.println("       : 2  Add Boundary Atoms");
            System.exit(1);
        }
        Pmodel crystal = new Pmodel();
        String fileName = args[0];
        System.out.println("CIF file name: " + fileName);
        crystal.makeLattice(fileName);
        int command = args.length == 1 ? 0 : Integer.parseInt(args[1]);
        if (command == 0) {
            System.out.println("Space Group Number: " + crystal.nSPG);
            System.out.println("Choice :" + crystal.choice);
            System.out.println("Cell Length:");
            for (i = 0; i < 3; ++i) {
                System.out.println(crystal.cellLength[i]);
            }
            System.out.println("Cell Angle:");
            for (i = 0; i < 3; ++i) {
                System.out.println(crystal.cellAngle[i]);
            }
            System.out.println("Cell Vector:");
            double[][] cellVec = crystal.getCellVec();
            for (i = 0; i < 3; ++i) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    System.out.println(cellVec[i][j2]);
                }
            }
        }
        int cpNumAtom = crystal.getNumberOfAtoms();
        System.out.println("Number of Atoms: " + cpNumAtom);
        if (command != 2) {
            System.out.println("External Position:");
            exPos = crystal.getCartesianPosition();
            totalAtom = crystal.numAtom;
            cpSymbol = crystal.getSymbol(0);
        } else {
            System.out.println("External Position with Boundary Atoms:");
            crystal.addBoundary();
            System.out.println(crystal.numAtomOnBoundary);
            exPos = crystal.getCartesianPosition(1);
            totalAtom = crystal.numAtom + crystal.numAtomOnBoundary;
            cpSymbol = crystal.getSymbol(1);
        }
        System.out.println("Internal Position:");
        for (i = 0; i < cpNumAtom; ++i) {
            System.out.println(cpSymbol[i] + " " + crystal.position[i][0] + " " + crystal.position[i][1] + " " + crystal.position[i][2]);
        }
        for (i = 0; i < totalAtom; ++i) {
            System.out.println(cpSymbol[i] + " " + exPos[i][0] + " " + exPos[i][1] + " " + exPos[i][2]);
        }
    }

    public void makeLattice(String fileName) throws PmodelException {
        double temp;
        int j2;
        int i;
        int[] noa = new int[1];
        int[] nn = new int[1];
        int[] nc = new int[1];
        String[] symbol = new String[1000];
        double[] position = new double[1000];
        this.readCIF(fileName, noa, nn, nc, this.cellLength, this.cellAngle, symbol, position);
        this.nSPG = nn[0];
        this.choice = nc[0];
        if (this.nSPG == 0) {
            PmodelException ex = new PmodelException();
            throw ex;
        }
        double alpha = this.cellAngle[0] * Math.PI / 180.0;
        double beta = this.cellAngle[1] * Math.PI / 180.0;
        double gamma = this.cellAngle[2] * Math.PI / 180.0;
        for (i = 0; i < 3; ++i) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.cellMatrix[i][j2] = 0.0;
            }
        }
        this.cellMatrix[0][0] = 1.0;
        this.cellMatrix[0][1] = Math.cos(gamma);
        this.cellMatrix[0][2] = Math.cos(beta);
        this.cellMatrix[1][1] = Math.sin(gamma);
        this.cellMatrix[1][2] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
        this.cellMatrix[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
        for (i = 0; i < 3; ++i) {
            for (j2 = 0; j2 < 3; ++j2) {
                double[] dArray = this.cellMatrix[i];
                int n = j2;
                dArray[n] = dArray[n] * this.cellLength[j2];
            }
        }
        this.makeLatticeC(this.nSPG, this.choice, noa, this.HM, symbol, this.cellLength, position);
        this.numAtom = noa[0];
        for (i = 0; i < this.numAtom; ++i) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.position[i][j2] = position[i * 3 + j2];
            }
        }
        for (i = 0; i < this.numAtom; ++i) {
            this.symbol[i] = symbol[i];
        }
    }

    public double[] getCellAngle() {
        double[] angle = new double[3];
        for (int i = 0; i < 3; ++i) {
            angle[i] = this.cellAngle[i];
        }
        return angle;
    }

    public double getCellAngle(int n) {
        return this.cellAngle[n];
    }

    public double[] getCellLength() {
        double[] length = new double[3];
        for (int i = 0; i < 3; ++i) {
            length[i] = this.cellLength[i];
        }
        return length;
    }

    public double getCellLength(int n) {
        return this.cellLength[n];
    }

    public int getNumberOfAtoms() {
        return this.numAtom;
    }

    public String[] getSymbol() {
        return this.getSymbol(0);
    }

    public String[] getSymbol(int command) {
        int totalAtom = command != 1 ? this.numAtom : this.numAtom + this.numAtomOnBoundary;
        String[] symbol = new String[totalAtom];
        for (int i = 0; i < totalAtom; ++i) {
            symbol[i] = this.symbol[i];
        }
        return symbol;
    }

    public double[][] getInternalPosition() {
        double[][] pos = new double[this.numAtom][3];
        for (int i = 0; i < this.numAtom; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                pos[i][j2] = this.position[i][j2];
            }
        }
        return pos;
    }

    public double[][] getExternalPosition() {
        return this.getCartesianPosition();
    }

    public double[][] getCartesianPosition() {
        return this.getCartesianPosition(0);
    }

    public double[][] getCartesianPosition(int command) {
        int i;
        int n;
        int totalAtom = command == 1 ? this.numAtom + this.numAtomOnBoundary : this.numAtom;
        double[][] pos = new double[totalAtom][3];
        for (n = 0; n < totalAtom; ++n) {
            for (i = 0; i < 3; ++i) {
                pos[n][i] = 0.0;
                for (int j2 = 0; j2 < 3; ++j2) {
                    double[] dArray = pos[n];
                    int n2 = i;
                    dArray[n2] = dArray[n2] + this.cellMatrix[i][j2] * this.position[n][j2];
                }
            }
        }
        for (n = 0; n < totalAtom; ++n) {
            for (i = 0; i < 3; ++i) {
                if (!(Math.abs(pos[n][i]) < 1.0E-12)) continue;
                pos[n][i] = 0.0;
            }
        }
        return pos;
    }

    public double[][] getCellVec() {
        double[][] cellVec = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j2 = 0; j2 < 3; ++j2) {
                cellVec[i][j2] = this.cellMatrix[j2][i];
                if (!(Math.abs(cellVec[i][j2]) < 1.0E-12)) continue;
                cellVec[i][j2] = 0.0;
            }
        }
        return cellVec;
    }

    private void addBoundary() {
        int k;
        int j2;
        int i;
        this.numAtomOnBoundary = 0;
        for (i = 0; i < this.numAtom; ++i) {
            for (j2 = 0; j2 < 3; ++j2) {
                if (!(this.position[i][j2] * this.cellLength[j2] < 1.0E-12)) continue;
                int temp = this.numAtom + this.numAtomOnBoundary;
                ++this.numAtomOnBoundary;
                for (k = 0; k < 3; ++k) {
                    this.position[temp][k] = this.position[i][k];
                }
                this.position[temp][j2] = 1.0;
                this.symbol[temp] = this.symbol[i];
            }
        }
        boolean newAtomAdded = false;
        while (newAtomAdded) {
            newAtomAdded = false;
            for (i = 0; i < this.numAtomOnBoundary; ++i) {
                for (j2 = 0; j2 < 3; ++j2) {
                    if (!(this.position[this.numAtom + i][j2] * this.cellLength[j2] < 1.0E-12)) continue;
                    for (k = 0; k < 3; ++k) {
                        this.position[this.numAtom + this.numAtomOnBoundary][k] = this.position[this.numAtom + i][k];
                    }
                    this.position[this.numAtom + this.numAtomOnBoundary][j2] = 1.0;
                    ++this.numAtomOnBoundary;
                    newAtomAdded = true;
                    System.out.println("hoge: " + this.numAtomOnBoundary);
                }
            }
        }
    }

    private void makeSuperCell() {
    }

    private void cutShapeRotate() {
    }

    private void upsideDown() {
    }

    private void makeVacumeLayer() {
    }

    static {
        System.loadLibrary("ChasePmodel");
    }
}

