/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.settings;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class PropertyManager {
    public static final int PROPERTY_CHASE = 0;
    public static final int PROPERTY_ACV = 1;
    public static final int PROPERTY_PROJ = 2;
    public static final int PROPERTY_SIZE = 3;
    public static final int PROPERTY_ELEMINFO = 4;
    public static final int PROPERTY_SETTING_FILES = 5;
    public static final int NORMAL = 0;
    public static final int ERR = 1;
    private final String FS = System.getProperty("file.separator");
    private final String homeDir = System.getProperty("user.home");
    private final String instDir = System.getProperty("chase.home");
    private final String fileSystem = "chase.ini";
    private final String fileAcv = "acvconfig";
    private final String fileProj = "chase.par";
    private final String fileElementInfo = "elementinfo";
    private final String fileSize = "sizeinfo";
    private final String fileFile = "files";
    private String chaseHomeDir = this.homeDir + this.FS + ".chase";
    private String propertyFile = new String();
    private String projdir = new String();
    private int propertyType;
    private Properties prop = new Properties();
    private Properties propChaseInstall = new Properties();

    public PropertyManager(int propertyType) {
        this.propertyType = propertyType;
        this.loadChaseInstallPropertyFile();
        if (propertyType == 0) {
            this.propertyFile = this.chaseHomeDir + this.FS + this.propChaseInstall.getProperty("chaseini");
            this.loadPropertyFile();
        } else if (propertyType == 1) {
            this.propertyFile = this.chaseHomeDir + this.FS + this.propChaseInstall.getProperty("acvconfig");
            this.loadPropertyFile();
        } else if (propertyType == 2) {
            this.propertyFile = this.projdir + "chase.par";
        } else if (propertyType == 3) {
            this.propertyFile = this.chaseHomeDir + this.FS + this.propChaseInstall.getProperty("sizeinfo");
            this.loadPropertyFile();
        } else if (propertyType == 4) {
            this.propertyFile = this.chaseHomeDir + this.FS + this.propChaseInstall.getProperty("elementinfo");
        } else if (propertyType == 5) {
            this.propertyFile = this.instDir + this.FS + "install" + this.FS + "install_files" + this.FS + "files";
            this.loadPropertyFile();
        } else {
            System.out.println("invalid propertyType!");
        }
    }

    public PropertyManager() {
    }

    public void setPropertyType(int propertyType) {
        this.propertyType = propertyType;
    }

    public String getFileName() {
        return this.propertyFile;
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public int storeProperty() {
        try {
            this.prop.store(new FileOutputStream(this.propertyFile), "last modification:");
        }
        catch (Exception e) {
            return 1;
        }
        return 0;
    }

    public void setProjDir(String projdir) {
        this.projdir = projdir;
        if (this.propertyType == 2) {
            this.propertyFile = projdir + "chase.par";
        } else {
            System.out.println("wrong property type!");
        }
        this.loadPropertyFile();
    }

    public Properties getProp() {
        return this.prop;
    }

    private void loadPropertyFile() {
        try {
            this.prop = new Properties();
            this.prop.load(new FileInputStream(this.propertyFile));
        }
        catch (Exception e) {
            System.out.println("failed to load property file " + this.propertyFile);
        }
    }

    private void loadChaseInstallPropertyFile() {
        String string = this.instDir + this.FS + "install" + this.FS + "install_files" + this.FS + "files";
        try {
            this.propChaseInstall = new Properties();
            this.propChaseInstall.load(new FileInputStream(string));
        }
        catch (Exception e) {
            System.out.println("failed to load property file " + string);
        }
    }
}

