/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import jp.advancesoft.chase.projectbrowser.ProjectManipulatorSubSelector;
import org.apache.log4j.Logger;

class SubSelectorButton
extends JButton
implements ActionListener {
    private Logger logger = Logger.getLogger(SubSelectorButton.class.getName());
    private String loadClass;
    private ProjectInfo info;
    private JSplitPane splitpane;
    private ProjectManipulatorSubSelector subSelector;

    protected SubSelectorButton(String name, String iconpath, String description, String loadClass, ProjectInfo info, JSplitPane splitpane, ProjectManipulatorSubSelector subSelector) {
        super(name);
        this.info = info;
        this.loadClass = loadClass;
        this.splitpane = splitpane;
        this.subSelector = subSelector;
        if (iconpath != null && iconpath.length() != 0 && !iconpath.equals("null")) {
            PluginLoader loader = new PluginLoader();
            URL res = null;
            try {
                res = loader.getResource(iconpath);
                super.setIcon(new ImageIcon(res));
            }
            catch (Exception ex) {
                this.logger.error("failed to resolve icon path.");
            }
        }
        if (description != null && description.length() != 0) {
            super.setToolTipText(description);
        }
        super.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.bootProjectManipulatorSub();
    }

    protected void bootProjectManipulatorSub() {
        this.logger.debug("loadClass: " + this.loadClass);
        PluginLoader loader = new PluginLoader();
        ProjectManipulator manip = null;
        try {
            Class<?> cla = loader.loadClass(this.loadClass);
            manip = this.subSelector.getProjectManipulator(cla.getName());
            if (manip == null) {
                Constructor<?>[] constructor = cla.getDeclaredConstructors();
                manip = (ProjectManipulator)constructor[0].newInstance(this.info);
                manip.init();
                this.subSelector.registerProjectManipulators(manip);
                this.logger.debug("loaded class: " + cla.getName());
            }
            boolean post = true;
            try {
                Vector manips = this.subSelector.getProjectManipulators();
                for (int i = 0; i < manips.size(); ++i) {
                    if (((ProjectManipulator)manips.elementAt(i)).postProcess()) continue;
                    post = false;
                }
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            if (post) {
                if (this.subSelector.getLayoutPolicy() == 0) {
                    this.splitpane.setRightComponent(manip);
                } else {
                    this.splitpane.setBottomComponent(manip);
                }
            } else {
                this.logger.info("operation canceled.");
            }
        }
        catch (Exception ex) {
            this.logger.error("failed to load class: " + this.loadClass + " ... contact AdvanceSoft.");
            ex.printStackTrace();
        }
    }
}

