/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.io.File;
import java.util.StringTokenizer;
import jp.advancesoft.chase.common.LineEditor;
import jp.advancesoft.chase.phase.FileParserEkCal;

class EkCalChecker
extends FileParserEkCal {
    public static final int CHECK_INFILE = 0;
    public static final int CHECK_FNAMES = 1;
    public static final int DOS = 2;
    public static final int BAND = 3;
    private final String LS = System.getProperty("line.separator");
    private final String infile = "INFILE: " + this.LS;
    private final String fnames = "FNAMES: " + this.LS;
    private String result = "no details";
    private int checkMode = 0;
    private int calMode = 2;
    private LineEditor lineeditor;

    public EkCalChecker(String fileName) {
        super(fileName);
    }

    public void initializeLineEditor() {
        this.lineeditor = new LineEditor(super.getString());
    }

    public void setCheckMode(int checkMode) {
        this.checkMode = checkMode;
    }

    public void setCalMode(int calMode) {
        this.calMode = calMode;
    }

    public boolean checkAndModify() {
        boolean bres = true;
        if (this.checkMode == 0) {
            this.result = this.infile;
            this.addResString("");
            this.addResString("checking control tag ...");
            int icontroltag = this.lineeditor.findIgnoreCase("control");
            boolean bcond = true;
            if (icontroltag == -1) {
                this.addResString("could not find control tag");
                bcond = false;
            } else {
                int icondtag = this.lineeditor.findIgnoreCase(icontroltag, "condition");
                if (icondtag == -1) {
                    this.addResString("could not find control tag");
                    bcond = false;
                } else {
                    String condition = this.lineeditor.getLine(icondtag);
                    StringTokenizer st = new StringTokenizer(condition, "=");
                    if (st.countTokens() < 2) {
                        this.addResString("invalid tag syntax");
                        bcond = false;
                    } else {
                        st.nextToken();
                        String value = st.nextToken().toLowerCase().trim();
                        if (!(value.startsWith("fixed_charge") || value.startsWith("fixed_charge_continuation") || value.startsWith("2") || value.startsWith("3"))) {
                            this.addResString("'condition' tag must be either");
                            this.addResString("'fixed_charge' or 'fixed_charge_continuation'");
                            bcond = false;
                        }
                    }
                }
            }
            if (bcond) {
                this.addResString("valid 'control' tag");
            }
            this.addResString("");
            bres = bcond && bres;
            this.addResString("checking ek_convergence tag ...");
            int iekconvtag = this.lineeditor.findIgnoreCase("ek_convergence");
            if (iekconvtag == -1) {
                this.addResString("ek_convergence tag not found ... ");
                this.addResString("default values will be used");
                this.addResString("");
            } else {
                this.addResString("found ek_convergence");
                this.addResString("");
            }
            if (this.calMode == 2) {
                this.addResString("checking DOS tag ...");
                int iposttag = this.lineeditor.findIgnoreCase("postprocessing");
                boolean bdos = true;
                if (iposttag == -1) {
                    this.addResString("could not find 'Postprocessing' tag");
                    bdos = false;
                } else {
                    int idostag = this.lineeditor.findIgnoreCase(iposttag, "dos");
                    if (idostag == -1) {
                        this.addResString("could not find 'dos' tag");
                        bdos = false;
                    } else {
                        int iswdostag = this.lineeditor.findIgnoreCase(idostag, "sw_dos");
                        if (iswdostag == -1) {
                            this.addResString("could not find 'sw_dos' tag");
                            bdos = false;
                        } else {
                            String dos = this.lineeditor.getLine(iswdostag);
                            StringTokenizer st = new StringTokenizer(dos, "=");
                            if (st.countTokens() < 2) {
                                this.addResString("tag syntax");
                                bdos = false;
                            } else {
                                st.nextToken();
                                String value = st.nextToken().toLowerCase().trim();
                                if (!value.startsWith("on") && !value.startsWith("1")) {
                                    this.addResString("'dos' tag must be 'on'");
                                    bdos = false;
                                }
                            }
                        }
                    }
                }
                if (bdos) {
                    this.addResString("valid 'dos' tag");
                }
                bres = bdos && bres;
                this.addResString("");
            } else if (this.calMode == 3) {
                this.addResString("checking 'num_bands' tag ... ");
                int inumbandtag = this.lineeditor.findIgnoreCase("num_bands");
                boolean bnumbands = true;
                int intNumBands = 0;
                int intSubSpace = 0;
                if (inumbandtag == -1) {
                    this.addResString("could not find 'num_bands' tag");
                    bnumbands = false;
                } else {
                    String numBands = this.lineeditor.getLine(inumbandtag);
                    StringTokenizer st = new StringTokenizer(numBands, "=");
                    if (st.countTokens() < 2) {
                        this.addResString("invalid tag syntax");
                        bnumbands = false;
                    } else {
                        st.nextToken();
                        String valueNumBands = st.nextToken().toLowerCase().trim();
                        try {
                            intNumBands = Integer.parseInt(valueNumBands);
                        }
                        catch (NumberFormatException nfe) {
                            this.addResString("invalid value for num_band");
                            bnumbands = false;
                        }
                    }
                }
                int isubspace = this.lineeditor.findIgnoreCase("subspace_matrix_size");
                if (isubspace != -1) {
                    String subSpace = this.lineeditor.getLine(isubspace);
                    StringTokenizer st = new StringTokenizer(subSpace, "=");
                    if (st.countTokens() < 2) {
                        this.addResString("invalid tag syntax");
                        bnumbands = false;
                    } else {
                        st.nextToken();
                        String valueSubSpace = st.nextToken().toLowerCase().trim();
                        try {
                            intSubSpace = Integer.parseInt(valueSubSpace);
                        }
                        catch (NumberFormatException nfe) {
                            this.addResString("invalid value for sub_matrix_size");
                            bnumbands = false;
                        }
                        if (intNumBands != intSubSpace) {
                            this.addResString("num_bands must be equal to subspace_matrix_size");
                            this.addResString("in the case of band calculation");
                            bnumbands = false;
                        }
                    }
                }
                if (bnumbands) {
                    this.addResString("valid num_bands");
                }
                bres = bres && bnumbands;
                this.addResString("");
                this.addResString("checking k-sampling method ...");
                int iksamp = this.lineeditor.findIgnoreCase("accuracy");
                boolean bksamp = true;
                if (iksamp == -1) {
                    this.addResString("could not find 'accuracy' tag");
                    bksamp = false;
                } else {
                    int imethod = this.lineeditor.findIgnoreCase(iksamp, "method");
                    if (imethod == -1) {
                        this.addResString("could not find 'method' tag");
                        bksamp = false;
                    } else {
                        String kSamp = this.lineeditor.getLine(imethod);
                        StringTokenizer st = new StringTokenizer(kSamp, "=");
                        if (st.countTokens() < 2) {
                            this.addResString("invalid tag syntax");
                            bksamp = false;
                        } else {
                            st.nextToken();
                            String value = st.nextToken().toLowerCase().trim();
                            if (!value.equals("file")) {
                                this.addResString("k-sampling method must be 'file' ");
                                this.addResString("in the case of band calculation");
                                bksamp = false;
                            }
                        }
                    }
                }
                if (bksamp) {
                    this.addResString("valid k-sampling method");
                }
                bres = bres && bksamp;
                this.addResString("");
            }
        } else if (this.checkMode == 1) {
            this.result = this.fnames;
            this.addResString("");
            int ppcount = 1;
            boolean bchgt = false;
            boolean bpot = false;
            boolean bkpoint = this.calMode != 3;
            for (int i = 0; i < this.lineeditor.getNumLines(); ++i) {
                StringTokenizer st = new StringTokenizer(this.lineeditor.getLine(i), "=");
                if (st.countTokens() < 2) continue;
                String ident = st.nextToken().trim();
                String value = st.nextToken().trim();
                char[] cvalue = new char[value.length()];
                cvalue = value.trim().toCharArray();
                value = String.copyValueOf(cvalue, 1, value.length() - 2);
                System.out.println(ident + ": " + value);
                if (ident.startsWith("F_CHGT")) {
                    this.addResString("checking F_CHGT ...");
                    bchgt = true;
                    bres = this.checkFile("F_CHGT", value) && bres;
                    this.addResString("");
                }
                if (ident.startsWith("F_POT")) {
                    this.addResString("checking PP-file no." + ppcount + " ... ");
                    bpot = true;
                    ++ppcount;
                    bres = this.checkFile("PP-file", value) && bres;
                    this.addResString("");
                }
                if (this.calMode != 3 || !ident.startsWith("F_KPOINT")) continue;
                this.addResString("checking F_KPOINT ...");
                bkpoint = true;
                bres = this.checkFile("F_KPOINT", value) && bres;
                this.addResString("");
            }
            if (!bchgt) {
                this.addResString("no F_CHGT tag in file_names.data");
                this.addResString("");
                bres = false;
            }
            if (!bpot) {
                this.addResString("no F_POT tag in file_names.data");
                this.addResString("");
                bres = false;
            }
            if (!bkpoint && this.calMode == 3) {
                this.addResString("no F_KPOINT tag in file_names.data");
                this.addResString("");
                bres = false;
            }
        }
        return bres;
    }

    private boolean checkFile(String key, String value) {
        File file = new File(value);
        if (!file.isAbsolute()) {
            file = new File(new File(this.fileName).getParent() + System.getProperty("file.separator") + value);
        }
        boolean bres = true;
        if (!file.exists()) {
            this.addResString("file " + value + " does not exist");
            bres = false;
        } else if (file.length() == 0L) {
            this.addResString("file " + value + " seems to be empty");
            bres = false;
        } else if (!file.isFile()) {
            this.addResString("file " + value + " is not a normal file");
            bres = false;
        } else {
            this.addResString("found " + key + ": " + value);
        }
        return bres;
    }

    private void addResString(String str) {
        this.result = this.result + str + this.LS;
    }

    public String getResult() {
        this.result = this.result + this.LS;
        return this.result;
    }
}

