/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.OutputParser;
import jp.advancesoft.chase.mainpanel.Desktop;

public class NfenergyParser
extends OutputParser {
    private int numColumns;
    private int numRows;
    private int numEig = 0;
    private int numBands = 0;
    private int nspin = 1;
    private final String UP = "UP";
    private final String DOWN = "DOWN";
    private String updown = "UP";
    private int numKpoints = 0;
    private final int numKdata = 5;
    private boolean isColumnNameSet = false;
    private Vector colNametmp = new Vector();
    private Vector kinfo = new Vector();
    private Vector eigUp = new Vector();
    private Vector eigDown = new Vector();
    private double dk = 0.0;
    private double dkp = 0.0;
    private double dkxp = 0.0;
    private double dkyp = 0.0;
    private double dkzp = 0.0;
    private double korigin = 0.0;
    private boolean iskoriginSet = false;
    private double[][] bvec = new double[3][3];
    private boolean calrk = false;
    private String projdir = new String();
    private String FS = System.getProperty("file.separator");
    private String defaultkinPath = System.getProperty("user.home") + this.FS + ".chase" + this.FS + "templates" + this.FS + "kpoints";

    public NfenergyParser(String filename) {
        super(filename);
        this.colNametmp.addElement("ik");
        this.colNametmp.addElement("kx");
        this.colNametmp.addElement("ky");
        this.colNametmp.addElement("kz");
        File file = new File(filename);
        this.projdir = file.getParent();
        file = new File(this.projdir + System.getProperty("file.separator") + "bandkpoint.in");
        if (file.exists()) {
            this.readBandKpointIn(file);
        } else {
            this.askForBandKpointIn();
        }
        this.colNametmp.addElement("|k|");
    }

    private void readBandKpointIn(File file) {
        String readString = new String();
        this.calrk = true;
        try {
            System.out.println("reading " + file + " ...");
            FileReader freader = new FileReader(file);
            BufferedReader rein = new BufferedReader(freader);
            readString = rein.readLine();
            System.out.println(readString);
            for (int i = 0; i < 3; ++i) {
                readString = rein.readLine();
                System.out.println(readString);
                StringTokenizer st = new StringTokenizer(readString);
                this.bvec[i][0] = Double.parseDouble(st.nextToken());
                this.bvec[i][1] = Double.parseDouble(st.nextToken());
                this.bvec[i][2] = Double.parseDouble(st.nextToken());
            }
        }
        catch (Exception e) {
            System.out.println("failed read from: " + file);
            this.calrk = false;
        }
    }

    private void askForBandKpointIn() {
        Object[] init = new Object[]{"specify input file", "ignore"};
        Component component = null;
        ImageIcon icon = new ImageIcon("logo.png");
        int ret = JOptionPane.showInternalOptionDialog(Desktop.getDesktop(), "couldn't find input file for band_kpoint.pl!", "warning", 0, 2, null, init, init[0]);
        if (ret == 0) {
            ChaseFileChooser fdlg = new ChaseFileChooser();
            fdlg.setDialogType(2);
            fdlg.setDialogTitle("Open");
            fdlg.setCurrentDirectory(new File(this.projdir));
            fdlg.setFileSelectionMode(0);
            if (fdlg.showDialog(component, "open") != 0) {
                System.out.println("no specification for bandkpoint.in ...");
                this.calrk = false;
            } else {
                String bandkpointin = fdlg.getSelectedFile().getAbsolutePath();
                this.readBandKpointIn(new File(bandkpointin));
            }
        } else {
            System.out.println("no specification for bandkpoint.in ...");
            this.calrk = false;
        }
    }

    public void parseString(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        boolean bloopisData = false;
        if (str.trim().startsWith("num_kpoints")) {
            st.nextToken();
            st.nextToken();
            try {
                this.numKpoints = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                System.out.println("invalid num_kpoints!");
            }
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("num_bands")) {
            st.nextToken();
            st.nextToken();
            try {
                this.numBands = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                System.out.println("invalid num_bands!");
            }
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("nspin")) {
            st.nextToken();
            st.nextToken();
            try {
                this.nspin = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                System.out.println("invalid nspin!");
            }
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("Valence")) {
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("===")) {
            bloopisData = false;
        } else if (str.trim().startsWith("Fermi")) {
            bloopisData = false;
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
        } else {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (strdata.trim().startsWith("ik")) {
                    st.nextToken();
                    String ik = st.nextToken();
                    st.nextToken();
                    String kx = st.nextToken();
                    String ky = st.nextToken();
                    String kz = st.nextToken();
                    if (kz.endsWith(")")) {
                        char[] ch = kz.toCharArray();
                        kz = new String(ch, 0, ch.length - 1);
                    }
                    String next = st.nextToken();
                    if (this.nspin == 2) {
                        this.updown = next;
                    }
                    if (this.updown.equals("UP")) {
                        this.kinfo.addElement(ik);
                        this.kinfo.addElement(kx);
                        this.kinfo.addElement(ky);
                        this.kinfo.addElement(kz);
                        if (this.calrk) {
                            double dkx = Double.parseDouble(kx);
                            double dky = Double.parseDouble(ky);
                            double dkz = Double.parseDouble(kz);
                            double[] dkc = new double[3];
                            for (int i = 0; i < 3; ++i) {
                                dkc[i] = this.bvec[i][0] * (this.dkxp - dkx) + this.bvec[i][1] * (this.dkyp - dky) + this.bvec[i][2] * (this.dkzp - dkz);
                            }
                            this.dk = this.dkp + Math.sqrt(Math.pow(dkc[0], 2.0) + Math.pow(dkc[1], 2.0) + Math.pow(dkc[2], 2.0));
                            if (!this.iskoriginSet) {
                                this.korigin = this.dk;
                                this.iskoriginSet = true;
                            }
                            this.kinfo.addElement(Double.toString(this.dk - this.korigin));
                            this.dkxp = dkx;
                            this.dkyp = dky;
                            this.dkzp = dkz;
                            this.dkp = this.dk;
                        } else {
                            this.kinfo.addElement("0.0");
                        }
                    }
                    bloopisData = false;
                    return;
                }
                ++this.numEig;
                bloopisData = true;
                if (this.updown.equals("UP")) {
                    this.eigUp.addElement(strdata);
                } else if (this.updown.equals("DOWN")) {
                    this.eigDown.addElement(strdata);
                }
                if (this.isColumnNameSet) continue;
                if (this.nspin == 1) {
                    this.colNametmp.addElement("eig" + this.numEig);
                    continue;
                }
                if (this.nspin != 2) continue;
                this.colNametmp.addElement("eig" + this.numEig + " " + this.updown);
            }
        }
        if (bloopisData && this.numEig == this.numBands * this.nspin) {
            this.isColumnNameSet = true;
            this.numEig = 0;
        }
    }

    protected void processData() {
        int numcols = this.colNametmp.size();
        for (int i = 0; i < numcols; ++i) {
            this.addColumnName((String)this.colNametmp.get(i));
        }
        this.setNumColumns(numcols);
        int numData = this.kinfo.size();
        int numLoop = numData / 5;
        for (int i = 0; i < numLoop; ++i) {
            int j;
            for (j = 0; j < 5; ++j) {
                this.addDataColumn((String)this.kinfo.get(i * 5 + j));
            }
            for (j = 0; j < this.numBands; ++j) {
                this.addDataColumn((String)this.eigUp.get(i * this.numBands + j));
            }
            if (this.nspin == 2) {
                for (j = 0; j < this.numBands; ++j) {
                    this.addDataColumn((String)this.eigDown.get(i * this.numBands + j));
                }
            }
            this.addDataRow();
        }
    }
}

