/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Date;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.HighLowDataset;

public class DefaultHighLowDataset
extends AbstractSeriesDataset
implements HighLowDataset {
    private String seriesName;
    private Date[] date;
    private Number[] high;
    private Number[] low;
    private Number[] open;
    private Number[] close;
    private Number[] volume;

    public DefaultHighLowDataset(String seriesName, Date[] date, double[] high, double[] low, double[] open, double[] close, double[] volume) {
        this.seriesName = seriesName;
        this.date = date;
        this.high = DefaultHighLowDataset.createNumberArray(high);
        this.low = DefaultHighLowDataset.createNumberArray(low);
        this.open = DefaultHighLowDataset.createNumberArray(open);
        this.close = DefaultHighLowDataset.createNumberArray(close);
        this.volume = DefaultHighLowDataset.createNumberArray(volume);
    }

    public String getSeriesName(int i) {
        return this.seriesName;
    }

    public Number getXValue(int series, int item) {
        return new Long(this.date[item].getTime());
    }

    public Date getXDate(int series, int item) {
        return this.date[item];
    }

    public Number getYValue(int series, int item) {
        return this.getCloseValue(series, item);
    }

    public Number getHighValue(int series, int item) {
        return this.high[item];
    }

    public Number getLowValue(int series, int item) {
        return this.low[item];
    }

    public Number getOpenValue(int series, int item) {
        return this.open[item];
    }

    public Number getCloseValue(int series, int item) {
        return this.close[item];
    }

    public Number getVolumeValue(int series, int item) {
        return this.volume[item];
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int series) {
        return this.date.length;
    }

    public static Number[] createNumberArray(double[] data) {
        Number[] result = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = new Double(data[i]);
        }
        return result;
    }
}

