/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class ScalarInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFFloat keyValueField;
    private SFFloat valueField;

    public ScalarInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.SCALARINTERP);
        this.keyValueField = new MFFloat();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFFloat(0.0f);
        this.addEventOut("value", this.valueField);
    }

    public ScalarInterpolatorNode(ScalarInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFFloat getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFFloat)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float value) {
        this.getKeyValueField().addValue(value);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float value) {
        this.getKeyValueField().set1Value(index, value);
    }

    public void setKeyValues(String value) {
        this.getKeyValueField().setValues(value);
    }

    public void setKeyValues(String[] value) {
        this.getKeyValueField().setValues(value);
    }

    public float getKeyValue(int index) {
        return this.getKeyValueField().get1Value(index);
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFFloat getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFFloat)this.getEventOut("value");
    }

    public void setValue(float vector) {
        this.getValueField().setValue(vector);
    }

    public void setValue(String vector) {
        this.getValueField().setValue(vector);
    }

    public float getValue() {
        return this.getValueField().getValue();
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        for (int n = 0; n < this.getNKeys() - 1; ++n) {
            if (!(this.getKey(n) <= fraction) || !(fraction <= this.getKey(n + 1))) continue;
            index = n;
            break;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float value1 = this.getKeyValue(index);
        float value2 = this.getKeyValue(index + 1);
        float valueOut = value1 + (value2 - value1) * scale;
        this.setValue(valueOut);
        this.sendEvent(this.getValueField());
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        int n;
        printStream.println(indentString + "\tkey [");
        for (n = 0; n < this.getNKeys(); ++n) {
            if (n < this.getNKeys() - 1) {
                printStream.println(indentString + "\t\t" + this.getKey(n));
                continue;
            }
            printStream.println(indentString + "\t\t" + this.getKey(n));
        }
        printStream.println(indentString + "\t]");
        printStream.println(indentString + "\tkeyValue [");
        for (n = 0; n < this.getNKeyValues(); ++n) {
            if (n < this.getNKeyValues() - 1) {
                printStream.println(indentString + "\t\t" + this.getKeyValue(n));
                continue;
            }
            printStream.println(indentString + "\t\t" + this.getKeyValue(n));
        }
        printStream.println(indentString + "\t]");
    }
}

