/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class BoxNode
extends Geometry3DNode {
    private static final String sizeFieldName = "size";
    private SFVec3f sizeField;

    public BoxNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.BOX);
        this.sizeField = new SFVec3f(2.0f, 2.0f, 2.0f);
        this.sizeField.setName(sizeFieldName);
        this.addExposedField(this.sizeField);
    }

    public BoxNode(BoxNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFVec3f getSizeField() {
        if (!this.isInstanceNode()) {
            return this.sizeField;
        }
        return (SFVec3f)this.getExposedField(sizeFieldName);
    }

    public void setSize(float[] value) {
        this.getSizeField().setValue(value);
    }

    public void setSize(float x, float y, float z) {
        this.getSizeField().setValue(x, y, z);
    }

    public void setSize(String value) {
        this.getSizeField().setValue(value);
    }

    public void getSize(float[] value) {
        this.getSizeField().getValue(value);
    }

    public float getX() {
        return this.getSizeField().getX();
    }

    public float getY() {
        return this.getSizeField().getY();
    }

    public float getZ() {
        return this.getSizeField().getZ();
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
        this.updateBoundingBox();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void updateBoundingBox() {
        this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
        this.setBoundingBoxSize(this.getX() / 2.0f, this.getY() / 2.0f, this.getZ() / 2.0f);
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] value = new float[3];
        this.getSize(value);
        printStream.println(indentString + "\t" + "size " + value[0] + " " + value[1] + " " + value[2]);
    }
}

