/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class RemoteStdOut
implements Runnable {
    private Logger logger = Logger.getLogger(RemoteStdOut.class.getName());
    private Session session;
    private JTextArea textArea;
    private String command;
    private boolean stop = false;
    private Process p;
    public static int APPEND = 0;
    public static int REPLACE = 1;
    private int mode = APPEND;
    private Channel channel;
    private OutputStream out;
    private InputStream in;
    private int bufSize = 5096;
    private byte[] tmpBuf = new byte[this.bufSize];

    public RemoteStdOut(Session session, String command, JTextArea textArea) {
        this.session = session;
        this.textArea = textArea;
        this.command = command;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void doIt() {
        this.stop = false;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block43: {
            if (this.session == null) {
                InputStream is = null;
                this.p = null;
                try {
                    this.p = Runtime.getRuntime().exec(this.command);
                    is = this.p.getInputStream();
                    while (is.available() >= 0) {
                        if (this.stop) return;
                        int i = is.read(this.tmpBuf, 0, this.bufSize);
                        if (i < 0) {
                            return;
                        }
                        String str = new String(this.tmpBuf, 0, i);
                        this.textArea.append(str);
                        this.textArea.setCaretPosition(this.textArea.getText().length());
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                finally {
                    this.logger.debug("at finally");
                    try {
                        is.close();
                    }
                    catch (Exception exc) {}
                    if (this.p != null) {
                        this.p.destroy();
                    }
                }
            }
            if (!this.session.isConnected()) {
                this.logger.error("not connected.");
                return;
            }
            try {
                if (this.channel == null && this.mode == APPEND) {
                    this.channel = this.session.openChannel("shell");
                    this.channel.connect();
                    this.out = this.channel.getOutputStream();
                    this.in = this.channel.getInputStream();
                    break block43;
                }
                if (this.mode == REPLACE) {
                    this.channel = this.session.openChannel("exec");
                    ((ChannelExec)this.channel).setCommand(this.command);
                    this.channel.connect();
                    this.in = this.channel.getInputStream();
                }
            }
            catch (Exception exc) {
                this.logger.error("failed to open channel.");
                return;
            }
        }
        if (this.mode == APPEND) {
            try {
                byte[] tmp = this.command.getBytes();
                this.out.write(tmp, 0, tmp.length);
                byte[] enter = new byte[]{13};
                this.out.write(enter, 0, enter.length);
                this.out.flush();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        try {
            this.logger.debug("in.available? " + this.in.available());
            while (this.in.available() >= 0) {
                if (this.channel.isEOF()) return;
                if (this.stop) {
                    this.textArea.setText("");
                    return;
                }
                int i = this.in.read(this.tmpBuf, 0, this.bufSize);
                if (i < 0) {
                    return;
                }
                Channel channel = this.channel;
                synchronized (channel) {
                    String str = new String(this.tmpBuf, 0, i);
                    if (this.mode == APPEND) {
                        this.textArea.append(str);
                        this.textArea.setCaretPosition(this.textArea.getText().length());
                    } else if (this.mode == REPLACE) {
                        this.textArea.setText(str);
                    }
                }
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            this.logger.debug("at 'finally'");
            if (this.mode == REPLACE) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
                this.channel.disconnect();
            }
        }
    }

    public void terminate() {
        this.stop = true;
        this.logger.debug("terminating...");
        if (this.p != null) {
            this.p.destroy();
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
    }
}

