/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class ProjectManipulator
extends JPanel {
    private static Logger logger = Logger.getLogger(ProjectManipulator.class.getName());
    public static String PROJECT_MANIPULATOR_XML_PATH = "/ciss/phase_viewer/projectbrowser/ProjectManipulator.xml";
    protected ProjectInfo projectInfo;
    protected Object[] args;
    protected static final String FS = System.getProperty("file.separator");

    public ProjectManipulator(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public ProjectManipulator(ProjectInfo projectInfo, Object[] args) {
        this.projectInfo = projectInfo;
        this.args = args;
    }

    public static ProjectManipulator createProjectManipulator(ProjectInfo info) {
        String type = info.getProjectType();
        URL projurl = null;
        projurl = ProjectManipulator.class.getResource(PROJECT_MANIPULATOR_XML_PATH);
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(projurl);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + projurl);
            logger.error("unrecoverable error.");
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + projurl);
            logger.error("unrecoverable error.");
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error("invalid ProjectSpecification file.");
        }
        List list = elem.getChildren("project");
        String loadclass = null;
        for (int i = 0; i < list.size(); ++i) {
            String si;
            String[] sizr;
            Element element = (Element)list.get(i);
            String name = MyElement.decode(element.getChildTextTrim("name"));
            if (!name.equals(type)) continue;
            loadclass = element.getChildTextTrim("loadclass");
            Element initSize = element.getChild("init_size");
            if (initSize == null || (sizr = (si = initSize.getTextTrim()).split(",")) == null || sizr.length < 2) break;
            try {
                Dimension initBrowserSize = new Dimension(Integer.parseInt(sizr[0]), Integer.parseInt(sizr[1]));
                info.setInitialBrowserSize(initBrowserSize);
            }
            catch (Exception exc) {}
            break;
        }
        if (loadclass == null) {
            logger.error("failed to get a valid class name to load.");
        }
        if (loadclass.equalsIgnoreCase("null")) {
            return null;
        }
        ProjectManipulator manip = (ProjectManipulator)PluginLoader.instantiate(loadclass, new Object[]{info});
        return manip;
    }

    public abstract void init();

    public abstract void initializeProject();

    public void initializeProject(ProjectDirBrowserNode node) {
    }

    public boolean postProcess() {
        return true;
    }

    public void recreate() {
    }

    public void postInit() {
    }

    public void buttonPressed() {
    }

    public void componentSet() {
    }
}

