/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import org.apache.log4j.Logger;

public class CheckBoxPhase
extends JCheckBox
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(CheckBoxPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private Vector disabableGUIs = new Vector();
    private ActionListener[] alists;

    public CheckBoxPhase(String[] inputSpecifications, InputInterface inputinterface, String title) {
        super(title);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public void silentUpdate() {
        boolean b2 = super.isSelected();
        String newText = "0";
        if (b2) {
            newText = "1";
        }
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(this.inputSpecifications[0]);
        String[] fn = this.inputSpecifications[0].split("\\.");
        String name = fn[fn.length - 1];
        entry.setUnit("");
        entry.setValue(newText.trim());
        this.inputinterface.replaceEntry(entry, this, false);
        logger.debug("replaced: " + entry.getName() + "=" + entry.getValue());
    }

    public void execute(EventObject e) {
        if (e instanceof ItemEvent) {
            logger.debug("item event...");
        } else if (e instanceof ActionEvent) {
            logger.debug("actionevent...");
        } else if (e instanceof PopupMenuEvent) {
            logger.debug("pop-up menu event...");
        }
        String newText = "0";
        if (super.isSelected()) {
            newText = "1";
        }
        logger.debug("inputSpec: " + this.inputSpecifications[0]);
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(this.inputSpecifications[0]);
        String[] fn = this.inputSpecifications[0].split("\\.");
        String name = fn[fn.length - 1];
        entry.saveState();
        entry.setName(name);
        entry.setValue(newText.trim());
        this.inputinterface.replaceEntry(entry, this);
        logger.debug("replaced: " + entry.getName() + "=" + entry.getValue());
        logger.debug("at : " + this.inputinterface.getCurrentBlock().getFullName());
        this.disableRegisteredGUI();
    }

    public void disableRegisteredGUI() {
        for (int i = 0; i < this.disabableGUIs.size(); ++i) {
            Vector disset = (Vector)this.disabableGUIs.get(i);
            JComponent jcomponent = (JComponent)disset.get(0);
            boolean bb = super.isSelected();
            jcomponent.setEnabled(bb);
        }
    }

    public void inputInterfaceInitializing() {
    }

    public void inputInterfaceInitialized() {
    }

    public void removeListeners() {
        this.alists = this.getActionListeners();
        if (this.alists != null) {
            for (int i = 0; i < this.alists.length; ++i) {
                this.removeActionListener(this.alists[i]);
            }
        }
    }

    public void restoreListeners() {
        if (this.alists != null) {
            for (int i = 0; i < this.alists.length; ++i) {
                this.addActionListener(this.alists[i]);
            }
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        logger.debug("at inputInterfaceEntryChanged");
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 0) {
            return;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        String fullName = tag + "." + pentry.getName();
        String rep = "";
        rep = pentry.getValue();
        if (rep == null || rep.trim().length() == 0) {
            return;
        }
        boolean bb = InputInterface.isTrue(rep.trim());
        this.removeListeners();
        for (int ii = 0; ii < this.inputSpecifications.length; ++ii) {
            if (!fullName.trim().equalsIgnoreCase(this.inputSpecifications[ii].trim())) continue;
            logger.debug("replace string: " + rep + " (fullName: " + fullName + ")");
            this.setSelected(bb);
        }
        this.restoreListeners();
    }

    public void setDisabableGUI(JComponent jcomponent) {
        Vector<JComponent> disset = new Vector<JComponent>();
        disset.addElement(jcomponent);
        this.disabableGUIs.addElement(disset);
    }
}

