/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.jdom;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class MyElement
extends Element {
    private static Logger logger = Logger.getLogger(MyElement.class.getName());

    protected MyElement() {
    }

    public MyElement(String name) {
        super(name);
    }

    public MyElement(String name, Namespace namespace) {
        super(name, namespace);
    }

    public MyElement(String name, String uri) {
        super(name, uri);
    }

    public MyElement(String name, String prefix, String uri) {
        super(name, prefix, uri);
    }

    public Element setText(String text) {
        String newtext = MyElement.encode(text);
        return super.setText(newtext);
    }

    public String getText() {
        return MyElement.decode(super.getText());
    }

    public String getTextTrim() {
        return MyElement.decode(super.getTextTrim());
    }

    public String getChildTextNormalize(String name) {
        return MyElement.decode(super.getChildTextNormalize(name));
    }

    public String getChildTextNormalize(String name, Namespace ns) {
        return MyElement.decode(super.getChildTextNormalize(name, ns));
    }

    public String getChildTextTrim(String name) {
        return MyElement.decode(super.getChildTextTrim(name));
    }

    public String getChildTextTrim(String name, Namespace ns) {
        return MyElement.decode(this.getChildTextTrim(name, ns));
    }

    public String getChildText(String name, Namespace ns) {
        return MyElement.decode(this.getChildText(name, ns));
    }

    public static String encode(String text) {
        if (text == null) {
            return "";
        }
        String newtext = "";
        try {
            newtext = URLEncoder.encode(text, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("unsupported encoding...");
            newtext = "";
        }
        return newtext;
    }

    public static String decode(String text) {
        if (text == null) {
            return "";
        }
        String ret = "";
        try {
            ret = URLDecoder.decode(text, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("unsupported encoding...");
            ret = "";
        }
        return ret;
    }
}

