/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.dataset;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.graph.dataset.DataSet;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DataSetExporter
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(DataSetExporter.class.getName());
    private DataSet[] dset;
    private DataSetExporterSubPanel[] subPanels;
    private String dir;
    private JInternalFrame me;

    public DataSetExporter(DataSet[] dset) {
        super("export dataset", true, true, true, true, new Dimension(600, 380));
        this.dset = dset;
        this.me = this;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane scr = new JScrollPane();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        this.subPanels = new DataSetExporterSubPanel[this.dset.length];
        for (int i = 0; i < this.dset.length; ++i) {
            this.subPanels[i] = new DataSetExporterSubPanel(this.dset[i]);
            gc.gridy = i;
            p.add((Component)this.subPanels[i], gc);
        }
        scr.setPreferredSize(new Dimension(300, 300));
        scr.getViewport().setView(p);
        this.getContentPane().add((Component)scr, "North");
        this.getContentPane().add((Component)this.createBtnPanel(), "South");
    }

    private JPanel createBtnPanel() {
        JPanel p = new JPanel();
        JButton btndo = new JButton("do export");
        JButton btnclose = new JButton("close");
        p.setLayout(new BoxLayout(p, 0));
        p.add(btndo);
        p.add(btnclose);
        btndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < DataSetExporter.this.subPanels.length; ++i) {
                    DataSetExporter.this.subPanels[i].doExport();
                }
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetExporter.this.dispose();
            }
        });
        JPanel ret = new JPanel();
        ret.add(p);
        return ret;
    }

    class DataSetExporterSubPanel
    extends JPanel {
        private DataSet dataSet;
        private JTextField tffilename;
        private JCheckBox checkBox;
        int nameLength = 12;

        DataSetExporterSubPanel(DataSet dataSet) {
            this.dataSet = dataSet;
            this.setLayout(new GridBagLayout());
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doExport() {
            if (!this.checkBox.isSelected()) {
                DataSetExporter.this.logger.debug("check box not selected! export not executed.");
                return;
            }
            File writeTo = new File(this.tffilename.getText());
            FileWriter writer = null;
            PrintWriter pwriter = null;
            try {
                writer = new FileWriter(writeTo);
                pwriter = new PrintWriter(writer);
                DataSetElement[] dse = this.dataSet.getData();
                if (dse == null || dse.length == 0) {
                    return;
                }
                String[] idents = new String[dse.length];
                pwriter.print("#");
                for (int i = 0; i < idents.length; ++i) {
                    pwriter.print(" " + dse[i].getName());
                }
                pwriter.println("");
                int numData = dse[0].getData().length;
                for (int i = 0; i < numData; ++i) {
                    for (int j = 0; j < idents.length; ++j) {
                        String[] ar = dse[j].getData();
                        if (ar == null || ar.length == 0) continue;
                        pwriter.print(ar[i] + " ");
                    }
                    pwriter.println("");
                }
            }
            catch (IOException ioe) {
                DataSetExporter.this.logger.error("error encountered while exporting data set " + this.dataSet.getName() + " to " + writeTo.getAbsolutePath());
            }
            finally {
                try {
                    writer.close();
                    pwriter.close();
                }
                catch (IOException ioe) {}
            }
        }

        private void init() {
            File origFile;
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            JPanel pdsetname = new JPanel();
            String name = this.dataSet.getName();
            if (name.length() < this.nameLength) {
                for (int i = name.length(); i < this.nameLength; ++i) {
                    name = name + " ";
                }
            } else if (name.length() >= this.nameLength) {
                name = name.substring(0, this.nameLength - 1);
            }
            JLabel labeldset = new JLabel("dataset: " + name);
            labeldset.setFont(new Font("Monospaced", 0, 12));
            labeldset.setToolTipText(this.dataSet.getName());
            pdsetname.add(labeldset);
            this.add((Component)pdsetname, gc);
            JPanel pfilename = new JPanel();
            pfilename.setLayout(new BorderLayout());
            pfilename.setBorder(new TitledBorder("enter filename"));
            this.tffilename = new JTextField(30);
            File newFile = origFile = new File(new File(this.dataSet.getFileName()).getParent() + System.getProperty("file.separator") + this.dataSet.getName() + ".data");
            int count = 1;
            while (newFile.exists()) {
                newFile = new File(origFile.getAbsolutePath() + String.valueOf(count));
                ++count;
            }
            this.tffilename.setText(newFile.getAbsolutePath());
            pfilename.add((Component)this.tffilename, "West");
            JButton btn = new JButton("choose");
            pfilename.add((Component)btn, "Center");
            gc.gridx = 1;
            this.add((Component)pfilename, gc);
            JPanel pmanip = new JPanel();
            this.checkBox = new JCheckBox("export this data set");
            pmanip.add(this.checkBox);
            gc.gridx = 2;
            this.add((Component)pmanip, gc);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChaseFileChooser fdlg = new ChaseFileChooser();
                    fdlg.setDialogType(2);
                    fdlg.setDialogTitle("select");
                    fdlg.setFileSelectionMode(0);
                    if (fdlg.showDialog(DataSetExporter.this.me, "open") != 0) {
                        return;
                    }
                    String path = fdlg.getSelectedFile().getAbsolutePath();
                    DataSetExporterSubPanel.this.tffilename.setText(path);
                }
            });
        }
    }
}

