/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.filebrowser;

import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.filebrowser.FileBrowserNode;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class DefaultFileBrowserNode
extends FileBrowserNode {
    private Logger logger = Logger.getLogger(DefaultFileBrowserNode.class.getName());
    protected FileBrowserTree tree;

    public DefaultFileBrowserNode(Object userObject) {
        super(userObject);
    }

    public void mousePressed(MouseEvent e, FileBrowserTree tree) {
        if (e.getButton() == 3) {
            this.tree = tree;
            this.showMenu(e);
        }
    }

    protected void showMenu(MouseEvent e) {
        if (e == null) {
            this.logger.error("MouseEvent is null");
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        MyJMenuItem[] items = this.getDefaultMenuItems();
        for (int i = 0; i < items.length; ++i) {
            popup.add(items[i]);
        }
        if (e.getComponent() == null) {
            this.logger.error("e.getComponent() returns null...something is wrong!");
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected MyJMenuItem[] getDefaultMenuItems() {
        MyJMenuItem locdel = new MyJMenuItem("delete", 68);
        MyJMenuItem locchfname = new MyJMenuItem("rename", 67);
        MyJMenuItem locmkdir = new MyJMenuItem("create new dir", 78);
        MyJMenuItem locprops = new MyJMenuItem("property", 80);
        MyJMenuItem locnewfile = new MyJMenuItem("create new file", 70);
        MyJMenuItem locedit = new MyJMenuItem("editor", 69);
        MyJMenuItem[] ret = new MyJMenuItem[]{locchfname, locmkdir, locnewfile, locprops, locdel, locedit};
        locdel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.deleteSelectedFiles();
            }
        });
        locchfname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.rename();
            }
        });
        locmkdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.mkdir();
            }
        });
        locprops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.bootFilePropertyViewer();
            }
        });
        locedit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.bootProgram(true);
            }
        });
        locnewfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultFileBrowserNode.this.tree.createNewFile();
            }
        });
        return ret;
    }

    public void mouseClicked(MouseEvent e, FileBrowserTree tree) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            tree.bootProgram(false);
        }
    }
}

