/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.util.PublicCloneable;

public class IntervalCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
CategoryToolTipGenerator,
PublicCloneable,
Cloneable,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public IntervalCategoryItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public IntervalCategoryItemLabelGenerator(NumberFormat formatter) {
        this.numberFormat = formatter;
        this.dateFormat = null;
    }

    public IntervalCategoryItemLabelGenerator(DateFormat formatter) {
        this.numberFormat = null;
        this.dateFormat = formatter;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset data, int series, int category) {
        Number value;
        Number start = value = data.getValue(series, category);
        Number end = value;
        if (data instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
            start = icd.getStartValue(series, category);
            end = icd.getEndValue(series, category);
        }
        String result = null;
        if (start != null && end != null) {
            Comparable seriesName = data.getRowKey(series);
            result = seriesName != null ? seriesName.toString() + ", " : "";
            String categoryName = data.getColumnKey(category).toString();
            String startString = null;
            String endString = null;
            if (this.numberFormat != null) {
                startString = this.numberFormat.format(start);
                endString = this.numberFormat.format(end);
            } else if (this.dateFormat != null) {
                startString = this.dateFormat.format(start);
                endString = this.dateFormat.format(end);
            }
            result = result + categoryName + " : " + startString + " to " + endString;
        }
        return result;
    }

    public String generateItemLabel(CategoryDataset data, int series, int category) {
        Number value;
        Number start = value = data.getValue(series, category);
        Number end = value;
        if (data instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
            start = icd.getStartValue(series, category);
            end = icd.getEndValue(series, category);
        }
        String result = null;
        if (start != null && end != null) {
            String startString = null;
            String endString = null;
            if (this.numberFormat != null) {
                startString = this.numberFormat.format(start);
                endString = this.numberFormat.format(end);
            } else if (this.dateFormat != null) {
                startString = this.dateFormat.format(start);
                endString = this.dateFormat.format(end);
            }
            result = startString + " - " + endString;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof IntervalCategoryItemLabelGenerator) {
            IntervalCategoryItemLabelGenerator generator = (IntervalCategoryItemLabelGenerator)o;
            if (this.dateFormat != null) {
                return this.dateFormat.equals(generator.dateFormat);
            }
            return this.numberFormat.equals(generator.numberFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        IntervalCategoryItemLabelGenerator clone = (IntervalCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            clone.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            clone.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return clone;
    }
}

